/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.json.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.OpenPlatformAuthGetLicenseInformationResponse;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensingInformation;
import io.github.rcarlosdasilva.weixin.model.response.open.auth.bean.LicensorInfromation;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPlatformAuthGetLicenseInformationResponseTypeAdapter
extends TypeAdapter<OpenPlatformAuthGetLicenseInformationResponse> {
    private static final String LOG_UNKNOWN_JSON_KEY = "\u672a\u77e5\u7684json\u952e\u503c\uff1a [{}: {}]";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void write(JsonWriter out, OpenPlatformAuthGetLicenseInformationResponse value) throws IOException {
    }

    public OpenPlatformAuthGetLicenseInformationResponse read(JsonReader in) throws IOException {
        OpenPlatformAuthGetLicenseInformationResponse model = new OpenPlatformAuthGetLicenseInformationResponse();
        in.beginObject();
        block14: while (in.hasNext()) {
            String key;
            switch (key = in.nextName()) {
                case "authorization_info": {
                    this.readLicensedAccessToken(in, model);
                    continue block14;
                }
                case "authorizer_info": {
                    this.readLicensorInformation(in, model);
                    continue block14;
                }
                case "authorizer_access_token": {
                    model.getLicensedAccessToken().setAccessToken(in.nextString());
                    continue block14;
                }
                case "expires_in": {
                    model.getLicensedAccessToken().setExpiresIn(in.nextInt());
                    continue block14;
                }
                case "authorizer_refresh_token": {
                    model.getLicensedAccessToken().setRefreshToken(in.nextString());
                    continue block14;
                }
            }
            if (!in.hasNext()) continue;
            String value = in.nextString();
            this.logger.warn(LOG_UNKNOWN_JSON_KEY, (Object)key, (Object)value);
        }
        in.endObject();
        return model;
    }

    private void readLicensedAccessToken(JsonReader in, OpenPlatformAuthGetLicenseInformationResponse model) throws IOException {
        LicensingInformation licensingInformation = new LicensingInformation();
        in.beginObject();
        block15: while (in.hasNext()) {
            String key;
            switch (key = in.nextName()) {
                case "appid": 
                case "authorizer_appid": {
                    licensingInformation.setAppId(in.nextString());
                    continue block15;
                }
                case "authorizer_access_token": {
                    model.getLicensedAccessToken().setAccessToken(in.nextString());
                    continue block15;
                }
                case "expires_in": {
                    model.getLicensedAccessToken().setExpiresIn(in.nextInt());
                    continue block15;
                }
                case "authorizer_refresh_token": {
                    model.getLicensedAccessToken().setRefreshToken(in.nextString());
                    continue block15;
                }
                case "func_info": {
                    in.beginArray();
                    while (in.hasNext()) {
                        in.beginObject();
                        in.nextName();
                        in.beginObject();
                        in.nextName();
                        licensingInformation.addLicencedFunction(in.nextInt());
                        in.endObject();
                        in.endObject();
                    }
                    in.endArray();
                    continue block15;
                }
            }
            if (!in.hasNext()) continue;
            String value = in.nextString();
            this.logger.warn(LOG_UNKNOWN_JSON_KEY, (Object)key, (Object)value);
        }
        in.endObject();
        model.setLicensingInformation(licensingInformation);
    }

    private void readLicensorInformation(JsonReader in, OpenPlatformAuthGetLicenseInformationResponse model) throws IOException {
        LicensorInfromation licensorInfromation = new LicensorInfromation();
        in.beginObject();
        block22: while (in.hasNext()) {
            String key;
            switch (key = in.nextName()) {
                case "nick_name": {
                    licensorInfromation.setNickName(in.nextString());
                    continue block22;
                }
                case "head_img": {
                    licensorInfromation.setLogo(in.nextString());
                    continue block22;
                }
                case "service_type_info": {
                    in.beginObject();
                    in.nextName();
                    licensorInfromation.setAccountType(in.nextInt());
                    in.endObject();
                    continue block22;
                }
                case "verify_type_info": {
                    in.beginObject();
                    in.nextName();
                    licensorInfromation.setAccountVerifiedType(in.nextInt());
                    in.endObject();
                    continue block22;
                }
                case "user_name": {
                    licensorInfromation.setMpId(in.nextString());
                    continue block22;
                }
                case "principal_name": {
                    licensorInfromation.setPrincipalName(in.nextString());
                    continue block22;
                }
                case "alias": {
                    licensorInfromation.setAccountName(in.nextString());
                    continue block22;
                }
                case "qrcode_url": {
                    licensorInfromation.setQrCodeUrl(in.nextString());
                    continue block22;
                }
                case "business_info": {
                    this.readBusinessInfo(in, licensorInfromation);
                    continue block22;
                }
            }
            if (!in.hasNext()) continue;
            String value = in.nextString();
            this.logger.warn(LOG_UNKNOWN_JSON_KEY, (Object)key, (Object)value);
        }
        in.endObject();
        model.setLicensorInfromation(licensorInfromation);
    }

    private void readBusinessInfo(JsonReader in, LicensorInfromation licensorInfromation) throws IOException {
        in.beginObject();
        block14: while (in.hasNext()) {
            String key;
            switch (key = in.nextName()) {
                case "open_store": {
                    licensorInfromation.setBusinessStoreOpened(in.nextInt() == 1);
                    continue block14;
                }
                case "open_scan": {
                    licensorInfromation.setBusinessScanOpened(in.nextInt() == 1);
                    continue block14;
                }
                case "open_pay": {
                    licensorInfromation.setBusinessPayOpened(in.nextInt() == 1);
                    continue block14;
                }
                case "open_card": {
                    licensorInfromation.setBusinessCardOpened(in.nextInt() == 1);
                    continue block14;
                }
                case "open_shake": {
                    licensorInfromation.setBusinessShakeOpened(in.nextInt() == 1);
                    continue block14;
                }
            }
            if (!in.hasNext()) continue;
            String value = in.nextString();
            this.logger.warn(LOG_UNKNOWN_JSON_KEY, (Object)key, (Object)value);
        }
        in.endObject();
    }
}

