/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.parser;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import io.github.rcarlosdasilva.weixin.common.dictionary.NotificationInfoType;
import io.github.rcarlosdasilva.weixin.common.dictionary.NotificationMessageType;
import io.github.rcarlosdasilva.weixin.model.notification.Event;
import io.github.rcarlosdasilva.weixin.model.notification.Message;
import io.github.rcarlosdasilva.weixin.model.notification.Notification;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponse;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponseEncrypted;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponsePlaintext;
import io.github.rcarlosdasilva.weixin.model.notification.OpenInfo;
import java.io.Writer;

public class NotificationParser {
    private static final XStream xs = new XStream((HierarchicalStreamDriver)new Xpp3Driver(){

        public HierarchicalStreamWriter createWriter(Writer out) {
            String prefixCdata = "<![CDATA[";
            String suffixCdata = "]]>";
            return new PrettyPrintWriter(out){
                private boolean needCdata;

                public void setValue(String text) {
                    this.needCdata = !text.matches("^[0-9]+\\.?[0-9]{0,6}$");
                    super.setValue(text);
                }

                protected void writeText(QuickWriter writer, String text) {
                    if (this.needCdata && !text.startsWith("<![CDATA[") && !text.endsWith("]]>")) {
                        writer.write("<![CDATA[" + text + "]]>");
                    } else {
                        writer.write(text);
                    }
                }
            };
        }
    });

    private NotificationParser() {
        throw new IllegalStateException("NotificationParser class");
    }

    public static Notification parse(String xmlString) {
        NotificationInfoType infoType;
        Preconditions.checkNotNull((Object)xmlString, (Object)"Notification content is empty from weixin.");
        xmlString = xmlString.replaceAll("xml>", "notification>");
        Notification notification = (Notification)xs.fromXML(xmlString);
        NotificationMessageType messagetype = notification.getMessageType();
        if (messagetype != null) {
            if (messagetype == NotificationMessageType.EVENT) {
                xmlString = xmlString.replaceAll("notification>", "event>");
                Event event = (Event)xs.fromXML(xmlString);
                notification.setEvent(event);
            } else {
                xmlString = xmlString.replaceAll("notification>", "message>");
                Message message = (Message)xs.fromXML(xmlString);
                notification.setMessage(message);
            }
        }
        if ((infoType = notification.getInfoType()) != null) {
            xmlString = xmlString.replaceAll("notification>", "info>");
            OpenInfo openInfo = (OpenInfo)xs.fromXML(xmlString);
            notification.setOpenInfo(openInfo);
        }
        return notification;
    }

    public static String toXml(NotificationResponse response) {
        return xs.toXML((Object)response);
    }

    static {
        xs.ignoreUnknownElements();
        xs.processAnnotations(new Class[]{Notification.class, Event.class, Message.class, NotificationResponsePlaintext.class, NotificationResponseEncrypted.class});
    }
}

