/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.core.parser;

import io.github.rcarlosdasilva.weixin.common.dictionary.ResultCode;
import io.github.rcarlosdasilva.weixin.core.Registry;
import io.github.rcarlosdasilva.weixin.core.exception.ExecuteException;
import io.github.rcarlosdasilva.weixin.core.exception.MaydayMaydaySaveMeBecauseAccessTokenSetMeFuckUpException;
import io.github.rcarlosdasilva.weixin.core.json.Json;
import io.github.rcarlosdasilva.weixin.model.response.SimplestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseParser {
    private static final Logger logger = LoggerFactory.getLogger(ResponseParser.class);

    private ResponseParser() {
        throw new IllegalStateException("ResponseParser class");
    }

    public static <T> T parse(Class<T> target, String json) {
        SimplestResponse errorResponse;
        Boolean success;
        if (SimplestResponse.seemsLikeError(json) && !(success = Boolean.valueOf((errorResponse = Json.fromJson(json, SimplestResponse.class)).getErrorCode() == ResultCode.RESULT_0.getCode())).booleanValue()) {
            ResultCode resultCode = ResultCode.byCode(errorResponse.getErrorCode());
            if (resultCode == null) {
                resultCode = ResultCode.RESULT_UNKNOW;
                logger.debug("\u672a\u6536\u5f55\u7684\u5fae\u4fe1\u9519\u8bef\u4ee3\u7801: code [{}]", (Object)errorResponse.getErrorCode());
            }
            if (errorResponse.isBadAccessToken()) {
                logger.debug("\u5fae\u4fe1\u8bf4\u6211access_token\u4e0d\u5927\u884c\uff0c\u90a3\u6211\u89c9\u7740\u662f\u4e0d\u662f\u8fd8\u53ef\u4ee5\u518d\u62a2\u6551\u4e00\u4e0b\uff0c\u518d\u8bd5\u4e00\u904d\u6765");
                throw new MaydayMaydaySaveMeBecauseAccessTokenSetMeFuckUpException();
            }
            logger.error("\u5fae\u4fe1\u8bf7\u6c42\u9519\u8bef\uff1acode [{}] -- message [{}]", (Object)errorResponse.getErrorCode(), (Object)errorResponse.getErrorMessage());
            if (Registry.setting().isThrowException()) {
                throw new ExecuteException(errorResponse, resultCode);
            }
            if (target == Boolean.class) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (target == Boolean.class) {
            return (T)Boolean.TRUE;
        }
        return Json.fromJson(json, target);
    }
}

