/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model;

import com.google.common.base.Strings;
import io.github.rcarlosdasilva.weixin.common.dictionary.AccountType;
import io.github.rcarlosdasilva.weixin.common.dictionary.EncryptionType;
import io.github.rcarlosdasilva.weixin.common.dictionary.WeixinCertificationType;
import io.github.rcarlosdasilva.weixin.core.cache.Cacheable;
import java.io.Serializable;
import java.util.Map;

public class WeixinAccount
implements Serializable,
Cacheable {
    private static final long serialVersionUID = 9204192729241765932L;
    private String key;
    private String appId;
    private String mpId;
    private AccountType accountType;
    private WeixinCertificationType certificationType;
    private String nickname;
    private String appSecret;
    private EncryptionType encryptionType = EncryptionType.PLAIN_TEXT;
    private String aesToken;
    private String aesKey;
    private String refreshToken;
    private boolean withOpenPlatform = true;
    private Map<String, Object> extension;

    private WeixinAccount() {
    }

    public static WeixinAccount create(String appId) {
        WeixinAccount account = new WeixinAccount();
        account.appId = appId;
        return account;
    }

    public static WeixinAccount create(String appId, String appSecret) {
        WeixinAccount account = new WeixinAccount();
        account.appId = appId;
        account.appSecret = appSecret;
        account.withOpenPlatform = false;
        return account;
    }

    public WeixinAccount withKey(String key) {
        this.key = key;
        return this;
    }

    public WeixinAccount setServerSecurity(String aesToken, String aesKey, EncryptionType encryptionType) {
        this.aesToken = aesToken;
        this.aesKey = aesKey;
        this.encryptionType = encryptionType;
        return this;
    }

    public WeixinAccount setBasic(AccountType accountType, WeixinCertificationType certificationType) {
        this.accountType = accountType;
        this.certificationType = certificationType;
        return this;
    }

    public WeixinAccount setBasic(AccountType accountType, WeixinCertificationType certificationType, String mpId, String nickname) {
        this.accountType = accountType;
        this.certificationType = certificationType;
        this.mpId = mpId;
        this.nickname = nickname;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getMpId() {
        return this.mpId;
    }

    public WeixinAccount setMpId(String mpId) {
        this.mpId = mpId;
        return this;
    }

    public String getNickname() {
        return this.nickname;
    }

    public WeixinAccount setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public WeixinAccount setAccountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    public WeixinCertificationType getCertificationType() {
        return this.certificationType;
    }

    public WeixinAccount setCertificationType(WeixinCertificationType certificationType) {
        this.certificationType = certificationType;
        return this;
    }

    public String getAesToken() {
        return this.aesToken;
    }

    public WeixinAccount setAesToken(String aesToken) {
        this.aesToken = aesToken;
        return this;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public WeixinAccount setAesKey(String aesKey) {
        this.aesKey = aesKey;
        return this;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public WeixinAccount setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public Object getExtension() {
        return this.extension;
    }

    public void setExtension(Map<String, Object> extension) {
        this.extension = extension;
    }

    public boolean isSafeMode() {
        return this.encryptionType != null && this.encryptionType != EncryptionType.PLAIN_TEXT && !Strings.isNullOrEmpty((String)this.aesToken) && !Strings.isNullOrEmpty((String)this.aesKey);
    }

    public boolean isWithOpenPlatform() {
        return this.withOpenPlatform;
    }

    public void setWithOpenPlatform(boolean withOpenPlatform) {
        this.withOpenPlatform = withOpenPlatform;
    }

    public String toString() {
        return this.appId + "@" + this.appSecret;
    }
}

