/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.builder;

import io.github.rcarlosdasilva.weixin.common.dictionary.MessageType;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Article;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Card;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Image;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.MessageContainer;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Music;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.NewsExternal;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.NewsInternal;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Text;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Video;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Voice;

public class MassOrCustomMessageBuilder {
    private MessageContainer messageContainer = new MessageContainer();

    public MassOrCustomMessageBuilder withCustomService(String account) {
        this.messageContainer.setCustomServiceAccount(account);
        return this;
    }

    public MessageContainer buildText(String content) {
        Text text = new Text();
        text.setContent(content);
        this.messageContainer.setType(MessageType.TEXT);
        this.messageContainer.setBean(text);
        return this.messageContainer;
    }

    public MessageContainer buildImage(String mediaId) {
        Image image = new Image();
        image.setMediaId(mediaId);
        this.messageContainer.setType(MessageType.IMAGE);
        this.messageContainer.setBean(image);
        return this.messageContainer;
    }

    public MessageContainer buildVoice(String mediaId) {
        Voice voice = new Voice();
        voice.setMediaId(mediaId);
        this.messageContainer.setType(MessageType.VOICE);
        this.messageContainer.setBean(voice);
        return this.messageContainer;
    }

    public MessageContainer buildVideo(String mediaId, String mediaThumbId, String title, String description) {
        Video video = new Video();
        video.setMediaId(mediaId);
        video.setMediaThumbId(mediaThumbId);
        video.setTitle(title);
        video.setDescription(description);
        this.messageContainer.setType(MessageType.MPVIDEO);
        this.messageContainer.setBean(video);
        return this.messageContainer;
    }

    public MessageContainer buildMusic(String mediaThumbId, String url, String url4hq, String title, String description) {
        Music music = new Music();
        music.setMediaThumbId(mediaThumbId);
        music.setUrl(url);
        music.setUrl4hq(url4hq);
        music.setTitle(title);
        music.setDescription(description);
        this.messageContainer.setType(MessageType.MUSIC);
        this.messageContainer.setBean(music);
        return this.messageContainer;
    }

    public MessageContainer buildNewsInternal(String mediaId) {
        NewsInternal news = new NewsInternal();
        news.setMediaId(mediaId);
        this.messageContainer.setType(MessageType.NEWS_INTERNAL);
        this.messageContainer.setBean(news);
        return this.messageContainer;
    }

    public NewsExternalBuilder buildNewsExternal() {
        this.messageContainer.setType(MessageType.NEWS_EXTERNAL);
        return new NewsExternalBuilder(this.messageContainer);
    }

    public MessageContainer buildCard(String cardId) {
        Card card = new Card();
        card.setCardId(cardId);
        this.messageContainer.setType(MessageType.CARD);
        this.messageContainer.setBean(card);
        return this.messageContainer;
    }

    public class NewsExternalBuilder {
        private NewsExternal news = new NewsExternal();
        private MessageContainer messageContainer;

        private NewsExternalBuilder(MessageContainer messageContainer) {
            this.messageContainer = messageContainer;
        }

        public NewsExternalBuilder add(String url, String title, String description, String picUrl) {
            Article article = new Article();
            article.setUrl(url);
            article.setTitle(title);
            article.setDescription(description);
            article.setPicUrl(picUrl);
            this.news.addArticle(article);
            return this;
        }

        public MessageContainer build() {
            this.messageContainer.setBean(this.news);
            return this.messageContainer;
        }
    }
}

