/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.builder;

import io.github.rcarlosdasilva.weixin.common.dictionary.ClientPlatformType;
import io.github.rcarlosdasilva.weixin.common.dictionary.Language;
import io.github.rcarlosdasilva.weixin.common.dictionary.MenuType;
import io.github.rcarlosdasilva.weixin.common.dictionary.Sex;
import io.github.rcarlosdasilva.weixin.model.request.menu.bean.Button;
import io.github.rcarlosdasilva.weixin.model.request.menu.bean.MatchRule;
import io.github.rcarlosdasilva.weixin.model.request.menu.bean.Menu;
import io.github.rcarlosdasilva.weixin.model.request.menu.bean.SubButton;

public class MenuBuilder {
    private Menu menu = new Menu();

    public MatchRuleBuilder withConditional() {
        MatchRule matchRule = new MatchRule();
        this.menu.setMatchRule(matchRule);
        return new MatchRuleBuilder(this, matchRule);
    }

    public MenuBuilder addRootClick(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.CLICK.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootView(String title, String url) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.VIEW.getText());
        button.setUrl(url);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootScanQrPush(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.SCAN_QR_PUSH.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootScanQrWaitMsg(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.SCAN_QR_WAIT_MSG.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootPicPhoto(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.PIC_PHOTO.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootPicPhotoOrAlbum(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.PIC_PHOTO_OR_ALBUM.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootPicWxAlbum(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.PIC_WX_ALBUM.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootLocation(String title, String key) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.LOCATION.getText());
        button.setKey(key);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootSendMedia(String title, String mediaId) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.SEND_MEDIA.getText());
        button.setMediaId(mediaId);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootRedirectView(String title, String mediaId) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.REDIRECT_VIEW.getText());
        button.setMediaId(mediaId);
        this.menu.getButtons().add(button);
        return this;
    }

    public MenuBuilder addRootMiniProgram(String title, String url, String appid, String path) {
        Button button = new Button();
        button.setName(title);
        button.setType(MenuType.MINI_PROGRAM.getText());
        button.setUrl(url);
        button.setAppid(appid);
        button.setPath(path);
        this.menu.getButtons().add(button);
        return this;
    }

    public SubMenuBuilder addRootWithSubButtons(String name) {
        Button button = new Button();
        button.setName(name);
        this.menu.getButtons().add(button);
        return new SubMenuBuilder(this, button);
    }

    public Menu build() {
        return this.menu;
    }

    public class MatchRuleBuilder {
        private MenuBuilder caller;
        private MatchRule matchRule;

        private MatchRuleBuilder(MenuBuilder caller, MatchRule matchRule) {
            this.caller = caller;
            this.matchRule = matchRule;
        }

        public MatchRuleBuilder setTagId(int tagId) {
            this.matchRule.setTagId(tagId);
            return this;
        }

        public MatchRuleBuilder setSex(Sex sex) {
            this.matchRule.setSex(sex.getCode());
            return this;
        }

        public MatchRuleBuilder setCountry(String country) {
            this.matchRule.setCountry(country);
            return this;
        }

        public MatchRuleBuilder setProvince(String province) {
            this.matchRule.setProvince(province);
            return this;
        }

        public MatchRuleBuilder setCity(String city) {
            this.matchRule.setCity(city);
            return this;
        }

        public MatchRuleBuilder setClientPlatformType(ClientPlatformType type) {
            this.matchRule.setClientPlatformType(type.getCode());
            return this;
        }

        public MatchRuleBuilder setLanguage(Language language) {
            this.matchRule.setLanguage(language.toString());
            return this;
        }

        public MenuBuilder done() {
            return this.caller;
        }
    }

    public class SubMenuBuilder {
        private MenuBuilder caller;
        private Button rootButton;

        private SubMenuBuilder(MenuBuilder caller, Button rootButton) {
            this.caller = caller;
            this.rootButton = rootButton;
        }

        public SubMenuBuilder addClick(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.CLICK.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addView(String title, String url) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.VIEW.getText());
            button.setUrl(url);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addScanQrPush(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.SCAN_QR_PUSH.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addScanQrWaitMsg(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.SCAN_QR_WAIT_MSG.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addPicPhoto(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.PIC_PHOTO.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addPicPhotoOrAlbum(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.PIC_PHOTO_OR_ALBUM.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addPicWxAlbum(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.PIC_WX_ALBUM.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addLocation(String title, String key) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.LOCATION.getText());
            button.setKey(key);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addSendMedia(String title, String mediaId) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.SEND_MEDIA.getText());
            button.setMediaId(mediaId);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addRedirectView(String title, String mediaId) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.REDIRECT_VIEW.getText());
            button.setMediaId(mediaId);
            this.rootButton.addSubButton(button);
            return this;
        }

        public SubMenuBuilder addMiniProgram(String title, String url, String appid, String path) {
            SubButton button = new SubButton();
            button.setName(title);
            button.setType(MenuType.MINI_PROGRAM.getText());
            button.setUrl(url);
            button.setAppid(appid);
            button.setPath(path);
            this.rootButton.addSubButton(button);
            return this;
        }

        public MenuBuilder and() {
            return this.caller;
        }
    }
}

