/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.builder;

import com.google.common.base.Preconditions;
import io.github.rcarlosdasilva.weixin.common.dictionary.MessageType;
import io.github.rcarlosdasilva.weixin.core.exception.InvalidNotificationResponseTypeException;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationMeta;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponsePlaintext;
import java.util.Calendar;

public class NotificationResponseBuilder {
    private NotificationMeta meta;
    private NotificationResponsePlaintext response = new NotificationResponsePlaintext();
    private boolean noResponse = false;

    public NotificationResponseBuilder with(NotificationMeta notificationMeta) {
        Preconditions.checkNotNull((Object)notificationMeta);
        NotificationResponseBuilder builder = new NotificationResponseBuilder();
        builder.meta = notificationMeta;
        return builder;
    }

    public NotificationResponseBuilder responseNothing() {
        this.noResponse = true;
        return this;
    }

    public NotificationResponseBuilder responseText(String content) {
        this.response.setType(MessageType.TEXT);
        this.response.getInfo().setContent(content);
        return this;
    }

    public NotificationResponseBuilder responseImage(String mediaId) {
        this.response.setType(MessageType.IMAGE);
        this.response.getInfo().setMediaId(mediaId);
        return this;
    }

    public NotificationResponseBuilder responseVoice(String mediaId) {
        this.response.setType(MessageType.VOICE);
        this.response.getInfo().setMediaId(mediaId);
        return this;
    }

    public NotificationResponseBuilder responseVideo(String mediaId, String title, String description) {
        this.response.setType(MessageType.VIDEO);
        this.response.getInfo().setMediaId(mediaId);
        this.response.getInfo().setTitle(title);
        this.response.getInfo().setDescription(description);
        return this;
    }

    public NotificationResponseBuilder responseMusic(String mediaThumbId, String title, String description, String musicUrl, String musicHqUrl) {
        this.response.setType(MessageType.MUSIC);
        this.response.getInfo().setTitle(title);
        this.response.getInfo().setDescription(description);
        this.response.getInfo().setMediaThumbId(mediaThumbId);
        this.response.getInfo().setUrl(musicUrl);
        this.response.getInfo().setOtherUrl(musicHqUrl);
        return this;
    }

    public NotificationResponseBuilder responseNewsOneOf(String title, String description, String url, String picUrl) {
        this.response.setType(MessageType.NEWS_EXTERNAL);
        this.response.addInfo(title, description, url, picUrl);
        return this;
    }

    public NotificationResponsePlaintext build() {
        if (this.noResponse) {
            return null;
        }
        if (this.response.getType() == null) {
            throw new InvalidNotificationResponseTypeException();
        }
        this.response.setFromUser(this.meta.getToUser());
        this.response.setToUser(this.meta.getFromUser());
        this.response.setTime(Calendar.getInstance().getTimeInMillis());
        return this.response;
    }
}

