/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.builder;

import com.google.common.collect.Maps;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Template;
import java.util.Map;

public class TemplateMessageBuilder {
    private Map<String, Template> data = Maps.newHashMap();
    private String defaultColor = "#000000";

    public TemplateMessageBuilder withColor(String color) {
        this.defaultColor = color;
        return this;
    }

    public TemplateMessageBuilder begin(String value) {
        this.data.put("first", new Template(value, this.defaultColor));
        return this;
    }

    public TemplateMessageBuilder begin(String value, String color) {
        this.data.put("first", new Template(value, color));
        return this;
    }

    public TemplateMessageBuilder end(String value) {
        this.data.put("remark", new Template(value, this.defaultColor));
        return this;
    }

    public TemplateMessageBuilder end(String value, String color) {
        this.data.put("remark", new Template(value, color));
        return this;
    }

    public TemplateMessageBuilder keyword(String key, String value) {
        this.data.put(key, new Template(value, this.defaultColor));
        return this;
    }

    public TemplateMessageBuilder keyword(String key, String value, String color) {
        this.data.put(key, new Template(value, color));
        return this;
    }

    public Map<String, Template> build() {
        return this.data;
    }
}

