/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.notification;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import io.github.rcarlosdasilva.weixin.common.dictionary.MessageType;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponse;
import io.github.rcarlosdasilva.weixin.model.notification.bean.ResponseAdditionalInfo;
import io.github.rcarlosdasilva.weixin.model.notification.converter.EnumStringConverter;
import io.github.rcarlosdasilva.weixin.model.notification.converter.ResponseConverter;
import java.util.List;

@XStreamAlias(value="xml")
@XStreamConverter(value=ResponseConverter.class)
public class NotificationResponsePlaintext
implements NotificationResponse {
    @XStreamAlias(value="ToUserName")
    private String toUser;
    @XStreamAlias(value="FromUserName")
    private String fromUser;
    @XStreamAlias(value="CreateTime")
    private long time;
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=EnumStringConverter.class)
    private MessageType type;
    @XStreamOmitField
    private ResponseAdditionalInfo info = new ResponseAdditionalInfo();
    @XStreamOmitField
    private List<ResponseAdditionalInfo> infos = Lists.newArrayList();

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setType(MessageType type) {
        Preconditions.checkArgument((type != MessageType.NEWS_INTERNAL && type != MessageType.CARD ? 1 : 0) != 0, (Object)"Unspport message type.");
        this.type = type;
    }

    public MessageType getType() {
        return this.type;
    }

    public ResponseAdditionalInfo getInfo() {
        return this.info;
    }

    public List<ResponseAdditionalInfo> getInfos() {
        return this.infos;
    }

    public void addInfo(String title, String description, String url, String otherUrl) {
        this.infos.add(new ResponseAdditionalInfo(title, description, url, otherUrl));
    }
}

