/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.notification.converter;

import com.google.common.base.Ascii;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import io.github.rcarlosdasilva.weixin.common.dictionary.MessageType;
import io.github.rcarlosdasilva.weixin.model.notification.NotificationResponsePlaintext;
import io.github.rcarlosdasilva.weixin.model.notification.bean.ResponseAdditionalInfo;

public class ResponseConverter
extends ReflectionConverter {
    public ResponseConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(NotificationResponsePlaintext.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        String tag;
        boolean isPlain;
        this.doMarshal(source, writer, context);
        NotificationResponsePlaintext notification = (NotificationResponsePlaintext)source;
        MessageType type = notification.getType();
        boolean bl = isPlain = type == MessageType.TEXT;
        if (type == MessageType.NEWS_EXTERNAL) {
            writer.startNode("ArticleCount");
            context.convertAnother((Object)notification.getInfos().size());
            writer.endNode();
            tag = "Articles";
        } else {
            tag = Ascii.toUpperCase((char)type.getText().charAt(0)) + type.getText().substring(1);
        }
        if (!isPlain) {
            writer.startNode(tag);
        }
        ResponseAdditionalInfo info = notification.getInfo();
        switch (type) {
            case TEXT: {
                writer.startNode("Content");
                writer.setValue(info.getContent());
                writer.endNode();
                break;
            }
            case IMAGE: 
            case VOICE: {
                writer.startNode("MediaId");
                writer.setValue(info.getMediaId());
                writer.endNode();
                break;
            }
            case VIDEO: {
                writer.startNode("MediaId");
                writer.setValue(info.getMediaId());
                writer.endNode();
                writer.startNode("Title");
                writer.setValue(info.getTitle());
                writer.endNode();
                writer.startNode("Description");
                writer.setValue(info.getDescription());
                writer.endNode();
                break;
            }
            case MUSIC: {
                writer.startNode("Title");
                writer.setValue(info.getTitle());
                writer.endNode();
                writer.startNode("Description");
                writer.setValue(info.getDescription());
                writer.endNode();
                writer.startNode("MusicUrl");
                writer.setValue(info.getUrl());
                writer.endNode();
                writer.startNode("HQMusicUrl");
                writer.setValue(info.getOtherUrl());
                writer.endNode();
                writer.startNode("ThumbMediaId");
                writer.setValue(info.getMediaThumbId());
                writer.endNode();
                break;
            }
            case NEWS_EXTERNAL: {
                for (ResponseAdditionalInfo infoTmp : notification.getInfos()) {
                    writer.startNode("item");
                    writer.startNode("Title");
                    writer.setValue(infoTmp.getTitle());
                    writer.endNode();
                    writer.startNode("Description");
                    writer.setValue(infoTmp.getDescription());
                    writer.endNode();
                    writer.startNode("Url");
                    writer.setValue(infoTmp.getUrl());
                    writer.endNode();
                    writer.startNode("PicUrl");
                    writer.setValue(infoTmp.getOtherUrl());
                    writer.endNode();
                    writer.endNode();
                }
                break;
            }
        }
        if (!isPlain) {
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return null;
    }
}

