/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.request.message;

import com.google.gson.annotations.SerializedName;
import io.github.rcarlosdasilva.weixin.common.dictionary.MessageType;
import io.github.rcarlosdasilva.weixin.model.request.base.BasicWeixinRequest;
import io.github.rcarlosdasilva.weixin.model.request.message.MessageRequest;
import io.github.rcarlosdasilva.weixin.model.request.message.MessageSendWithMassRequestUser;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Card;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Image;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.MassFilter;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Music;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.NewsExternal;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.NewsInternal;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Text;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Video;
import io.github.rcarlosdasilva.weixin.model.request.message.bean.Voice;
import java.util.List;

public class MessageSendWithMassRequest
extends BasicWeixinRequest
implements MessageRequest {
    @SerializedName(value="msgtype")
    private String type;
    private MassFilter filter;
    @SerializedName(value="touser")
    private MessageSendWithMassRequestUser user;
    @SerializedName(value="towxname")
    private String wxname;
    @SerializedName(value="mpnews")
    private NewsInternal newsInternal;
    private Text text;
    private Voice voice;
    private Image image;
    @SerializedName(value="mpvideo")
    private Video video;
    @SerializedName(value="wxcard")
    private Card card;
    @SerializedName(value="send_ignore_reprint")
    private int canReprint = 1;
    @SerializedName(value="clientmsgid")
    private String mark;

    public void forTag() {
        this.path = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall";
    }

    public void forUsers() {
        this.path = "https://api.weixin.qq.com/cgi-bin/message/mass/send";
    }

    public void forPreview() {
        this.path = "https://api.weixin.qq.com/cgi-bin/message/mass/preview";
    }

    public void setType(MessageType type) {
        this.type = type.getText();
    }

    public void setTagId(int tagId) {
        if (this.filter == null) {
            this.filter = new MassFilter();
        }
        this.filter.setTagId(tagId);
    }

    public void toAll() {
        if (this.filter == null) {
            this.filter = new MassFilter();
        }
        this.filter.setToAll(true);
    }

    public void setUsers(List<String> users) {
        this.user = new MessageSendWithMassRequestUser(users);
    }

    public void setUser(String user) {
        this.user = new MessageSendWithMassRequestUser(user);
    }

    public void setWxname(String wxname) {
        this.wxname = wxname;
    }

    @Override
    public void setNewsInternal(NewsInternal newsInternal) {
        this.newsInternal = newsInternal;
    }

    @Override
    public void setText(Text text) {
        this.text = text;
    }

    @Override
    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public void setVideo(Video video) {
        this.video = video;
    }

    @Override
    public void setCard(Card card) {
        this.card = card;
    }

    @Override
    public void setMusic(Music music) {
    }

    @Override
    public void setNewsExternal(NewsExternal newsExternal) {
    }

    public void setCanReprint(boolean canReprint) {
        this.canReprint = canReprint ? 1 : 0;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }
}

