/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcarlosdasilva.weixin.model.response;

import com.google.gson.annotations.SerializedName;
import io.github.rcarlosdasilva.weixin.common.dictionary.ResultCode;

public class SimplestResponse {
    private static final String errorResponseRegex = ".*errcode.*errmsg.*";
    private static final int resultInvalidCredential = ResultCode.RESULT_40001.getCode();
    private static final int resultInvalidToken = ResultCode.RESULT_40014.getCode();
    private static final int resultExpiredToken = ResultCode.RESULT_42001.getCode();
    @SerializedName(value="errcode")
    private int errorCode;
    @SerializedName(value="errmsg")
    private String errorMessage;

    public static boolean seemsLikeError(String json) {
        return json.matches(errorResponseRegex);
    }

    public boolean isBadAccessToken() {
        return this.errorCode == resultInvalidCredential || this.errorCode == resultInvalidToken || this.errorCode == resultExpiredToken;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

