/*
 * Decompiled with CFR 0.152.
 */
package io.github.wslxm.springbootplus2.starter.swagger.config;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.google.common.collect.Lists;
import io.github.wslxm.springbootplus2.starter.swagger.properties.SwaggerProperties;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableKnife4j
public class SwaggerConfig {
    @Autowired
    private SwaggerProperties swaggerProperties;

    @Bean
    public Docket swaggerDocketA() {
        if (this.swaggerProperties.getPackages().size() == 0) {
            return this.createDocket("A|com");
        }
        return this.createDocket(this.swaggerProperties.getPackages().get("0") == null ? "A|xxx.xxx" : this.swaggerProperties.getPackages().get("0") + "|A");
    }

    @Bean
    public Docket swaggerDocketB() {
        return this.createDocket(this.swaggerProperties.getPackages().get("1") == null ? "B|xxx.xxx" : this.swaggerProperties.getPackages().get("1") + "|B");
    }

    @Bean
    public Docket swaggerDocketC() {
        return this.createDocket(this.swaggerProperties.getPackages().get("2") == null ? "C|xxx.xxx" : this.swaggerProperties.getPackages().get("2") + "|C");
    }

    @Bean
    public Docket swaggerDocketD() {
        return this.createDocket(this.swaggerProperties.getPackages().get("3") == null ? "D|xxx.xxx" : this.swaggerProperties.getPackages().get("3") + "|D");
    }

    @Bean
    public Docket swaggerDocketE() {
        return this.createDocket(this.swaggerProperties.getPackages().get("4") == null ? "E|xxx.xxx" : this.swaggerProperties.getPackages().get("4") + "|E");
    }

    @Bean
    public Docket swaggerDocketF() {
        return this.createDocket(this.swaggerProperties.getPackages().get("5") == null ? "F|xxx.xxx" : this.swaggerProperties.getPackages().get("5") + "|F");
    }

    @Bean
    public Docket swaggerDocketG() {
        return this.createDocket(this.swaggerProperties.getPackages().get("6") == null ? "G|xxx.xxx" : this.swaggerProperties.getPackages().get("6") + "|G");
    }

    @Bean
    public Docket swaggerDocketH() {
        return this.createDocket(this.swaggerProperties.getPackages().get("7") == null ? "H|xxx.xxx" : this.swaggerProperties.getPackages().get("7") + "|H");
    }

    @Bean
    public Docket swaggerDocketI() {
        return this.createDocket(this.swaggerProperties.getPackages().get("8") == null ? "I|xxx.xxx" : this.swaggerProperties.getPackages().get("8") + "|I");
    }

    @Bean
    public Docket swaggerDocketJ() {
        return this.createDocket(this.swaggerProperties.getPackages().get("9") == null ? "J|xxx.xxx" : this.swaggerProperties.getPackages().get("9") + "|J");
    }

    public Docket createDocket(Object groupNameOrPackage) {
        String groupName = this.getGroupName(groupNameOrPackage.toString());
        return new Docket(DocumentationType.SWAGGER_2).groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)this.getPackage(groupNameOrPackage.toString()))).apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build().useDefaultResponseMessages(false).globalOperationParameters(this.getGlobalParameter()).apiInfo(this.getApiInfo(groupName));
    }

    private String getGroupName(String groupNameOrPackage) {
        String[] split = groupNameOrPackage.split("\\|");
        String groupName = split[0];
        int len = 2;
        if (split.length > len) {
            groupName = split[2] + "--" + groupName;
        }
        return groupName.trim();
    }

    private String getPackage(String groupNameOrPackage) {
        String[] split = groupNameOrPackage.split("\\|");
        String basePackage = split[1];
        if (!this.swaggerProperties.getIsShow().booleanValue()) {
            basePackage = "xxx.xxx";
        }
        return basePackage.trim();
    }

    private ApiInfo getApiInfo(String groupName) {
        return new ApiInfoBuilder().title(groupName).description("restful Swagger API \u6587\u6863").termsOfServiceUrl(this.swaggerProperties.getTermsOfServiceUrl()).version(this.swaggerProperties.getVersion()).contact(new Contact(this.swaggerProperties.getAuthor(), this.swaggerProperties.getUrl(), this.swaggerProperties.getEmail())).build();
    }

    private List<Parameter> getGlobalParameter() {
        ParameterBuilder parameterBuilder = new ParameterBuilder();
        parameterBuilder.name(this.swaggerProperties.getDefaultKey()).scalarExample((Object)this.swaggerProperties.getDefaultValue()).description("\u8bf7\u6c42\u5934\u53c2\u6570").modelRef((ModelReference)new ModelRef("string")).parameterType("header").order(-999).required(false).build();
        ArrayList parameters = Lists.newArrayList();
        parameters.add(parameterBuilder.build());
        return parameters;
    }
}

