/*
 * Decompiled with CFR 0.152.
 */
package io.github.wslxm.springbootplus2.starter.swagger.sort;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Primary
@Component
public class CustomSwaggerParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public CustomSwaggerParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        this.descriptions = descriptions;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public void apply(ParameterExpansionContext context) {
        com.google.common.base.Optional apiParamOptional;
        com.google.common.base.Optional apiModelPropertyOptional = context.findAnnotation(ApiModelProperty.class);
        if (apiModelPropertyOptional.isPresent()) {
            this.fromApiModelProperty(context, (ApiModelProperty)apiModelPropertyOptional.get());
        }
        if ((apiParamOptional = context.findAnnotation(ApiParam.class)).isPresent()) {
            this.fromApiParam(context, (ApiParam)apiParamOptional.get());
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }

    private void fromApiParam(ParameterExpansionContext context, ApiParam apiParam) {
        String allowableProperty = Strings.emptyToNull((String)apiParam.allowableValues());
        AllowableValues allowable = this.allowableValues(Optional.ofNullable(allowableProperty), context.getFieldType().getErasedType());
        this.maybeSetParameterName(context, apiParam.name()).description(this.descriptions.resolve(apiParam.value())).defaultValue(apiParam.defaultValue()).required(apiParam.required()).allowMultiple(apiParam.allowMultiple()).allowableValues(allowable).parameterAccess(apiParam.access()).hidden(apiParam.hidden()).scalarExample((Object)apiParam.example()).complexExamples(Examples.examples((Example)apiParam.examples())).order(-2147482648).build();
    }

    private void fromApiModelProperty(ParameterExpansionContext context, ApiModelProperty apiModelProperty) {
        String allowableProperty = Strings.emptyToNull((String)apiModelProperty.allowableValues());
        AllowableValues allowable = this.allowableValues(Optional.ofNullable(allowableProperty), context.getFieldType().getErasedType());
        this.maybeSetParameterName(context, apiModelProperty.name()).description(this.descriptions.resolve(apiModelProperty.value())).required(apiModelProperty.required()).allowableValues(allowable).parameterAccess(apiModelProperty.access()).hidden(apiModelProperty.hidden()).scalarExample((Object)apiModelProperty.example()).order(apiModelProperty.position()).build();
    }

    private ParameterBuilder maybeSetParameterName(ParameterExpansionContext context, String parameterName) {
        if (!Strings.isNullOrEmpty((String)parameterName)) {
            context.getParameterBuilder().name(parameterName);
        }
        return context.getParameterBuilder();
    }

    private AllowableValues allowableValues(Optional<String> optionalAllowable, Class<?> fieldType) {
        AllowableListValues allowable = null;
        if (this.enumTypeDeterminer.isEnum(fieldType)) {
            allowable = new AllowableListValues(this.getEnumValues(fieldType), "LIST");
        } else if (optionalAllowable.isPresent()) {
            allowable = ApiModelProperties.allowableValueFromString((String)optionalAllowable.get());
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

