/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import io.greptime.Query;
import io.greptime.QueryClient;
import io.greptime.RouterClient;
import io.greptime.RpcServiceRegister;
import io.greptime.StreamWriter;
import io.greptime.Util;
import io.greptime.Write;
import io.greptime.WriteClient;
import io.greptime.common.Display;
import io.greptime.common.Endpoint;
import io.greptime.common.Lifecycle;
import io.greptime.common.signal.SignalHandlersLoader;
import io.greptime.common.util.MetricExecutor;
import io.greptime.common.util.MetricsUtil;
import io.greptime.models.Err;
import io.greptime.models.QueryOk;
import io.greptime.models.QueryRequest;
import io.greptime.models.Result;
import io.greptime.models.WriteOk;
import io.greptime.models.WriteRows;
import io.greptime.options.GreptimeOptions;
import io.greptime.options.QueryOptions;
import io.greptime.options.RouterOptions;
import io.greptime.options.WriteOptions;
import io.greptime.rpc.Context;
import io.greptime.rpc.RpcClient;
import io.greptime.rpc.RpcFactoryProvider;
import io.greptime.rpc.RpcOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreptimeDB
implements Write,
Query,
Lifecycle<GreptimeOptions>,
Display {
    private static final Logger LOG = LoggerFactory.getLogger(GreptimeDB.class);
    private static final Map<Integer, GreptimeDB> INSTANCES = new ConcurrentHashMap<Integer, GreptimeDB>();
    private static final AtomicInteger ID = new AtomicInteger(0);
    private static final String ID_KEY = "greptimedb.client.id";
    private static final String VERSION_KEY = "greptimedb.client.version";
    private static final String VERSION = Util.clientVersion();
    private final int id;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private GreptimeOptions opts;
    private RouterClient routerClient;
    private WriteClient writeClient;
    private QueryClient queryClient;
    private Executor asyncWritePool;
    private Executor asyncReadPool;

    public static List<GreptimeDB> instances() {
        return new ArrayList<GreptimeDB>(INSTANCES.values());
    }

    public GreptimeDB() {
        this.id = ID.incrementAndGet();
    }

    public boolean init(GreptimeOptions opts) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("GreptimeDB client has started");
        }
        this.opts = GreptimeOptions.checkSelf(opts).copy();
        this.routerClient = GreptimeDB.makeRouteClient(opts);
        this.asyncWritePool = GreptimeDB.makeMetricPool(this.opts.getAsyncWritePool(), "async_write_pool.time");
        this.asyncReadPool = GreptimeDB.makeMetricPool(this.opts.getAsyncReadPool(), "async_read_pool.time");
        this.writeClient = GreptimeDB.makeWriteClient(opts, this.routerClient, this.asyncWritePool);
        this.queryClient = GreptimeDB.makeQueryClient(opts, this.routerClient, this.asyncReadPool);
        INSTANCES.put(this.id, this);
        Util.scheduleDisplaySelf(this, new LogPrinter(LOG));
        return true;
    }

    public void shutdownGracefully() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        if (this.writeClient != null) {
            this.writeClient.shutdownGracefully();
        }
        if (this.queryClient != null) {
            this.queryClient.shutdownGracefully();
        }
        if (this.routerClient != null) {
            this.routerClient.shutdownGracefully();
        }
        INSTANCES.remove(this.id);
    }

    public void ensureInitialized() {
        if (this.started.get() && INSTANCES.containsKey(this.id)) {
            return;
        }
        throw new IllegalStateException(String.format("Client(%d) is not started", this.id));
    }

    @Override
    public CompletableFuture<Result<WriteOk, Err>> writeBatch(Collection<WriteRows> rows, Context ctx) {
        this.ensureInitialized();
        return this.writeClient.writeBatch(rows, this.attachCtx(ctx));
    }

    @Override
    public StreamWriter<WriteRows, WriteOk> streamWriter(int maxPointsPerSecond, Context ctx) {
        return this.writeClient.streamWriter(maxPointsPerSecond, this.attachCtx(ctx));
    }

    @Override
    public CompletableFuture<Result<QueryOk, Err>> query(QueryRequest req, Context ctx) {
        this.ensureInitialized();
        return this.queryClient.query(req, this.attachCtx(ctx));
    }

    public void display(Display.Printer out) {
        out.println((Object)"--- GreptimeDB Client ---").print((Object)"id=").println((Object)this.id).print((Object)"version=").println((Object)VERSION).print((Object)"endpoints=").println(this.opts.getEndpoints()).print((Object)"userAsyncWritePool=").println((Object)this.opts.getAsyncWritePool()).print((Object)"userAsyncReadPool=").println((Object)this.opts.getAsyncReadPool());
        if (this.routerClient != null) {
            out.println((Object)"");
            this.routerClient.display(out);
        }
        if (this.writeClient != null) {
            out.println((Object)"");
            this.writeClient.display(out);
        }
        if (this.queryClient != null) {
            out.println((Object)"");
            this.queryClient.display(out);
        }
        out.println((Object)"");
    }

    public String toString() {
        return "GreptimeDB{id=" + this.id + "version=" + VERSION + ", opts=" + this.opts + ", routerClient=" + this.routerClient + ", writeClient=" + this.writeClient + ", queryClient=" + this.queryClient + ", asyncWritePool=" + this.asyncWritePool + ", asyncReadPool=" + this.asyncReadPool + '}';
    }

    private Context attachCtx(Context ctx) {
        Context newCtx = ctx == null ? Context.newDefault() : ctx;
        return newCtx.with(ID_KEY, (Object)this.id).with(VERSION_KEY, (Object)VERSION);
    }

    private static Executor makeMetricPool(Executor pool, String name) {
        return pool == null ? null : new MetricExecutor(pool, name);
    }

    private static RpcClient makeRpcClient(GreptimeOptions opts) {
        RpcOptions rpcOpts = opts.getRpcOptions();
        RpcClient rpcClient = RpcFactoryProvider.getRpcFactory().createRpcClient();
        if (!rpcClient.init((Object)rpcOpts)) {
            throw new IllegalStateException("Fail to start RPC client");
        }
        rpcClient.registerConnectionObserver((RpcClient.ConnectionObserver)new RpcConnectionObserver());
        return rpcClient;
    }

    private static RouterClient makeRouteClient(GreptimeOptions opts) {
        RouterOptions routerOpts = opts.getRouterOptions();
        routerOpts.setRpcClient(GreptimeDB.makeRpcClient(opts));
        RouterClient routerClient = new RouterClient();
        if (!routerClient.init(routerOpts)) {
            throw new IllegalStateException("Fail to start router client");
        }
        return routerClient;
    }

    private static WriteClient makeWriteClient(GreptimeOptions opts, RouterClient routerClient, Executor asyncPool) {
        WriteOptions writeOpts = opts.getWriteOptions();
        writeOpts.setRouterClient(routerClient);
        writeOpts.setAsyncPool(asyncPool);
        WriteClient writeClient = new WriteClient();
        if (opts.getAuthInfo() != null) {
            writeOpts.setAuthInfo(opts.getAuthInfo());
        }
        if (!writeClient.init(writeOpts)) {
            throw new IllegalStateException("Fail to start write client");
        }
        return writeClient;
    }

    private static QueryClient makeQueryClient(GreptimeOptions opts, RouterClient routerClient, Executor asyncPool) {
        QueryOptions queryOpts = opts.getQueryOptions();
        queryOpts.setRouterClient(routerClient);
        queryOpts.setAsyncPool(asyncPool);
        QueryClient queryClient = new QueryClient();
        if (opts.getAuthInfo() != null) {
            queryOpts.setAuthInfo(opts.getAuthInfo());
        }
        if (!queryClient.init(queryOpts)) {
            throw new IllegalStateException("Fail to start query client");
        }
        return queryClient;
    }

    private static void doGlobalInitializeWorks() {
        SignalHandlersLoader.load();
        RpcServiceRegister.registerAllService();
        MetricsUtil.startScheduledReporter((long)Util.autoReportPeriodMin(), (TimeUnit)TimeUnit.MINUTES);
        Runtime.getRuntime().addShutdownHook(new Thread(MetricsUtil::stopScheduledReporterAndDestroy));
    }

    static {
        GreptimeDB.doGlobalInitializeWorks();
    }

    static final class LogPrinter
    implements Display.Printer {
        private static final int MAX_BUF_SIZE = 8192;
        private final Logger logger;
        private StringBuilder buf = new StringBuilder();

        LogPrinter(Logger logger) {
            this.logger = logger;
        }

        public synchronized Display.Printer print(Object x) {
            this.buf.append(x);
            return this;
        }

        public synchronized Display.Printer println(Object x) {
            this.buf.append(x);
            this.logger.info(this.buf.toString());
            this.truncateBuf();
            this.buf.setLength(0);
            return this;
        }

        private void truncateBuf() {
            if (this.buf.capacity() < 8192) {
                this.buf.setLength(0);
            } else {
                this.buf = new StringBuilder();
            }
        }
    }

    static final class RpcConnectionObserver
    implements RpcClient.ConnectionObserver {
        static final Counter CONN_COUNTER = MetricsUtil.counter((Object)"connection_counter");
        static final Meter CONN_FAILURE = MetricsUtil.meter((Object)"connection_failure");

        RpcConnectionObserver() {
        }

        public void onReady(Endpoint endpoint) {
            CONN_COUNTER.inc();
            MetricsUtil.counter((Object[])new Object[]{"connection_counter", endpoint}).inc();
        }

        public void onFailure(Endpoint endpoint) {
            CONN_COUNTER.dec();
            CONN_FAILURE.mark();
            MetricsUtil.counter((Object[])new Object[]{"connection_counter", endpoint}).dec();
            MetricsUtil.meter((Object[])new Object[]{"connection_failure", endpoint}).mark();
        }

        public void onShutdown(Endpoint endpoint) {
            CONN_COUNTER.dec();
            MetricsUtil.counter((Object[])new Object[]{"connection_counter", endpoint}).dec();
        }
    }
}

