/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.flight;

import io.greptime.common.Endpoint;
import io.greptime.common.util.Ensures;
import io.greptime.flight.GreptimeRequest;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.InternalFlightClient;
import org.apache.arrow.flight.InternalFlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreptimeFlightClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GreptimeFlightClient.class);
    private static final BufferAllocator BUFFER_ALLOCATOR = new RootAllocator(Integer.MAX_VALUE);
    private final Endpoint endpoint;
    private final InternalFlightClient client;
    private final BufferAllocator allocator;

    private GreptimeFlightClient(Endpoint endpoint, InternalFlightClient client, BufferAllocator allocator) {
        this.endpoint = (Endpoint)Ensures.ensureNonNull((Object)endpoint, (String)"null `endpoint`");
        this.client = (InternalFlightClient)Ensures.ensureNonNull((Object)client, (String)"null `client`");
        this.allocator = (BufferAllocator)Ensures.ensureNonNull((Object)allocator, (String)"null `allocator`");
    }

    public static GreptimeFlightClient createClient(Endpoint endpoint) {
        Location location = Location.forGrpcInsecure((String)endpoint.getAddr(), (int)endpoint.getPort());
        String allocatorName = String.format("BufferAllocator(%s)", location);
        BufferAllocator allocator = BUFFER_ALLOCATOR.newChildAllocator(allocatorName, 0L, Integer.MAX_VALUE);
        InternalFlightClient.Builder builder = InternalFlightClient.builder().location(location).allocator(allocator);
        InternalFlightClient client = builder.build();
        GreptimeFlightClient flightClient = new GreptimeFlightClient(endpoint, client, allocator);
        LOG.info("Created new {}", (Object)flightClient);
        return flightClient;
    }

    public InternalFlightStream doRequest(GreptimeRequest request, CallOption ... options) {
        Ticket ticket = request.into();
        return this.client.getStream(ticket, options);
    }

    public String toString() {
        return "GreptimeFlightClient{endpoint=" + this.endpoint + ", client=" + this.client + ", allocator=" + this.allocator + '}';
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client, this.allocator});
    }
}

