/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import com.google.protobuf.ByteString;
import com.google.protobuf.ByteStringHelper;
import io.greptime.common.util.Ensures;
import io.greptime.models.Util;
import io.greptime.v1.Columns;
import io.greptime.v1.Common;
import java.util.BitSet;

public final class ColumnHelper {
    public static void addToColumnValuesBuilder(Columns.Column.Builder builder, Object value) {
        Columns.Column.Values.Builder valuesBuilder = builder.getValuesBuilder();
        Common.ColumnDataType dataType = builder.getDatatype();
        ColumnHelper.addValue(valuesBuilder, dataType, value);
    }

    public static Object getValue(Columns.Column column, int index, BitSet nullMask) {
        Columns.Column.Values values = column.getValues();
        Common.ColumnDataType dataType = column.getDatatype();
        if (nullMask.isEmpty()) {
            return ColumnHelper.getValue(values, dataType, index);
        }
        Ensures.ensure((index < nullMask.size() ? 1 : 0) != 0, (String)"Index out of range: %d", (Object[])new Object[]{index});
        if (nullMask.get(index)) {
            return null;
        }
        int cardinality = nullMask.get(0, index).cardinality();
        return ColumnHelper.getValue(values, dataType, index - cardinality);
    }

    public static BitSet getNullMaskBits(Columns.Column column) {
        return BitSet.valueOf(ByteStringHelper.sealByteArray((ByteString)column.getNullMask()));
    }

    private static void addValue(Columns.Column.Values.Builder builder, Common.ColumnDataType dataType, Object value) {
        switch (dataType) {
            case INT8: {
                builder.addI8Values(((Integer)value).intValue());
                break;
            }
            case INT16: {
                builder.addI16Values(((Integer)value).intValue());
                break;
            }
            case INT32: {
                builder.addI32Values(((Integer)value).intValue());
                break;
            }
            case INT64: {
                builder.addI64Values(Util.getLongValue(value));
                break;
            }
            case UINT8: {
                builder.addU8Values(((Integer)value).intValue());
                break;
            }
            case UINT16: {
                builder.addU16Values(((Integer)value).intValue());
                break;
            }
            case UINT32: {
                builder.addU32Values(((Integer)value).intValue());
                break;
            }
            case UINT64: {
                builder.addU64Values(Util.getLongValue(value));
                break;
            }
            case FLOAT32: {
                builder.addF32Values(((Number)value).floatValue());
                break;
            }
            case FLOAT64: {
                builder.addF64Values(((Number)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                builder.addBoolValues(((Boolean)value).booleanValue());
                break;
            }
            case BINARY: {
                builder.addBinaryValues(ByteStringHelper.wrap((byte[])((byte[])value)));
                break;
            }
            case STRING: {
                builder.addStringValues((String)value);
                break;
            }
            case DATE: {
                builder.addDateValues(Util.getDateValue(value));
                break;
            }
            case DATETIME: {
                builder.addDatetimeValues((long)Util.getDateTimeValue(value));
                break;
            }
            case TIMESTAMP_SECOND: {
                builder.addTimestampSecondValues(Util.getLongValue(value));
                break;
            }
            case TIMESTAMP_MILLISECOND: {
                builder.addTimestampMillisecondValues(Util.getLongValue(value));
                break;
            }
            case TIMESTAMP_NANOSECOND: {
                builder.addTimestampNanosecondValues(Util.getLongValue(value));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported `data_type`: %s", dataType));
            }
        }
    }

    private static Object getValue(Columns.Column.Values values, Common.ColumnDataType dataType, int index) {
        switch (dataType) {
            case INT8: {
                return values.getI8Values(index);
            }
            case INT16: {
                return values.getI16Values(index);
            }
            case INT32: {
                return values.getI32Values(index);
            }
            case INT64: {
                return values.getI64Values(index);
            }
            case UINT8: {
                return values.getU8Values(index);
            }
            case UINT16: {
                return values.getU16Values(index);
            }
            case UINT32: {
                return values.getU32Values(index);
            }
            case UINT64: {
                return values.getU64Values(index);
            }
            case FLOAT32: {
                return Float.valueOf(values.getF32Values(index));
            }
            case FLOAT64: {
                return values.getF64Values(index);
            }
            case BOOLEAN: {
                return values.getBoolValues(index);
            }
            case BINARY: {
                return values.getBinaryValues(index);
            }
            case STRING: {
                return values.getStringValues(index);
            }
            case DATE: {
                return values.getDateValues(index);
            }
            case DATETIME: {
                return values.getDatetimeValues(index);
            }
            case TIMESTAMP_SECOND: {
                return values.getTimestampSecondValues(index);
            }
            case TIMESTAMP_MILLISECOND: {
                return values.getTimestampMillisecondValues(index);
            }
            case TIMESTAMP_NANOSECOND: {
                return values.getTimestampNanosecondValues(index);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported `data_type`: %s", dataType));
    }

    private ColumnHelper() {
    }
}

