/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.Into;
import io.greptime.common.util.Ensures;
import io.greptime.models.AuthInfo;
import io.greptime.models.PromRangeQuery;
import io.greptime.models.SelectExprType;
import io.greptime.v1.Common;
import io.greptime.v1.Database;
import java.util.Optional;

public class QueryRequest
implements Into<Database.GreptimeRequest> {
    private SelectExprType exprType;
    private String ql;
    private PromRangeQuery promRangeQuery;
    private Optional<String> databaseName;
    private Optional<AuthInfo> authInfo;

    public SelectExprType getExprType() {
        return this.exprType;
    }

    public String getQl() {
        return this.ql;
    }

    public PromRangeQuery getPromRangeQuery() {
        return this.promRangeQuery;
    }

    public void setAuthInfo(AuthInfo authInfo) {
        this.authInfo = Optional.of(authInfo);
    }

    public String toString() {
        return "QueryRequest{exprType=" + (Object)((Object)this.exprType) + ", ql='" + this.ql + '\'' + ", promRangeQuery=" + this.promRangeQuery + ", databaseName=" + this.databaseName + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Database.GreptimeRequest into() {
        Database.QueryRequest.Builder builder = Database.QueryRequest.newBuilder();
        Common.RequestHeader.Builder headerBuilder = Common.RequestHeader.newBuilder();
        this.authInfo.ifPresent(auth -> headerBuilder.setAuthorization(auth.into()));
        this.databaseName.ifPresent(arg_0 -> ((Common.RequestHeader.Builder)headerBuilder).setDbname(arg_0));
        switch (this.getExprType()) {
            case Sql: {
                builder.setSql(this.getQl());
                break;
            }
            case Promql: {
                builder.setPromRangeQuery(this.getPromRangeQuery().into());
            }
        }
        return Database.GreptimeRequest.newBuilder().setHeader(headerBuilder.build()).setQuery(builder.build()).build();
    }

    public static class Builder {
        private SelectExprType exprType;
        private String ql;
        private PromRangeQuery promRangeQuery;
        private String databaseName;

        public Builder exprType(SelectExprType exprType) {
            this.exprType = exprType;
            return this;
        }

        public Builder ql(String ql) {
            this.ql = ql;
            return this;
        }

        public Builder promQueryRange(PromRangeQuery promRangeQuery) {
            this.promRangeQuery = promRangeQuery;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder ql(String fmtQl, Object ... args) {
            this.ql = String.format(fmtQl, args);
            return this;
        }

        public QueryRequest build() {
            QueryRequest req = new QueryRequest();
            req.exprType = (SelectExprType)((Object)Ensures.ensureNonNull((Object)((Object)this.exprType), (String)"null `exprType`"));
            switch (req.exprType) {
                case Sql: {
                    req.ql = (String)Ensures.ensureNonNull((Object)this.ql, (String)"null `ql`");
                    break;
                }
                case Promql: {
                    req.promRangeQuery = (PromRangeQuery)Ensures.ensureNonNull((Object)this.promRangeQuery, (String)"null `promQueryRange`");
                }
            }
            req.databaseName = Optional.ofNullable(this.databaseName);
            req.authInfo = Optional.empty();
            return req;
        }
    }
}

