/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import com.codahale.metrics.Histogram;
import io.greptime.Util;
import io.greptime.common.Endpoint;
import io.greptime.common.util.Clock;
import io.greptime.models.ColumnDataType;
import io.greptime.models.Row;
import io.greptime.models.Value;
import io.greptime.rpc.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SelectRows
extends Iterator<Row> {
    public boolean isReady();

    public void close();

    default public List<Row> collect() {
        Iterable iterable = () -> this;
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    default public List<Map<String, Object>> collectToMaps() {
        Iterable iterable = () -> this;
        return StreamSupport.stream(iterable.spliterator(), false).map(row -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Value v : row.values()) {
                map.put(v.name(), v.value());
            }
            return map;
        }).collect(Collectors.toList());
    }

    public static class DefaultSelectRows
    implements SelectRows {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultSelectRows.class);
        private final Context ctx;
        private final Queue<Row> rows = new ConcurrentLinkedQueue<Row>();
        private final Histogram readRowsNum;
        private final FlightStream flightStream;

        public DefaultSelectRows(Context ctx, Histogram readRowsNum, FlightStream flightStream) {
            this.ctx = ctx;
            this.readRowsNum = readRowsNum;
            this.flightStream = flightStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void consume(VectorSchemaRoot recordBatch) {
            int index;
            long start;
            Long queryId;
            block8: {
                List fields = recordBatch.getSchema().getFields();
                List vectors = recordBatch.getFieldVectors();
                queryId = (Long)this.ctx.get("QueryId");
                Long queryStart = (Long)this.ctx.remove("QueryStart");
                if (Util.isRwLogging() && queryStart != null) {
                    Endpoint endpoint = (Endpoint)this.ctx.get("Endpoint");
                    LOG.info("[Query-{}] First time consuming data from {}, costs {} ms", new Object[]{queryId, endpoint, Clock.defaultClock().duration(queryStart.longValue())});
                }
                start = Clock.defaultClock().getTick();
                try {
                    for (index = 0; index < recordBatch.getRowCount(); ++index) {
                        ArrayList<Value> values = new ArrayList<Value>(vectors.size());
                        for (int i = 0; i < vectors.size(); ++i) {
                            Field field = (Field)fields.get(i);
                            FieldVector vector = (FieldVector)vectors.get(i);
                            values.add(new Value.DefaultValue(field.getName(), ColumnDataType.fromArrowType(field.getType()), vector.getObject(index)));
                        }
                        this.rows.offer(new Row.DefaultRow(values));
                    }
                    if (this.readRowsNum == null) break block8;
                }
                catch (Throwable throwable) {
                    if (this.readRowsNum != null) {
                        this.readRowsNum.update(index);
                    }
                    if (Util.isRwLogging()) {
                        Endpoint endpoint = (Endpoint)this.ctx.get("Endpoint");
                        LOG.info("[Query-{}] Consume {} rows from {}, costs {} ms", new Object[]{queryId, index, endpoint, Clock.defaultClock().duration(start)});
                    }
                    throw throwable;
                }
                this.readRowsNum.update(index);
            }
            if (Util.isRwLogging()) {
                Endpoint endpoint = (Endpoint)this.ctx.get("Endpoint");
                LOG.info("[Query-{}] Consume {} rows from {}, costs {} ms", new Object[]{queryId, index, endpoint, Clock.defaultClock().duration(start)});
            }
        }

        @Override
        public boolean isReady() {
            return this.flightStream.hasRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            boolean hasNext;
            block17: {
                boolean bl = hasNext = !this.rows.isEmpty();
                if (hasNext) {
                    return true;
                }
                try {
                    hasNext = this.flightStream.next();
                    if (!hasNext) break block17;
                    try (VectorSchemaRoot recordBatch = this.flightStream.getRoot();){
                        this.consume(recordBatch);
                    }
                }
                finally {
                    if (!hasNext) {
                        this.close();
                    }
                }
            }
            return hasNext;
        }

        @Override
        public Row next() {
            return this.rows.poll();
        }

        @Override
        public void close() {
            try {
                this.flightStream.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close `FlightStream`", (Throwable)e);
            }
        }
    }
}

