/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallOptions;
import org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.InternalFlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.auth.ClientAuthInterceptor;
import org.apache.arrow.flight.grpc.ClientInterceptorAdapter;
import org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;

public class InternalFlightClient
implements AutoCloseable {
    private static final int PENDING_REQUESTS = 5;
    private static final int MAX_CHANNEL_TRACE_EVENTS = 0;
    private final BufferAllocator allocator;
    private final ManagedChannel channel;
    private final Channel interceptedChannel;
    private final FlightServiceGrpc.FlightServiceBlockingStub blockingStub;
    private final FlightServiceGrpc.FlightServiceStub asyncStub;
    private final ClientAuthInterceptor authInterceptor = new ClientAuthInterceptor();
    private final MethodDescriptor<Flight.Ticket, ArrowMessage> doGetDescriptor;
    private final MethodDescriptor<ArrowMessage, Flight.PutResult> doPutDescriptor;
    private final MethodDescriptor<ArrowMessage, ArrowMessage> doExchangeDescriptor;
    private final List<FlightClientMiddleware.Factory> middleware;

    public InternalFlightClient(BufferAllocator incomingAllocator, ManagedChannel channel, List<FlightClientMiddleware.Factory> middleware) {
        this.allocator = incomingAllocator.newChildAllocator("flight-client", 0L, Long.MAX_VALUE);
        this.channel = channel;
        this.middleware = middleware;
        ClientInterceptor[] interceptors = new ClientInterceptor[]{this.authInterceptor, new ClientInterceptorAdapter(middleware)};
        this.interceptedChannel = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])interceptors);
        this.blockingStub = FlightServiceGrpc.newBlockingStub((Channel)this.interceptedChannel);
        this.asyncStub = FlightServiceGrpc.newStub((Channel)this.interceptedChannel);
        this.doGetDescriptor = FlightBindingService.getDoGetDescriptor((BufferAllocator)this.allocator);
        this.doPutDescriptor = FlightBindingService.getDoPutDescriptor((BufferAllocator)this.allocator);
        this.doExchangeDescriptor = FlightBindingService.getDoExchangeDescriptor((BufferAllocator)this.allocator);
    }

    public InternalFlightStream getStream(Ticket ticket, CallOption ... options) {
        io.grpc.CallOptions callOptions = ((FlightServiceGrpc.FlightServiceStub)CallOptions.wrapStub((AbstractStub)this.asyncStub, (CallOption[])options)).getCallOptions();
        ClientCall call = this.interceptedChannel.newCall(this.doGetDescriptor, callOptions);
        FlightStream stream = new FlightStream(this.allocator, 5, (arg_0, arg_1) -> ((ClientCall)call).cancel(arg_0, arg_1), arg_0 -> ((ClientCall)call).request(arg_0));
        final StreamObserver delegate = stream.asObserver();
        final CompletableFuture<Void> completed = new CompletableFuture<Void>();
        ClientResponseObserver<Flight.Ticket, ArrowMessage> clientResponseObserver = new ClientResponseObserver<Flight.Ticket, ArrowMessage>(){

            public void beforeStart(ClientCallStreamObserver<Flight.Ticket> requestStream) {
                requestStream.disableAutoInboundFlowControl();
            }

            public void onNext(ArrowMessage value) {
                delegate.onNext((Object)value);
            }

            public void onError(Throwable t) {
                delegate.onError(StatusUtils.toGrpcException((Throwable)t));
                completed.completeExceptionally(t);
            }

            public void onCompleted() {
                delegate.onCompleted();
                completed.complete(null);
            }
        };
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)ticket.toProtocol(), (StreamObserver)clientResponseObserver);
        return new InternalFlightStream(stream, completed);
    }

    @Override
    public void close() throws Exception {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        this.allocator.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BufferAllocator allocator;
        private Location location;
        private boolean forceTls = false;
        private int maxInboundMessageSize = Integer.MAX_VALUE;
        private InputStream trustedCertificates = null;
        private InputStream clientCertificate = null;
        private InputStream clientKey = null;
        private String overrideHostname = null;
        private List<FlightClientMiddleware.Factory> middleware = new ArrayList<FlightClientMiddleware.Factory>();
        private boolean verifyServer = true;

        private Builder() {
        }

        private Builder(BufferAllocator allocator, Location location) {
            this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator);
            this.location = (Location)Preconditions.checkNotNull((Object)location);
        }

        public Builder useTls() {
            this.forceTls = true;
            return this;
        }

        public Builder overrideHostname(String hostname) {
            this.overrideHostname = hostname;
            return this;
        }

        public Builder maxInboundMessageSize(int maxSize) {
            Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
            this.maxInboundMessageSize = maxSize;
            return this;
        }

        public Builder trustedCertificates(InputStream stream) {
            this.trustedCertificates = (InputStream)Preconditions.checkNotNull((Object)stream);
            return this;
        }

        public Builder clientCertificate(InputStream clientCertificate, InputStream clientKey) {
            Preconditions.checkNotNull((Object)clientKey);
            this.clientCertificate = (InputStream)Preconditions.checkNotNull((Object)clientCertificate);
            this.clientKey = (InputStream)Preconditions.checkNotNull((Object)clientKey);
            return this;
        }

        public Builder allocator(BufferAllocator allocator) {
            this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator);
            return this;
        }

        public Builder location(Location location) {
            this.location = (Location)Preconditions.checkNotNull((Object)location);
            return this;
        }

        public Builder intercept(FlightClientMiddleware.Factory factory) {
            this.middleware.add(factory);
            return this;
        }

        public Builder verifyServer(boolean verifyServer) {
            this.verifyServer = verifyServer;
            return this;
        }

        public InternalFlightClient build() {
            NettyChannelBuilder builder;
            switch (this.location.getUri().getScheme()) {
                case "grpc": 
                case "grpc+tcp": 
                case "grpc+tls": {
                    builder = NettyChannelBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    break;
                }
                case "grpc+unix": {
                    builder = NettyChannelBuilder.forAddress((SocketAddress)this.location.toSocketAddress());
                    try {
                        try {
                            builder.channelType(Class.forName("io.netty.channel.epoll.EpollDomainSocketChannel"));
                            EventLoopGroup elg = (EventLoopGroup)Class.forName("io.netty.channel.epoll.EpollEventLoopGroup").newInstance();
                            builder.eventLoopGroup(elg);
                        }
                        catch (ClassNotFoundException e) {
                            builder.channelType(Class.forName("io.netty.channel.kqueue.KQueueDomainSocketChannel"));
                            EventLoopGroup elg = (EventLoopGroup)Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup").newInstance();
                            builder.eventLoopGroup(elg);
                        }
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new UnsupportedOperationException("Could not find suitable Netty native transport implementation for domain socket address.");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Scheme is not supported: " + this.location.getUri().getScheme());
                }
            }
            if (this.forceTls || "grpc+tls".equals(this.location.getUri().getScheme())) {
                boolean hasKeyCertPair;
                builder.useTransportSecurity();
                boolean hasTrustedCerts = this.trustedCertificates != null;
                boolean bl = hasKeyCertPair = this.clientCertificate != null && this.clientKey != null;
                if (!this.verifyServer && (hasTrustedCerts || hasKeyCertPair)) {
                    throw new IllegalArgumentException("FlightClient has been configured to disable server verification, but certificate options have been specified.");
                }
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (!this.verifyServer) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else if (this.trustedCertificates != null || this.clientCertificate != null || this.clientKey != null) {
                    if (this.trustedCertificates != null) {
                        sslContextBuilder.trustManager(this.trustedCertificates);
                    }
                    if (this.clientCertificate != null && this.clientKey != null) {
                        sslContextBuilder.keyManager(this.clientCertificate, this.clientKey);
                    }
                }
                try {
                    builder.sslContext(sslContextBuilder.build());
                }
                catch (SSLException e) {
                    throw new RuntimeException(e);
                }
                if (this.overrideHostname != null) {
                    builder.overrideAuthority(this.overrideHostname);
                }
            } else {
                builder.usePlaintext();
            }
            ((NettyChannelBuilder)builder.maxTraceEvents(0)).maxInboundMessageSize(this.maxInboundMessageSize);
            return new InternalFlightClient(this.allocator, builder.build(), this.middleware);
        }
    }
}

