/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.LazyList;
import io.helidon.common.LazyValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class LazyListImpl<T>
implements LazyList<T> {
    private final List<LazyValue<T>> lazyValues = new ArrayList<LazyValue<T>>();
    private List<T> allLoaded;

    LazyListImpl(List<LazyValue<T>> lazyValues) {
        this.lazyValues.addAll(lazyValues);
    }

    @Override
    public void add(Supplier<T> supplier) {
        this.lazyValues.add(LazyValue.create(supplier));
    }

    private List<T> loadAll() {
        if (this.allLoaded == null) {
            this.allLoaded = this.lazyValues.stream().map(Supplier::get).collect(Collectors.toList());
        }
        return this.allLoaded;
    }

    @Override
    public int size() {
        return this.lazyValues.size();
    }

    @Override
    public boolean isEmpty() {
        return this.lazyValues.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.lazyValues.stream().map(Supplier::get).anyMatch(tLazyValue -> Objects.equals(o, tLazyValue));
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<LazyValue<T>> lazyValueIterator = this.lazyValues.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return lazyValueIterator.hasNext();
            }

            @Override
            public T next() {
                return ((LazyValue)lazyValueIterator.next()).get();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.loadAll().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.loadAll().toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.lazyValues.add(LazyValue.create(t));
    }

    @Override
    public boolean remove(Object o) {
        return this.lazyValues.removeIf(lv -> Objects.equals(o, lv.get()));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.loadAll().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        c.forEach(v -> this.lazyValues.add(LazyValue.create(v)));
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        c.forEach(this::add);
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.loadAll().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.loadAll().retainAll(c);
    }

    @Override
    public void clear() {
        this.lazyValues.clear();
        if (this.allLoaded != null) {
            this.allLoaded.clear();
        }
    }

    @Override
    public T get(int index) {
        return this.lazyValues.get(index).get();
    }

    @Override
    public T set(int index, T element) {
        return this.lazyValues.set(index, LazyValue.create(element)).get();
    }

    @Override
    public void add(int index, T element) {
        this.lazyValues.add(index, LazyValue.create(element));
    }

    @Override
    public T remove(int index) {
        return this.lazyValues.remove(index).get();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.lazyValues.size(); ++i) {
            LazyValue<T> lv = this.lazyValues.get(i);
            if (!Objects.equals(o, lv.get())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = -1;
        for (int i = 0; i < this.lazyValues.size(); ++i) {
            LazyValue<T> lv = this.lazyValues.get(i);
            if (!Objects.equals(o, lv.get())) continue;
            index = i;
        }
        return index;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new LazyListIterator<T>(this.lazyValues.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new LazyListIterator<T>(this.lazyValues.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new LazyListImpl<T>(this.lazyValues.subList(fromIndex, toIndex));
    }

    private static class LazyListIterator<T>
    implements ListIterator<T> {
        private final ListIterator<LazyValue<T>> innerIterator;

        LazyListIterator(ListIterator<LazyValue<T>> innerIterator) {
            this.innerIterator = innerIterator;
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public T next() {
            return this.innerIterator.next().get();
        }

        @Override
        public boolean hasPrevious() {
            return this.innerIterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.innerIterator.previous().get();
        }

        @Override
        public int nextIndex() {
            return this.innerIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.innerIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }

        @Override
        public void set(T t) {
            this.innerIterator.set(LazyValue.create(t));
        }

        @Override
        public void add(T t) {
            this.innerIterator.add(LazyValue.create(t));
        }
    }
}

