/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.NativeImageHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LogConfig {
    private static final String TEST_LOGGING_FILE = "logging-test.properties";
    private static final String LOGGING_FILE = "logging.properties";
    private static final String SYS_PROP_DISABLE_CONFIG = "io.helidon.logging.config.disabled";
    private static final String SYS_PROP_LOGGING_CLASS = "java.util.logging.config.class";
    private static final String SYS_PROP_LOGGING_FILE = "java.util.logging.config.file";

    private LogConfig() {
    }

    public static void configureRuntime() {
        if (NativeImageHelper.isRuntime()) {
            LogConfig.configureLogging("runtime");
        }
    }

    private static void configureLogging(String when) {
        try {
            LogConfig.doConfigureLogging(when);
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging");
            e.printStackTrace();
        }
    }

    private static void doConfigureLogging(String when) throws IOException {
        Object source;
        String disableConfigProperty = System.getProperty(SYS_PROP_DISABLE_CONFIG);
        if (Boolean.parseBoolean(disableConfigProperty)) {
            return;
        }
        String configClass = System.getProperty(SYS_PROP_LOGGING_CLASS);
        String configPath = System.getProperty(SYS_PROP_LOGGING_FILE);
        if (configClass != null) {
            source = "class: " + configClass;
        } else if (configPath != null) {
            Path path = Paths.get(configPath, new String[0]);
            source = path.toAbsolutePath().toString();
        } else {
            source = LogConfig.findAndConfigureLogging();
        }
        Logger.getLogger(LogConfig.class.getName()).info("Logging at " + when + " configured using " + (String)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findAndConfigureLogging() throws IOException {
        BufferedInputStream logConfigStream;
        Object source = "defaults";
        Path path = Paths.get("", new String[0]).resolve(LOGGING_FILE);
        if (Files.exists(path, new LinkOption[0])) {
            logConfigStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            source = "file: " + path.toAbsolutePath();
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream resourceStream = LogConfig.classPath(TEST_LOGGING_FILE);
            String cpSource = "classpath: /logging-test.properties";
            if (resourceStream == null) {
                resourceStream = LogConfig.contextClassPath(TEST_LOGGING_FILE, cl);
                cpSource = "context classpath: /logging-test.properties";
            }
            if (resourceStream == null) {
                resourceStream = LogConfig.classPath(LOGGING_FILE);
                cpSource = "classpath: /logging.properties";
            }
            if (resourceStream == null) {
                resourceStream = LogConfig.contextClassPath(LOGGING_FILE, cl);
                cpSource = "context classpath: /logging.properties";
            }
            if (resourceStream == null) {
                return source;
            }
            logConfigStream = new BufferedInputStream(resourceStream);
            source = cpSource;
        }
        try {
            LogManager.getLogManager().readConfiguration(logConfigStream);
        }
        finally {
            ((InputStream)logConfigStream).close();
        }
        return source;
    }

    private static InputStream contextClassPath(String loggingFile, ClassLoader cl) {
        return cl.getResourceAsStream(loggingFile);
    }

    private static InputStream classPath(String loggingFile) {
        return LogConfig.class.getResourceAsStream("/" + loggingFile);
    }

    public static void initClass() {
    }

    static {
        LogConfig.configureLogging("initialization");
    }
}

