/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.config;

import io.micronaut.aot.core.Configuration;
import io.micronaut.aot.core.Runtime;
import io.micronaut.core.annotation.NonNull;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;

public class DefaultConfiguration
implements Configuration {
    private final Properties config;

    public DefaultConfiguration(Properties backingProperties) {
        this.config = backingProperties;
    }

    @Override
    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    @Override
    @NonNull
    public String mandatoryValue(String key) {
        String value = this.config.getProperty(key);
        if (value == null || value.isEmpty()) {
            DefaultConfiguration.invalidConfiguration(key, "should not be null or empty");
        }
        return value;
    }

    @Override
    public <T> T optionalValue(String key, Function<Optional<String>, T> producer) {
        Object raw;
        String value = this.config.getProperty(key);
        if (value == null && (raw = this.config.get(key)) != null) {
            value = String.valueOf(raw);
        }
        return producer.apply(Optional.ofNullable(value));
    }

    @Override
    @NonNull
    public Runtime getRuntime() {
        return this.optionalValue("runtime", v -> v.map(r -> Runtime.valueOf(r.toUpperCase(Locale.ENGLISH))).orElse(Runtime.JIT));
    }

    private static void invalidConfiguration(String key, String message) {
        throw new IllegalStateException("Parameter '" + key + "' " + message);
    }
}

