/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultBeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RequiresCondition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.Failure;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class ApplicationContextAnalyzer {
    private final ApplicationContext applicationContext;

    private ApplicationContextAnalyzer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Set<String> getEnvironmentNames() {
        return this.applicationContext.getEnvironment().getActiveNames();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public static ApplicationContextAnalyzer create() {
        return ApplicationContextAnalyzer.create(spec -> {});
    }

    public static ApplicationContextAnalyzer create(Consumer<? super ApplicationContextBuilder> spec) {
        ApplicationContextBuilder builder = ApplicationContext.builder();
        spec.accept((ApplicationContextBuilder)builder);
        ApplicationContext context = builder.build();
        ApplicationContextAnalyzer.finalizeConfiguration(context);
        return new ApplicationContextAnalyzer(context);
    }

    private static void finalizeConfiguration(ApplicationContext context) {
        try {
            Method method = DefaultBeanContext.class.getDeclaredMethod("finalizeConfiguration", new Class[0]);
            method.invoke((Object)context, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                Method method = DefaultBeanContext.class.getDeclaredMethod("readAllBeanConfigurations", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)context, new Object[0]);
                method = DefaultBeanContext.class.getDeclaredMethod("readAllBeanDefinitionClasses", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)context, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        Environment environment = context.getEnvironment();
        environment.start();
        context.registerSingleton(Environment.class, (Object)environment);
    }

    public Predicate<AnnotationMetadataProvider> getAnnotationMetadataPredicate() {
        return new AnnotationMetadataProviderPredicate();
    }

    private class AnnotationMetadataProviderPredicate
    implements Predicate<AnnotationMetadataProvider> {
        private AnnotationMetadataProviderPredicate() {
        }

        @Override
        public boolean test(AnnotationMetadataProvider component) {
            ShallowConditionContext context = new ShallowConditionContext(ApplicationContextAnalyzer.this, component);
            return new RequiresCondition(component.getAnnotationMetadata()).matches((ConditionContext)context);
        }
    }

    private static final class ShallowConditionContext<T extends AnnotationMetadataProvider>
    implements ConditionContext<T> {
        private final T component;
        private List<Failure> failures;
        final /* synthetic */ ApplicationContextAnalyzer this$0;

        private ShallowConditionContext(T component) {
            this.this$0 = var1_1;
            this.component = component;
        }

        public boolean containsProperty(String name) {
            return this.this$0.applicationContext.containsProperty(name);
        }

        public boolean containsProperties(String name) {
            return this.this$0.applicationContext.containsProperties(name);
        }

        public <T> Optional<T> getProperty(String name, ArgumentConversionContext<T> conversionContext) {
            return this.this$0.applicationContext.getProperty(name, conversionContext);
        }

        public Collection<List<String>> getPropertyPathMatches(String pathPattern) {
            return this.this$0.applicationContext.getPropertyPathMatches(pathPattern);
        }

        public <T> T getBean(BeanDefinition<T> definition) {
            return (T)this.this$0.applicationContext.getBean(definition);
        }

        public <T> T getBean(Class<T> beanType, Qualifier<T> qualifier) {
            return (T)this.this$0.applicationContext.getBean(beanType, qualifier);
        }

        public <T> Optional<T> findBean(Argument<T> beanType, Qualifier<T> qualifier) {
            return this.this$0.applicationContext.findBean(beanType, qualifier);
        }

        public <T> Optional<T> findBean(Class<T> beanType, Qualifier<T> qualifier) {
            return this.this$0.applicationContext.findBean(beanType, qualifier);
        }

        public <T> Collection<T> getBeansOfType(Class<T> beanType) {
            return this.this$0.applicationContext.getBeansOfType(beanType);
        }

        public <T> Collection<T> getBeansOfType(Class<T> beanType, Qualifier<T> qualifier) {
            return this.this$0.applicationContext.getBeansOfType(beanType, qualifier);
        }

        public <T> Stream<T> streamOfType(Class<T> beanType, Qualifier<T> qualifier) {
            return this.this$0.applicationContext.streamOfType(beanType, qualifier);
        }

        public <T> T getProxyTargetBean(Class<T> beanType, Qualifier<T> qualifier) {
            return (T)this.this$0.applicationContext.getProxyTargetBean(beanType, qualifier);
        }

        public T getComponent() {
            return this.component;
        }

        public BeanContext getBeanContext() {
            return this.this$0.applicationContext;
        }

        public BeanResolutionContext getBeanResolutionContext() {
            return new DefaultBeanResolutionContext((BeanContext)this.this$0.applicationContext, null);
        }

        public List<Failure> getFailures() {
            return this.failures == null ? Collections.emptyList() : this.failures;
        }

        public ConditionContext<T> fail(Failure failure) {
            if (this.failures == null) {
                this.failures = new ArrayList<Failure>();
            }
            this.failures.add(failure);
            return this;
        }
    }
}

