/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.context;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.Configuration;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.core.context.ApplicationContextAnalyzer;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.optim.StaticOptimizations;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSourceGenerationContext
implements AOTContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSourceGenerationContext.class);
    private final String packageName;
    private final ApplicationContextAnalyzer analyzer;
    private final Set<String> excludedResources = new TreeSet<String>();
    private final Map<String, List<String>> diagnostics = new ConcurrentHashMap<String, List<String>>();
    private final Set<Class<?>> classesRequiredAtCompilation = new HashSet();
    private final Configuration configuration;
    private final Map<Class<?>, Object> context = new HashMap();
    private final List<JavaFile> generatedJavaFiles = new ArrayList<JavaFile>();
    private final List<MethodSpec> initializers = new ArrayList<MethodSpec>();
    private final Path generatedResourcesDirectory;

    public DefaultSourceGenerationContext(String packageName, ApplicationContextAnalyzer analyzer, Configuration configuration, Path generatedResourcesDirectory) {
        this.packageName = packageName;
        this.analyzer = analyzer;
        this.configuration = configuration;
        this.generatedResourcesDirectory = generatedResourcesDirectory;
    }

    @Override
    @NonNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NonNull
    public Runtime getRuntime() {
        return this.configuration.getRuntime();
    }

    @Override
    @NonNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NonNull
    public ApplicationContextAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void registerExcludedResource(@NonNull String path) {
        LOGGER.debug("Registering excluded resource: {}", (Object)path);
        this.excludedResources.add(path);
    }

    @Override
    public void registerClassNeededAtCompileTime(@NonNull Class<?> clazz) {
        this.classesRequiredAtCompilation.add(clazz);
    }

    @Override
    public void registerGeneratedSourceFile(@NonNull JavaFile javaFile) {
        LOGGER.debug("Registering generated source file: {}.{}", (Object)javaFile.packageName, (Object)javaFile.typeSpec.name);
        this.generatedJavaFiles.add(javaFile);
    }

    public List<JavaFile> getGeneratedJavaFiles() {
        return Collections.unmodifiableList(this.generatedJavaFiles);
    }

    @Override
    public void registerStaticInitializer(MethodSpec staticInitializer) {
        this.initializers.add(staticInitializer);
    }

    @Override
    public <T> void registerStaticOptimization(String className, Class<T> optimizationKind, Consumer<? super CodeBlock.Builder> bodyBuilder) {
        CodeBlock.Builder body = CodeBlock.builder();
        bodyBuilder.accept((CodeBlock.Builder)body);
        MethodSpec method = MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(optimizationKind).addCode(body.build()).build();
        TypeSpec generatedType = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get(StaticOptimizations.Loader.class, (Type[])new Type[]{optimizationKind})).addMethod(method).build();
        this.registerGeneratedSourceFile(this.javaFile(generatedType));
        this.registerServiceImplementation(StaticOptimizations.Loader.class, className);
    }

    @Override
    public void registerServiceImplementation(Class<?> serviceType, String simpleServiceName) {
        this.registerGeneratedResource("META-INF/services/" + serviceType.getName(), serviceFile -> {
            try (PrintWriter wrt = new PrintWriter(new FileWriter((File)serviceFile, true));){
                wrt.println(this.getPackageName() + "." + simpleServiceName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<MethodSpec> getGeneratedStaticInitializers() {
        return this.initializers;
    }

    @Override
    public void registerGeneratedResource(@NonNull String path, Consumer<? super File> consumer) {
        LOGGER.debug("Registering generated resource file: {}", (Object)path);
        Path relative = this.generatedResourcesDirectory.resolve(path);
        File resourceFile = relative.toFile();
        File parent = resourceFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Unable to create parent file " + parent + " for resource " + path);
        }
        consumer.accept(resourceFile);
    }

    @NonNull
    public List<File> getExtraClasspath() {
        return this.classesRequiredAtCompilation.stream().map(Class::getProtectionDomain).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).map(url -> {
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NonNull
    public Set<String> getExcludedResources() {
        return Collections.unmodifiableSet(this.excludedResources);
    }

    @Override
    @NonNull
    public JavaFile javaFile(TypeSpec typeSpec) {
        return JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).build();
    }

    @Override
    public void addDiagnostics(String category, String message) {
        this.diagnostics.computeIfAbsent(category, c -> Collections.synchronizedList(new ArrayList())).add(message);
    }

    @Override
    public <T> void put(@NonNull Class<T> type, @NonNull T value) {
        this.context.put(type, value);
    }

    @Override
    @NonNull
    public <T> Optional<T> get(@NonNull Class<T> type) {
        Object o = this.context.get(type);
        return Optional.ofNullable(o);
    }

    @Override
    @NonNull
    public Map<String, List<String>> getDiagnostics() {
        return this.diagnostics;
    }
}

