/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.collection.request;

import io.milvus.common.clientenum.FunctionType;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.DataType;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class CreateCollectionReq {
    private String databaseName;
    @NonNull
    private String collectionName;
    private String description;
    private Integer dimension;
    private String primaryFieldName;
    private DataType idType;
    private Integer maxLength;
    private String vectorFieldName;
    private String metricType;
    private Boolean autoID;
    private Boolean enableDynamicField;
    private Integer numShards;
    private CollectionSchema collectionSchema;
    private List<IndexParam> indexParams;
    private Integer numPartitions;
    private ConsistencyLevel consistencyLevel;
    private final Map<String, String> properties;

    private static String $default$description() {
        return "";
    }

    private static String $default$primaryFieldName() {
        return "id";
    }

    private static DataType $default$idType() {
        return DataType.Int64;
    }

    private static Integer $default$maxLength() {
        return 65535;
    }

    private static String $default$vectorFieldName() {
        return "vector";
    }

    private static String $default$metricType() {
        return IndexParam.MetricType.COSINE.name();
    }

    private static Boolean $default$autoID() {
        return Boolean.FALSE;
    }

    private static Boolean $default$enableDynamicField() {
        return Boolean.TRUE;
    }

    private static Integer $default$numShards() {
        return 1;
    }

    private static List<IndexParam> $default$indexParams() {
        return new ArrayList<IndexParam>();
    }

    private static ConsistencyLevel $default$consistencyLevel() {
        return ConsistencyLevel.BOUNDED;
    }

    private static Map<String, String> $default$properties() {
        return new HashMap<String, String>();
    }

    protected CreateCollectionReq(CreateCollectionReqBuilder<?, ?> b) {
        this.databaseName = ((CreateCollectionReqBuilder)b).databaseName;
        this.collectionName = ((CreateCollectionReqBuilder)b).collectionName;
        if (this.collectionName == null) {
            throw new NullPointerException("collectionName is marked non-null but is null");
        }
        this.description = ((CreateCollectionReqBuilder)b).description$set ? ((CreateCollectionReqBuilder)b).description$value : CreateCollectionReq.$default$description();
        this.dimension = ((CreateCollectionReqBuilder)b).dimension;
        this.primaryFieldName = ((CreateCollectionReqBuilder)b).primaryFieldName$set ? ((CreateCollectionReqBuilder)b).primaryFieldName$value : CreateCollectionReq.$default$primaryFieldName();
        this.idType = ((CreateCollectionReqBuilder)b).idType$set ? ((CreateCollectionReqBuilder)b).idType$value : CreateCollectionReq.$default$idType();
        this.maxLength = ((CreateCollectionReqBuilder)b).maxLength$set ? ((CreateCollectionReqBuilder)b).maxLength$value : CreateCollectionReq.$default$maxLength();
        this.vectorFieldName = ((CreateCollectionReqBuilder)b).vectorFieldName$set ? ((CreateCollectionReqBuilder)b).vectorFieldName$value : CreateCollectionReq.$default$vectorFieldName();
        this.metricType = ((CreateCollectionReqBuilder)b).metricType$set ? ((CreateCollectionReqBuilder)b).metricType$value : CreateCollectionReq.$default$metricType();
        this.autoID = ((CreateCollectionReqBuilder)b).autoID$set ? ((CreateCollectionReqBuilder)b).autoID$value : CreateCollectionReq.$default$autoID();
        this.enableDynamicField = ((CreateCollectionReqBuilder)b).enableDynamicField$set ? ((CreateCollectionReqBuilder)b).enableDynamicField$value : CreateCollectionReq.$default$enableDynamicField();
        this.numShards = ((CreateCollectionReqBuilder)b).numShards$set ? ((CreateCollectionReqBuilder)b).numShards$value : CreateCollectionReq.$default$numShards();
        this.collectionSchema = ((CreateCollectionReqBuilder)b).collectionSchema;
        this.indexParams = ((CreateCollectionReqBuilder)b).indexParams$set ? ((CreateCollectionReqBuilder)b).indexParams$value : CreateCollectionReq.$default$indexParams();
        this.numPartitions = ((CreateCollectionReqBuilder)b).numPartitions;
        this.consistencyLevel = ((CreateCollectionReqBuilder)b).consistencyLevel$set ? ((CreateCollectionReqBuilder)b).consistencyLevel$value : CreateCollectionReq.$default$consistencyLevel();
        this.properties = ((CreateCollectionReqBuilder)b).properties$set ? ((CreateCollectionReqBuilder)b).properties$value : CreateCollectionReq.$default$properties();
    }

    public static CreateCollectionReqBuilder<?, ?> builder() {
        return new CreateCollectionReqBuilderImpl();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @NonNull
    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public String getPrimaryFieldName() {
        return this.primaryFieldName;
    }

    public DataType getIdType() {
        return this.idType;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public Boolean getAutoID() {
        return this.autoID;
    }

    public Boolean getEnableDynamicField() {
        return this.enableDynamicField;
    }

    public Integer getNumShards() {
        return this.numShards;
    }

    public CollectionSchema getCollectionSchema() {
        return this.collectionSchema;
    }

    public List<IndexParam> getIndexParams() {
        return this.indexParams;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setCollectionName(@NonNull String collectionName) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName is marked non-null but is null");
        }
        this.collectionName = collectionName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setPrimaryFieldName(String primaryFieldName) {
        this.primaryFieldName = primaryFieldName;
    }

    public void setIdType(DataType idType) {
        this.idType = idType;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setVectorFieldName(String vectorFieldName) {
        this.vectorFieldName = vectorFieldName;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public void setAutoID(Boolean autoID) {
        this.autoID = autoID;
    }

    public void setEnableDynamicField(Boolean enableDynamicField) {
        this.enableDynamicField = enableDynamicField;
    }

    public void setNumShards(Integer numShards) {
        this.numShards = numShards;
    }

    public void setCollectionSchema(CollectionSchema collectionSchema) {
        this.collectionSchema = collectionSchema;
    }

    public void setIndexParams(List<IndexParam> indexParams) {
        this.indexParams = indexParams;
    }

    public void setNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateCollectionReq)) {
            return false;
        }
        CreateCollectionReq other = (CreateCollectionReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Boolean this$autoID = this.getAutoID();
        Boolean other$autoID = other.getAutoID();
        if (this$autoID == null ? other$autoID != null : !((Object)this$autoID).equals(other$autoID)) {
            return false;
        }
        Boolean this$enableDynamicField = this.getEnableDynamicField();
        Boolean other$enableDynamicField = other.getEnableDynamicField();
        if (this$enableDynamicField == null ? other$enableDynamicField != null : !((Object)this$enableDynamicField).equals(other$enableDynamicField)) {
            return false;
        }
        Integer this$numShards = this.getNumShards();
        Integer other$numShards = other.getNumShards();
        if (this$numShards == null ? other$numShards != null : !((Object)this$numShards).equals(other$numShards)) {
            return false;
        }
        Integer this$numPartitions = this.getNumPartitions();
        Integer other$numPartitions = other.getNumPartitions();
        if (this$numPartitions == null ? other$numPartitions != null : !((Object)this$numPartitions).equals(other$numPartitions)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$primaryFieldName = this.getPrimaryFieldName();
        String other$primaryFieldName = other.getPrimaryFieldName();
        if (this$primaryFieldName == null ? other$primaryFieldName != null : !this$primaryFieldName.equals(other$primaryFieldName)) {
            return false;
        }
        DataType this$idType = this.getIdType();
        DataType other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !((Object)((Object)this$idType)).equals((Object)other$idType)) {
            return false;
        }
        String this$vectorFieldName = this.getVectorFieldName();
        String other$vectorFieldName = other.getVectorFieldName();
        if (this$vectorFieldName == null ? other$vectorFieldName != null : !this$vectorFieldName.equals(other$vectorFieldName)) {
            return false;
        }
        String this$metricType = this.getMetricType();
        String other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !this$metricType.equals(other$metricType)) {
            return false;
        }
        CollectionSchema this$collectionSchema = this.getCollectionSchema();
        CollectionSchema other$collectionSchema = other.getCollectionSchema();
        if (this$collectionSchema == null ? other$collectionSchema != null : !((Object)this$collectionSchema).equals(other$collectionSchema)) {
            return false;
        }
        List<IndexParam> this$indexParams = this.getIndexParams();
        List<IndexParam> other$indexParams = other.getIndexParams();
        if (this$indexParams == null ? other$indexParams != null : !((Object)this$indexParams).equals(other$indexParams)) {
            return false;
        }
        ConsistencyLevel this$consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel other$consistencyLevel = other.getConsistencyLevel();
        if (this$consistencyLevel == null ? other$consistencyLevel != null : !((Object)((Object)this$consistencyLevel)).equals((Object)other$consistencyLevel)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateCollectionReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Boolean $autoID = this.getAutoID();
        result = result * 59 + ($autoID == null ? 43 : ((Object)$autoID).hashCode());
        Boolean $enableDynamicField = this.getEnableDynamicField();
        result = result * 59 + ($enableDynamicField == null ? 43 : ((Object)$enableDynamicField).hashCode());
        Integer $numShards = this.getNumShards();
        result = result * 59 + ($numShards == null ? 43 : ((Object)$numShards).hashCode());
        Integer $numPartitions = this.getNumPartitions();
        result = result * 59 + ($numPartitions == null ? 43 : ((Object)$numPartitions).hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $primaryFieldName = this.getPrimaryFieldName();
        result = result * 59 + ($primaryFieldName == null ? 43 : $primaryFieldName.hashCode());
        DataType $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : ((Object)((Object)$idType)).hashCode());
        String $vectorFieldName = this.getVectorFieldName();
        result = result * 59 + ($vectorFieldName == null ? 43 : $vectorFieldName.hashCode());
        String $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : $metricType.hashCode());
        CollectionSchema $collectionSchema = this.getCollectionSchema();
        result = result * 59 + ($collectionSchema == null ? 43 : ((Object)$collectionSchema).hashCode());
        List<IndexParam> $indexParams = this.getIndexParams();
        result = result * 59 + ($indexParams == null ? 43 : ((Object)$indexParams).hashCode());
        ConsistencyLevel $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : ((Object)((Object)$consistencyLevel)).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "CreateCollectionReq(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", description=" + this.getDescription() + ", dimension=" + this.getDimension() + ", primaryFieldName=" + this.getPrimaryFieldName() + ", idType=" + (Object)((Object)this.getIdType()) + ", maxLength=" + this.getMaxLength() + ", vectorFieldName=" + this.getVectorFieldName() + ", metricType=" + this.getMetricType() + ", autoID=" + this.getAutoID() + ", enableDynamicField=" + this.getEnableDynamicField() + ", numShards=" + this.getNumShards() + ", collectionSchema=" + this.getCollectionSchema() + ", indexParams=" + this.getIndexParams() + ", numPartitions=" + this.getNumPartitions() + ", consistencyLevel=" + (Object)((Object)this.getConsistencyLevel()) + ", properties=" + this.getProperties() + ")";
    }

    private static final class CreateCollectionReqBuilderImpl
    extends CreateCollectionReqBuilder<CreateCollectionReq, CreateCollectionReqBuilderImpl> {
        private CreateCollectionReqBuilderImpl() {
        }

        @Override
        protected CreateCollectionReqBuilderImpl self() {
            return this;
        }

        @Override
        public CreateCollectionReq build() {
            return new CreateCollectionReq(this);
        }
    }

    public static class Function {
        private String name;
        private String description;
        private FunctionType functionType;
        private List<String> inputFieldNames;
        private List<String> outputFieldNames;
        private Map<String, String> params;

        private static String $default$description() {
            return "";
        }

        private static FunctionType $default$functionType() {
            return FunctionType.UNKNOWN;
        }

        private static List<String> $default$inputFieldNames() {
            return new ArrayList<String>();
        }

        private static List<String> $default$outputFieldNames() {
            return new ArrayList<String>();
        }

        private static Map<String, String> $default$params() {
            return new HashMap<String, String>();
        }

        protected Function(FunctionBuilder<?, ?> b) {
            this.name = ((FunctionBuilder)b).name;
            this.description = ((FunctionBuilder)b).description$set ? ((FunctionBuilder)b).description$value : Function.$default$description();
            this.functionType = ((FunctionBuilder)b).functionType$set ? ((FunctionBuilder)b).functionType$value : Function.$default$functionType();
            this.inputFieldNames = ((FunctionBuilder)b).inputFieldNames$set ? ((FunctionBuilder)b).inputFieldNames$value : Function.$default$inputFieldNames();
            this.outputFieldNames = ((FunctionBuilder)b).outputFieldNames$set ? ((FunctionBuilder)b).outputFieldNames$value : Function.$default$outputFieldNames();
            this.params = ((FunctionBuilder)b).params$set ? ((FunctionBuilder)b).params$value : Function.$default$params();
        }

        public static FunctionBuilder<?, ?> builder() {
            return new FunctionBuilderImpl();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public FunctionType getFunctionType() {
            return this.functionType;
        }

        public List<String> getInputFieldNames() {
            return this.inputFieldNames;
        }

        public List<String> getOutputFieldNames() {
            return this.outputFieldNames;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setFunctionType(FunctionType functionType) {
            this.functionType = functionType;
        }

        public void setInputFieldNames(List<String> inputFieldNames) {
            this.inputFieldNames = inputFieldNames;
        }

        public void setOutputFieldNames(List<String> outputFieldNames) {
            this.outputFieldNames = outputFieldNames;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Function)) {
                return false;
            }
            Function other = (Function)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            FunctionType this$functionType = this.getFunctionType();
            FunctionType other$functionType = other.getFunctionType();
            if (this$functionType == null ? other$functionType != null : !((Object)((Object)this$functionType)).equals((Object)other$functionType)) {
                return false;
            }
            List<String> this$inputFieldNames = this.getInputFieldNames();
            List<String> other$inputFieldNames = other.getInputFieldNames();
            if (this$inputFieldNames == null ? other$inputFieldNames != null : !((Object)this$inputFieldNames).equals(other$inputFieldNames)) {
                return false;
            }
            List<String> this$outputFieldNames = this.getOutputFieldNames();
            List<String> other$outputFieldNames = other.getOutputFieldNames();
            if (this$outputFieldNames == null ? other$outputFieldNames != null : !((Object)this$outputFieldNames).equals(other$outputFieldNames)) {
                return false;
            }
            Map<String, String> this$params = this.getParams();
            Map<String, String> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Function;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            FunctionType $functionType = this.getFunctionType();
            result = result * 59 + ($functionType == null ? 43 : ((Object)((Object)$functionType)).hashCode());
            List<String> $inputFieldNames = this.getInputFieldNames();
            result = result * 59 + ($inputFieldNames == null ? 43 : ((Object)$inputFieldNames).hashCode());
            List<String> $outputFieldNames = this.getOutputFieldNames();
            result = result * 59 + ($outputFieldNames == null ? 43 : ((Object)$outputFieldNames).hashCode());
            Map<String, String> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        public String toString() {
            return "CreateCollectionReq.Function(name=" + this.getName() + ", description=" + this.getDescription() + ", functionType=" + (Object)((Object)this.getFunctionType()) + ", inputFieldNames=" + this.getInputFieldNames() + ", outputFieldNames=" + this.getOutputFieldNames() + ", params=" + this.getParams() + ")";
        }

        private static final class FunctionBuilderImpl
        extends FunctionBuilder<Function, FunctionBuilderImpl> {
            private FunctionBuilderImpl() {
            }

            @Override
            protected FunctionBuilderImpl self() {
                return this;
            }

            @Override
            public Function build() {
                return new Function(this);
            }
        }

        public static abstract class FunctionBuilder<C extends Function, B extends FunctionBuilder<C, B>> {
            private String name;
            private boolean description$set;
            private String description$value;
            private boolean functionType$set;
            private FunctionType functionType$value;
            private boolean inputFieldNames$set;
            private List<String> inputFieldNames$value;
            private boolean outputFieldNames$set;
            private List<String> outputFieldNames$value;
            private boolean params$set;
            private Map<String, String> params$value;

            public B param(String key, String value) {
                if (null == this.params$value) {
                    this.params$value = new HashMap<String, String>();
                }
                this.params$value.put(key, value);
                this.params$set = true;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public B name(String name) {
                this.name = name;
                return this.self();
            }

            public B description(String description) {
                this.description$value = description;
                this.description$set = true;
                return this.self();
            }

            public B functionType(FunctionType functionType) {
                this.functionType$value = functionType;
                this.functionType$set = true;
                return this.self();
            }

            public B inputFieldNames(List<String> inputFieldNames) {
                this.inputFieldNames$value = inputFieldNames;
                this.inputFieldNames$set = true;
                return this.self();
            }

            public B outputFieldNames(List<String> outputFieldNames) {
                this.outputFieldNames$value = outputFieldNames;
                this.outputFieldNames$set = true;
                return this.self();
            }

            public B params(Map<String, String> params) {
                this.params$value = params;
                this.params$set = true;
                return this.self();
            }

            public String toString() {
                return "CreateCollectionReq.Function.FunctionBuilder(name=" + this.name + ", description$value=" + this.description$value + ", functionType$value=" + (Object)((Object)this.functionType$value) + ", inputFieldNames$value=" + this.inputFieldNames$value + ", outputFieldNames$value=" + this.outputFieldNames$value + ", params$value=" + this.params$value + ")";
            }
        }
    }

    public static class FieldSchema {
        private String name;
        private String description;
        private DataType dataType;
        private Integer maxLength;
        private Integer dimension;
        private Boolean isPrimaryKey;
        private Boolean isPartitionKey;
        private Boolean isClusteringKey;
        private Boolean autoID;
        private DataType elementType;
        private Integer maxCapacity;
        private Boolean isNullable;
        private Object defaultValue;
        private Boolean enableAnalyzer;
        private Map<String, Object> analyzerParams;
        private Boolean enableMatch;
        private Map<String, String> typeParams;
        private Map<String, Object> multiAnalyzerParams;

        private static String $default$description() {
            return "";
        }

        private static Integer $default$maxLength() {
            return 65535;
        }

        private static Boolean $default$isPrimaryKey() {
            return Boolean.FALSE;
        }

        private static Boolean $default$isPartitionKey() {
            return Boolean.FALSE;
        }

        private static Boolean $default$isClusteringKey() {
            return Boolean.FALSE;
        }

        private static Boolean $default$autoID() {
            return Boolean.FALSE;
        }

        private static Boolean $default$isNullable() {
            return Boolean.FALSE;
        }

        private static Object $default$defaultValue() {
            return null;
        }

        protected FieldSchema(FieldSchemaBuilder<?, ?> b) {
            this.name = ((FieldSchemaBuilder)b).name;
            this.description = ((FieldSchemaBuilder)b).description$set ? ((FieldSchemaBuilder)b).description$value : FieldSchema.$default$description();
            this.dataType = ((FieldSchemaBuilder)b).dataType;
            this.maxLength = ((FieldSchemaBuilder)b).maxLength$set ? ((FieldSchemaBuilder)b).maxLength$value : FieldSchema.$default$maxLength();
            this.dimension = ((FieldSchemaBuilder)b).dimension;
            this.isPrimaryKey = ((FieldSchemaBuilder)b).isPrimaryKey$set ? ((FieldSchemaBuilder)b).isPrimaryKey$value : FieldSchema.$default$isPrimaryKey();
            this.isPartitionKey = ((FieldSchemaBuilder)b).isPartitionKey$set ? ((FieldSchemaBuilder)b).isPartitionKey$value : FieldSchema.$default$isPartitionKey();
            this.isClusteringKey = ((FieldSchemaBuilder)b).isClusteringKey$set ? ((FieldSchemaBuilder)b).isClusteringKey$value : FieldSchema.$default$isClusteringKey();
            this.autoID = ((FieldSchemaBuilder)b).autoID$set ? ((FieldSchemaBuilder)b).autoID$value : FieldSchema.$default$autoID();
            this.elementType = ((FieldSchemaBuilder)b).elementType;
            this.maxCapacity = ((FieldSchemaBuilder)b).maxCapacity;
            this.isNullable = ((FieldSchemaBuilder)b).isNullable$set ? ((FieldSchemaBuilder)b).isNullable$value : FieldSchema.$default$isNullable();
            this.defaultValue = ((FieldSchemaBuilder)b).defaultValue$set ? ((FieldSchemaBuilder)b).defaultValue$value : FieldSchema.$default$defaultValue();
            this.enableAnalyzer = ((FieldSchemaBuilder)b).enableAnalyzer;
            this.analyzerParams = ((FieldSchemaBuilder)b).analyzerParams;
            this.enableMatch = ((FieldSchemaBuilder)b).enableMatch;
            this.typeParams = ((FieldSchemaBuilder)b).typeParams;
            this.multiAnalyzerParams = ((FieldSchemaBuilder)b).multiAnalyzerParams;
        }

        public static FieldSchemaBuilder<?, ?> builder() {
            return new FieldSchemaBuilderImpl();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Integer getDimension() {
            return this.dimension;
        }

        public Boolean getIsPrimaryKey() {
            return this.isPrimaryKey;
        }

        public Boolean getIsPartitionKey() {
            return this.isPartitionKey;
        }

        public Boolean getIsClusteringKey() {
            return this.isClusteringKey;
        }

        public Boolean getAutoID() {
            return this.autoID;
        }

        public DataType getElementType() {
            return this.elementType;
        }

        public Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public Boolean getIsNullable() {
            return this.isNullable;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Boolean getEnableAnalyzer() {
            return this.enableAnalyzer;
        }

        public Map<String, Object> getAnalyzerParams() {
            return this.analyzerParams;
        }

        public Boolean getEnableMatch() {
            return this.enableMatch;
        }

        public Map<String, String> getTypeParams() {
            return this.typeParams;
        }

        public Map<String, Object> getMultiAnalyzerParams() {
            return this.multiAnalyzerParams;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }

        public void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        public void setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        public void setIsPartitionKey(Boolean isPartitionKey) {
            this.isPartitionKey = isPartitionKey;
        }

        public void setIsClusteringKey(Boolean isClusteringKey) {
            this.isClusteringKey = isClusteringKey;
        }

        public void setAutoID(Boolean autoID) {
            this.autoID = autoID;
        }

        public void setElementType(DataType elementType) {
            this.elementType = elementType;
        }

        public void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public void setIsNullable(Boolean isNullable) {
            this.isNullable = isNullable;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setEnableAnalyzer(Boolean enableAnalyzer) {
            this.enableAnalyzer = enableAnalyzer;
        }

        public void setAnalyzerParams(Map<String, Object> analyzerParams) {
            this.analyzerParams = analyzerParams;
        }

        public void setEnableMatch(Boolean enableMatch) {
            this.enableMatch = enableMatch;
        }

        public void setTypeParams(Map<String, String> typeParams) {
            this.typeParams = typeParams;
        }

        public void setMultiAnalyzerParams(Map<String, Object> multiAnalyzerParams) {
            this.multiAnalyzerParams = multiAnalyzerParams;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldSchema)) {
                return false;
            }
            FieldSchema other = (FieldSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxLength = this.getMaxLength();
            Integer other$maxLength = other.getMaxLength();
            if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
                return false;
            }
            Integer this$dimension = this.getDimension();
            Integer other$dimension = other.getDimension();
            if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
                return false;
            }
            Boolean this$isPrimaryKey = this.getIsPrimaryKey();
            Boolean other$isPrimaryKey = other.getIsPrimaryKey();
            if (this$isPrimaryKey == null ? other$isPrimaryKey != null : !((Object)this$isPrimaryKey).equals(other$isPrimaryKey)) {
                return false;
            }
            Boolean this$isPartitionKey = this.getIsPartitionKey();
            Boolean other$isPartitionKey = other.getIsPartitionKey();
            if (this$isPartitionKey == null ? other$isPartitionKey != null : !((Object)this$isPartitionKey).equals(other$isPartitionKey)) {
                return false;
            }
            Boolean this$isClusteringKey = this.getIsClusteringKey();
            Boolean other$isClusteringKey = other.getIsClusteringKey();
            if (this$isClusteringKey == null ? other$isClusteringKey != null : !((Object)this$isClusteringKey).equals(other$isClusteringKey)) {
                return false;
            }
            Boolean this$autoID = this.getAutoID();
            Boolean other$autoID = other.getAutoID();
            if (this$autoID == null ? other$autoID != null : !((Object)this$autoID).equals(other$autoID)) {
                return false;
            }
            Integer this$maxCapacity = this.getMaxCapacity();
            Integer other$maxCapacity = other.getMaxCapacity();
            if (this$maxCapacity == null ? other$maxCapacity != null : !((Object)this$maxCapacity).equals(other$maxCapacity)) {
                return false;
            }
            Boolean this$isNullable = this.getIsNullable();
            Boolean other$isNullable = other.getIsNullable();
            if (this$isNullable == null ? other$isNullable != null : !((Object)this$isNullable).equals(other$isNullable)) {
                return false;
            }
            Boolean this$enableAnalyzer = this.getEnableAnalyzer();
            Boolean other$enableAnalyzer = other.getEnableAnalyzer();
            if (this$enableAnalyzer == null ? other$enableAnalyzer != null : !((Object)this$enableAnalyzer).equals(other$enableAnalyzer)) {
                return false;
            }
            Boolean this$enableMatch = this.getEnableMatch();
            Boolean other$enableMatch = other.getEnableMatch();
            if (this$enableMatch == null ? other$enableMatch != null : !((Object)this$enableMatch).equals(other$enableMatch)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            DataType this$dataType = this.getDataType();
            DataType other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
                return false;
            }
            DataType this$elementType = this.getElementType();
            DataType other$elementType = other.getElementType();
            if (this$elementType == null ? other$elementType != null : !((Object)((Object)this$elementType)).equals((Object)other$elementType)) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Map<String, Object> this$analyzerParams = this.getAnalyzerParams();
            Map<String, Object> other$analyzerParams = other.getAnalyzerParams();
            if (this$analyzerParams == null ? other$analyzerParams != null : !((Object)this$analyzerParams).equals(other$analyzerParams)) {
                return false;
            }
            Map<String, String> this$typeParams = this.getTypeParams();
            Map<String, String> other$typeParams = other.getTypeParams();
            if (this$typeParams == null ? other$typeParams != null : !((Object)this$typeParams).equals(other$typeParams)) {
                return false;
            }
            Map<String, Object> this$multiAnalyzerParams = this.getMultiAnalyzerParams();
            Map<String, Object> other$multiAnalyzerParams = other.getMultiAnalyzerParams();
            return !(this$multiAnalyzerParams == null ? other$multiAnalyzerParams != null : !((Object)this$multiAnalyzerParams).equals(other$multiAnalyzerParams));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldSchema;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxLength = this.getMaxLength();
            result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
            Integer $dimension = this.getDimension();
            result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
            Boolean $isPrimaryKey = this.getIsPrimaryKey();
            result = result * 59 + ($isPrimaryKey == null ? 43 : ((Object)$isPrimaryKey).hashCode());
            Boolean $isPartitionKey = this.getIsPartitionKey();
            result = result * 59 + ($isPartitionKey == null ? 43 : ((Object)$isPartitionKey).hashCode());
            Boolean $isClusteringKey = this.getIsClusteringKey();
            result = result * 59 + ($isClusteringKey == null ? 43 : ((Object)$isClusteringKey).hashCode());
            Boolean $autoID = this.getAutoID();
            result = result * 59 + ($autoID == null ? 43 : ((Object)$autoID).hashCode());
            Integer $maxCapacity = this.getMaxCapacity();
            result = result * 59 + ($maxCapacity == null ? 43 : ((Object)$maxCapacity).hashCode());
            Boolean $isNullable = this.getIsNullable();
            result = result * 59 + ($isNullable == null ? 43 : ((Object)$isNullable).hashCode());
            Boolean $enableAnalyzer = this.getEnableAnalyzer();
            result = result * 59 + ($enableAnalyzer == null ? 43 : ((Object)$enableAnalyzer).hashCode());
            Boolean $enableMatch = this.getEnableMatch();
            result = result * 59 + ($enableMatch == null ? 43 : ((Object)$enableMatch).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            DataType $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
            DataType $elementType = this.getElementType();
            result = result * 59 + ($elementType == null ? 43 : ((Object)((Object)$elementType)).hashCode());
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Map<String, Object> $analyzerParams = this.getAnalyzerParams();
            result = result * 59 + ($analyzerParams == null ? 43 : ((Object)$analyzerParams).hashCode());
            Map<String, String> $typeParams = this.getTypeParams();
            result = result * 59 + ($typeParams == null ? 43 : ((Object)$typeParams).hashCode());
            Map<String, Object> $multiAnalyzerParams = this.getMultiAnalyzerParams();
            result = result * 59 + ($multiAnalyzerParams == null ? 43 : ((Object)$multiAnalyzerParams).hashCode());
            return result;
        }

        public String toString() {
            return "CreateCollectionReq.FieldSchema(name=" + this.getName() + ", description=" + this.getDescription() + ", dataType=" + (Object)((Object)this.getDataType()) + ", maxLength=" + this.getMaxLength() + ", dimension=" + this.getDimension() + ", isPrimaryKey=" + this.getIsPrimaryKey() + ", isPartitionKey=" + this.getIsPartitionKey() + ", isClusteringKey=" + this.getIsClusteringKey() + ", autoID=" + this.getAutoID() + ", elementType=" + (Object)((Object)this.getElementType()) + ", maxCapacity=" + this.getMaxCapacity() + ", isNullable=" + this.getIsNullable() + ", defaultValue=" + this.getDefaultValue() + ", enableAnalyzer=" + this.getEnableAnalyzer() + ", analyzerParams=" + this.getAnalyzerParams() + ", enableMatch=" + this.getEnableMatch() + ", typeParams=" + this.getTypeParams() + ", multiAnalyzerParams=" + this.getMultiAnalyzerParams() + ")";
        }

        private static final class FieldSchemaBuilderImpl
        extends FieldSchemaBuilder<FieldSchema, FieldSchemaBuilderImpl> {
            private FieldSchemaBuilderImpl() {
            }

            @Override
            protected FieldSchemaBuilderImpl self() {
                return this;
            }

            @Override
            public FieldSchema build() {
                return new FieldSchema(this);
            }
        }

        public static abstract class FieldSchemaBuilder<C extends FieldSchema, B extends FieldSchemaBuilder<C, B>> {
            private String name;
            private boolean description$set;
            private String description$value;
            private DataType dataType;
            private boolean maxLength$set;
            private Integer maxLength$value;
            private Integer dimension;
            private boolean isPrimaryKey$set;
            private Boolean isPrimaryKey$value;
            private boolean isPartitionKey$set;
            private Boolean isPartitionKey$value;
            private boolean isClusteringKey$set;
            private Boolean isClusteringKey$value;
            private boolean autoID$set;
            private Boolean autoID$value;
            private DataType elementType;
            private Integer maxCapacity;
            private boolean isNullable$set;
            private Boolean isNullable$value;
            private boolean defaultValue$set;
            private Object defaultValue$value;
            private Boolean enableAnalyzer;
            private Map<String, Object> analyzerParams;
            private Boolean enableMatch;
            private Map<String, String> typeParams;
            private Map<String, Object> multiAnalyzerParams;

            protected abstract B self();

            public abstract C build();

            public B name(String name) {
                this.name = name;
                return this.self();
            }

            public B description(String description) {
                this.description$value = description;
                this.description$set = true;
                return this.self();
            }

            public B dataType(DataType dataType) {
                this.dataType = dataType;
                return this.self();
            }

            public B maxLength(Integer maxLength) {
                this.maxLength$value = maxLength;
                this.maxLength$set = true;
                return this.self();
            }

            public B dimension(Integer dimension) {
                this.dimension = dimension;
                return this.self();
            }

            public B isPrimaryKey(Boolean isPrimaryKey) {
                this.isPrimaryKey$value = isPrimaryKey;
                this.isPrimaryKey$set = true;
                return this.self();
            }

            public B isPartitionKey(Boolean isPartitionKey) {
                this.isPartitionKey$value = isPartitionKey;
                this.isPartitionKey$set = true;
                return this.self();
            }

            public B isClusteringKey(Boolean isClusteringKey) {
                this.isClusteringKey$value = isClusteringKey;
                this.isClusteringKey$set = true;
                return this.self();
            }

            public B autoID(Boolean autoID) {
                this.autoID$value = autoID;
                this.autoID$set = true;
                return this.self();
            }

            public B elementType(DataType elementType) {
                this.elementType = elementType;
                return this.self();
            }

            public B maxCapacity(Integer maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this.self();
            }

            public B isNullable(Boolean isNullable) {
                this.isNullable$value = isNullable;
                this.isNullable$set = true;
                return this.self();
            }

            public B defaultValue(Object defaultValue) {
                this.defaultValue$value = defaultValue;
                this.defaultValue$set = true;
                return this.self();
            }

            public B enableAnalyzer(Boolean enableAnalyzer) {
                this.enableAnalyzer = enableAnalyzer;
                return this.self();
            }

            public B analyzerParams(Map<String, Object> analyzerParams) {
                this.analyzerParams = analyzerParams;
                return this.self();
            }

            public B enableMatch(Boolean enableMatch) {
                this.enableMatch = enableMatch;
                return this.self();
            }

            public B typeParams(Map<String, String> typeParams) {
                this.typeParams = typeParams;
                return this.self();
            }

            public B multiAnalyzerParams(Map<String, Object> multiAnalyzerParams) {
                this.multiAnalyzerParams = multiAnalyzerParams;
                return this.self();
            }

            public String toString() {
                return "CreateCollectionReq.FieldSchema.FieldSchemaBuilder(name=" + this.name + ", description$value=" + this.description$value + ", dataType=" + (Object)((Object)this.dataType) + ", maxLength$value=" + this.maxLength$value + ", dimension=" + this.dimension + ", isPrimaryKey$value=" + this.isPrimaryKey$value + ", isPartitionKey$value=" + this.isPartitionKey$value + ", isClusteringKey$value=" + this.isClusteringKey$value + ", autoID$value=" + this.autoID$value + ", elementType=" + (Object)((Object)this.elementType) + ", maxCapacity=" + this.maxCapacity + ", isNullable$value=" + this.isNullable$value + ", defaultValue$value=" + this.defaultValue$value + ", enableAnalyzer=" + this.enableAnalyzer + ", analyzerParams=" + this.analyzerParams + ", enableMatch=" + this.enableMatch + ", typeParams=" + this.typeParams + ", multiAnalyzerParams=" + this.multiAnalyzerParams + ")";
            }
        }
    }

    public static class CollectionSchema {
        private List<FieldSchema> fieldSchemaList;
        private boolean enableDynamicField;
        private List<Function> functionList;

        public CollectionSchema addField(AddFieldReq addFieldReq) {
            this.fieldSchemaList.add(SchemaUtils.convertFieldReqToFieldSchema(addFieldReq));
            return this;
        }

        public CollectionSchema addFunction(Function function) {
            this.functionList.add(function);
            return this;
        }

        public FieldSchema getField(String fieldName) {
            for (FieldSchema field : this.fieldSchemaList) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            return null;
        }

        private static List<FieldSchema> $default$fieldSchemaList() {
            return new ArrayList<FieldSchema>();
        }

        private static boolean $default$enableDynamicField() {
            return false;
        }

        private static List<Function> $default$functionList() {
            return new ArrayList<Function>();
        }

        protected CollectionSchema(CollectionSchemaBuilder<?, ?> b) {
            this.fieldSchemaList = ((CollectionSchemaBuilder)b).fieldSchemaList$set ? ((CollectionSchemaBuilder)b).fieldSchemaList$value : CollectionSchema.$default$fieldSchemaList();
            this.enableDynamicField = ((CollectionSchemaBuilder)b).enableDynamicField$set ? ((CollectionSchemaBuilder)b).enableDynamicField$value : CollectionSchema.$default$enableDynamicField();
            this.functionList = ((CollectionSchemaBuilder)b).functionList$set ? ((CollectionSchemaBuilder)b).functionList$value : CollectionSchema.$default$functionList();
        }

        public static CollectionSchemaBuilder<?, ?> builder() {
            return new CollectionSchemaBuilderImpl();
        }

        public List<FieldSchema> getFieldSchemaList() {
            return this.fieldSchemaList;
        }

        public boolean isEnableDynamicField() {
            return this.enableDynamicField;
        }

        public List<Function> getFunctionList() {
            return this.functionList;
        }

        public void setFieldSchemaList(List<FieldSchema> fieldSchemaList) {
            this.fieldSchemaList = fieldSchemaList;
        }

        public void setEnableDynamicField(boolean enableDynamicField) {
            this.enableDynamicField = enableDynamicField;
        }

        public void setFunctionList(List<Function> functionList) {
            this.functionList = functionList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CollectionSchema)) {
                return false;
            }
            CollectionSchema other = (CollectionSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnableDynamicField() != other.isEnableDynamicField()) {
                return false;
            }
            List<FieldSchema> this$fieldSchemaList = this.getFieldSchemaList();
            List<FieldSchema> other$fieldSchemaList = other.getFieldSchemaList();
            if (this$fieldSchemaList == null ? other$fieldSchemaList != null : !((Object)this$fieldSchemaList).equals(other$fieldSchemaList)) {
                return false;
            }
            List<Function> this$functionList = this.getFunctionList();
            List<Function> other$functionList = other.getFunctionList();
            return !(this$functionList == null ? other$functionList != null : !((Object)this$functionList).equals(other$functionList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CollectionSchema;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableDynamicField() ? 79 : 97);
            List<FieldSchema> $fieldSchemaList = this.getFieldSchemaList();
            result = result * 59 + ($fieldSchemaList == null ? 43 : ((Object)$fieldSchemaList).hashCode());
            List<Function> $functionList = this.getFunctionList();
            result = result * 59 + ($functionList == null ? 43 : ((Object)$functionList).hashCode());
            return result;
        }

        public String toString() {
            return "CreateCollectionReq.CollectionSchema(fieldSchemaList=" + this.getFieldSchemaList() + ", enableDynamicField=" + this.isEnableDynamicField() + ", functionList=" + this.getFunctionList() + ")";
        }

        private static final class CollectionSchemaBuilderImpl
        extends CollectionSchemaBuilder<CollectionSchema, CollectionSchemaBuilderImpl> {
            private CollectionSchemaBuilderImpl() {
            }

            @Override
            protected CollectionSchemaBuilderImpl self() {
                return this;
            }

            @Override
            public CollectionSchema build() {
                return new CollectionSchema(this);
            }
        }

        public static abstract class CollectionSchemaBuilder<C extends CollectionSchema, B extends CollectionSchemaBuilder<C, B>> {
            private boolean fieldSchemaList$set;
            private List<FieldSchema> fieldSchemaList$value;
            private boolean enableDynamicField$set;
            private boolean enableDynamicField$value;
            private boolean functionList$set;
            private List<Function> functionList$value;

            protected abstract B self();

            public abstract C build();

            public B fieldSchemaList(List<FieldSchema> fieldSchemaList) {
                this.fieldSchemaList$value = fieldSchemaList;
                this.fieldSchemaList$set = true;
                return this.self();
            }

            public B enableDynamicField(boolean enableDynamicField) {
                this.enableDynamicField$value = enableDynamicField;
                this.enableDynamicField$set = true;
                return this.self();
            }

            public B functionList(List<Function> functionList) {
                this.functionList$value = functionList;
                this.functionList$set = true;
                return this.self();
            }

            public String toString() {
                return "CreateCollectionReq.CollectionSchema.CollectionSchemaBuilder(fieldSchemaList$value=" + this.fieldSchemaList$value + ", enableDynamicField$value=" + this.enableDynamicField$value + ", functionList$value=" + this.functionList$value + ")";
            }
        }
    }

    public static abstract class CreateCollectionReqBuilder<C extends CreateCollectionReq, B extends CreateCollectionReqBuilder<C, B>> {
        private String databaseName;
        private String collectionName;
        private boolean description$set;
        private String description$value;
        private Integer dimension;
        private boolean primaryFieldName$set;
        private String primaryFieldName$value;
        private boolean idType$set;
        private DataType idType$value;
        private boolean maxLength$set;
        private Integer maxLength$value;
        private boolean vectorFieldName$set;
        private String vectorFieldName$value;
        private boolean metricType$set;
        private String metricType$value;
        private boolean autoID$set;
        private Boolean autoID$value;
        private boolean enableDynamicField$set;
        private Boolean enableDynamicField$value;
        private boolean numShards$set;
        private Integer numShards$value;
        private CollectionSchema collectionSchema;
        private boolean indexParams$set;
        private List<IndexParam> indexParams$value;
        private Integer numPartitions;
        private boolean consistencyLevel$set;
        private ConsistencyLevel consistencyLevel$value;
        private boolean properties$set;
        private Map<String, String> properties$value;

        public B indexParam(IndexParam indexParam) {
            try {
                this.indexParams$value.add(indexParam);
            }
            catch (UnsupportedOperationException _e) {
                this.indexParams$value = new ArrayList<IndexParam>(this.indexParams$value);
                this.indexParams$value.add(indexParam);
            }
            this.indexParams$set = true;
            return this.self();
        }

        public B enableDynamicField(Boolean enableDynamicField) {
            if (this.collectionSchema != null && this.collectionSchema.isEnableDynamicField() != enableDynamicField.booleanValue()) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "The enableDynamicField flag has been set by CollectionSchema, not allow to set different value by enableDynamicField().");
            }
            this.enableDynamicField$value = enableDynamicField;
            this.enableDynamicField$set = true;
            return this.self();
        }

        public B collectionSchema(CollectionSchema collectionSchema) {
            if (this.enableDynamicField$set && collectionSchema.isEnableDynamicField() != this.enableDynamicField$value.booleanValue()) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "The enableDynamicField flag has been set by enableDynamicField(), not allow to set different value by collectionSchema.");
            }
            this.collectionSchema = collectionSchema;
            this.enableDynamicField$value = collectionSchema.isEnableDynamicField();
            this.enableDynamicField$set = true;
            return this.self();
        }

        public B property(String key, String value) {
            if (null == this.properties$value) {
                this.properties$value = new HashMap<String, String>();
            }
            this.properties$value.put(key, value);
            this.properties$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this.self();
        }

        public B collectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this.self();
        }

        public B description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this.self();
        }

        public B dimension(Integer dimension) {
            this.dimension = dimension;
            return this.self();
        }

        public B primaryFieldName(String primaryFieldName) {
            this.primaryFieldName$value = primaryFieldName;
            this.primaryFieldName$set = true;
            return this.self();
        }

        public B idType(DataType idType) {
            this.idType$value = idType;
            this.idType$set = true;
            return this.self();
        }

        public B maxLength(Integer maxLength) {
            this.maxLength$value = maxLength;
            this.maxLength$set = true;
            return this.self();
        }

        public B vectorFieldName(String vectorFieldName) {
            this.vectorFieldName$value = vectorFieldName;
            this.vectorFieldName$set = true;
            return this.self();
        }

        public B metricType(String metricType) {
            this.metricType$value = metricType;
            this.metricType$set = true;
            return this.self();
        }

        public B autoID(Boolean autoID) {
            this.autoID$value = autoID;
            this.autoID$set = true;
            return this.self();
        }

        public B numShards(Integer numShards) {
            this.numShards$value = numShards;
            this.numShards$set = true;
            return this.self();
        }

        public B indexParams(List<IndexParam> indexParams) {
            this.indexParams$value = indexParams;
            this.indexParams$set = true;
            return this.self();
        }

        public B numPartitions(Integer numPartitions) {
            this.numPartitions = numPartitions;
            return this.self();
        }

        public B consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel$value = consistencyLevel;
            this.consistencyLevel$set = true;
            return this.self();
        }

        public B properties(Map<String, String> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this.self();
        }

        public String toString() {
            return "CreateCollectionReq.CreateCollectionReqBuilder(databaseName=" + this.databaseName + ", collectionName=" + this.collectionName + ", description$value=" + this.description$value + ", dimension=" + this.dimension + ", primaryFieldName$value=" + this.primaryFieldName$value + ", idType$value=" + (Object)((Object)this.idType$value) + ", maxLength$value=" + this.maxLength$value + ", vectorFieldName$value=" + this.vectorFieldName$value + ", metricType$value=" + this.metricType$value + ", autoID$value=" + this.autoID$value + ", enableDynamicField$value=" + this.enableDynamicField$value + ", numShards$value=" + this.numShards$value + ", collectionSchema=" + this.collectionSchema + ", indexParams$value=" + this.indexParams$value + ", numPartitions=" + this.numPartitions + ", consistencyLevel$value=" + (Object)((Object)this.consistencyLevel$value) + ", properties$value=" + this.properties$value + ")";
        }
    }
}

