/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.TypeRef;
import io.modelcontextprotocol.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpSchema {
    private static final Logger logger = LoggerFactory.getLogger(McpSchema.class);
    @Deprecated
    public static final String LATEST_PROTOCOL_VERSION = "2025-06-18";
    public static final String JSONRPC_VERSION = "2.0";
    public static final String FIRST_PAGE = null;
    public static final String METHOD_INITIALIZE = "initialize";
    public static final String METHOD_NOTIFICATION_INITIALIZED = "notifications/initialized";
    public static final String METHOD_PING = "ping";
    public static final String METHOD_NOTIFICATION_PROGRESS = "notifications/progress";
    public static final String METHOD_TOOLS_LIST = "tools/list";
    public static final String METHOD_TOOLS_CALL = "tools/call";
    public static final String METHOD_NOTIFICATION_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String METHOD_RESOURCES_LIST = "resources/list";
    public static final String METHOD_RESOURCES_READ = "resources/read";
    public static final String METHOD_NOTIFICATION_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String METHOD_NOTIFICATION_RESOURCES_UPDATED = "notifications/resources/updated";
    public static final String METHOD_RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String METHOD_RESOURCES_SUBSCRIBE = "resources/subscribe";
    public static final String METHOD_RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    public static final String METHOD_PROMPT_LIST = "prompts/list";
    public static final String METHOD_PROMPT_GET = "prompts/get";
    public static final String METHOD_NOTIFICATION_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String METHOD_COMPLETION_COMPLETE = "completion/complete";
    public static final String METHOD_LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String METHOD_NOTIFICATION_MESSAGE = "notifications/message";
    public static final String METHOD_ROOTS_LIST = "roots/list";
    public static final String METHOD_NOTIFICATION_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String METHOD_SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    public static final String METHOD_ELICITATION_CREATE = "elicitation/create";
    private static final TypeRef<HashMap<String, Object>> MAP_TYPE_REF = new TypeRef<HashMap<String, Object>>(){};

    private McpSchema() {
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(McpJsonMapper jsonMapper, String jsonText) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonText);
        HashMap<String, Object> map = jsonMapper.readValue(jsonText, MAP_TYPE_REF);
        if (map.containsKey("method") && map.containsKey("id")) {
            return jsonMapper.convertValue(map, JSONRPCRequest.class);
        }
        if (map.containsKey("method") && !map.containsKey("id")) {
            return jsonMapper.convertValue(map, JSONRPCNotification.class);
        }
        if (map.containsKey("result") || map.containsKey("error")) {
            return jsonMapper.convertValue(map, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonText);
    }

    private static Map<String, Object> schemaToMap(McpJsonMapper jsonMapper, String schema) {
        try {
            return jsonMapper.readValue(schema, MAP_TYPE_REF);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    private static JsonSchema parseSchema(McpJsonMapper jsonMapper, String schema) {
        try {
            return jsonMapper.readValue(schema, JsonSchema.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JSONRPCRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="id") Object id, @JsonProperty(value="params") Object params) implements JSONRPCMessage
    {
        public JSONRPCRequest {
            Assert.notNull(id, "MCP requests MUST include an ID - null IDs are not allowed");
            Assert.isTrue(id instanceof String || id instanceof Integer || id instanceof Long, "MCP requests MUST have an ID that is either a string or integer");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSONRPCMessage {
        public String jsonrpc();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JSONRPCNotification(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="params") Object params) implements JSONRPCMessage
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JSONRPCResponse(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") Object id, @JsonProperty(value="result") Object result, @JsonProperty(value="error") JSONRPCError error) implements JSONRPCMessage
    {

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record JSONRPCError(@JsonProperty(value="code") int code, @JsonProperty(value="message") String message, @JsonProperty(value="data") Object data) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JsonSchema(@JsonProperty(value="type") String type, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="required") List<String> required, @JsonProperty(value="additionalProperties") Boolean additionalProperties, @JsonProperty(value="$defs") Map<String, Object> defs, @JsonProperty(value="definitions") Map<String, Object> definitions) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListRootsResult(@JsonProperty(value="roots") List<Root> roots, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ListRootsResult(List<Root> roots) {
            this(roots, null);
        }

        public ListRootsResult(List<Root> roots, String nextCursor) {
            this(roots, nextCursor, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Root(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name, @JsonProperty(value="_meta") Map<String, Object> meta) {
        public Root(String uri, String name) {
            this(uri, name, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ResourceLink(@JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="uri") String uri, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="_meta") Map<String, Object> meta) implements Content,
    ResourceContent
    {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String name;
            private String title;
            private String uri;
            private String description;
            private String mimeType;
            private Annotations annotations;
            private Long size;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder annotations(Annotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder size(Long size) {
                this.size = size;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public ResourceLink build() {
                Assert.hasText(this.uri, "uri must not be empty");
                Assert.hasText(this.name, "name must not be empty");
                return new ResourceLink(this.name, this.title, this.uri, this.description, this.mimeType, this.size, this.annotations, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record EmbeddedResource(@JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="resource") ResourceContents resource, @JsonProperty(value="_meta") Map<String, Object> meta) implements Annotated,
    Content
    {
        public EmbeddedResource(Annotations annotations, ResourceContents resource) {
            this(annotations, resource, null);
        }

        @Deprecated
        public EmbeddedResource(List<Role> audience, Double priority, ResourceContents resource) {
            this(audience != null || priority != null ? new Annotations(audience, priority) : null, resource, null);
        }

        @Deprecated
        public List<Role> audience() {
            return this.annotations == null ? null : this.annotations.audience();
        }

        @Deprecated
        public Double priority() {
            return this.annotations == null ? null : this.annotations.priority();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record AudioContent(@JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="data") String data, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="_meta") Map<String, Object> meta) implements Annotated,
    Content
    {
        public AudioContent(Annotations annotations, String data, String mimeType) {
            this(annotations, data, mimeType, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ImageContent(@JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="data") String data, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="_meta") Map<String, Object> meta) implements Annotated,
    Content
    {
        public ImageContent(Annotations annotations, String data, String mimeType) {
            this(annotations, data, mimeType, null);
        }

        @Deprecated
        public ImageContent(List<Role> audience, Double priority, String data, String mimeType) {
            this(audience != null || priority != null ? new Annotations(audience, priority) : null, data, mimeType, null);
        }

        @Deprecated
        public List<Role> audience() {
            return this.annotations == null ? null : this.annotations.audience();
        }

        @Deprecated
        public Double priority() {
            return this.annotations == null ? null : this.annotations.priority();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record TextContent(@JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="text") String text, @JsonProperty(value="_meta") Map<String, Object> meta) implements Annotated,
    Content
    {
        public TextContent(Annotations annotations, String text) {
            this(annotations, text, null);
        }

        public TextContent(String content) {
            this(null, content, null);
        }

        @Deprecated
        public TextContent(List<Role> audience, Double priority, String content) {
            this(audience != null || priority != null ? new Annotations(audience, priority) : null, content, null);
        }

        @Deprecated
        public List<Role> audience() {
            return this.annotations == null ? null : this.annotations.audience();
        }

        @Deprecated
        public Double priority() {
            return this.annotations == null ? null : this.annotations.priority();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextContent.class, name="text"), @JsonSubTypes.Type(value=ImageContent.class, name="image"), @JsonSubTypes.Type(value=AudioContent.class, name="audio"), @JsonSubTypes.Type(value=EmbeddedResource.class, name="resource"), @JsonSubTypes.Type(value=ResourceLink.class, name="resource_link")})
    public static interface Content
    extends Meta {
        default public String type() {
            if (this instanceof TextContent) {
                return "text";
            }
            if (this instanceof ImageContent) {
                return "image";
            }
            if (this instanceof AudioContent) {
                return "audio";
            }
            if (this instanceof EmbeddedResource) {
                return "resource";
            }
            if (this instanceof ResourceLink) {
                return "resource_link";
            }
            throw new IllegalArgumentException("Unknown content type: " + String.valueOf(this));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CompleteResult(@JsonProperty(value="completion") CompleteCompletion completion, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public CompleteResult(CompleteCompletion completion) {
            this(completion, null);
        }

        public record CompleteCompletion(@JsonProperty(value="values") List<String> values, @JsonProperty(value="total") Integer total, @JsonProperty(value="hasMore") Boolean hasMore) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CompleteRequest(@JsonProperty(value="ref") CompleteReference ref, @JsonProperty(value="argument") CompleteArgument argument, @JsonProperty(value="_meta") Map<String, Object> meta, @JsonProperty(value="context") CompleteContext context) implements Request
    {
        public CompleteRequest(CompleteReference ref, CompleteArgument argument, Map<String, Object> meta) {
            this(ref, argument, meta, null);
        }

        public CompleteRequest(CompleteReference ref, CompleteArgument argument, CompleteContext context) {
            this(ref, argument, null, context);
        }

        public CompleteRequest(CompleteReference ref, CompleteArgument argument) {
            this(ref, argument, null, null);
        }

        public record CompleteArgument(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
        }

        public record CompleteContext(@JsonProperty(value="arguments") Map<String, String> arguments) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ResourceReference(@JsonProperty(value="type") String type, @JsonProperty(value="uri") String uri) implements CompleteReference
    {
        public static final String TYPE = "ref/resource";

        public ResourceReference(String uri) {
            this(TYPE, uri);
        }

        @Override
        public String identifier() {
            return this.uri();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PromptReference(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="title") String title) implements CompleteReference,
    Identifier
    {
        public static final String TYPE = "ref/prompt";

        public PromptReference(String type, String name) {
            this(type, name, null);
        }

        public PromptReference(String name) {
            this(TYPE, name, null);
        }

        @Override
        public String identifier() {
            return this.name();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PromptReference that = (PromptReference)obj;
            return Objects.equals(this.identifier(), that.identifier()) && Objects.equals(this.type(), that.type());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.identifier(), this.type());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CompleteReference {
        public String type();

        public String identifier();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record SetLevelRequest(@JsonProperty(value="level") LoggingLevel level) {
    }

    public static enum LoggingLevel {
        DEBUG(0),
        INFO(1),
        NOTICE(2),
        WARNING(3),
        ERROR(4),
        CRITICAL(5),
        ALERT(6),
        EMERGENCY(7);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record LoggingMessageNotification(@JsonProperty(value="level") LoggingLevel level, @JsonProperty(value="logger") String logger, @JsonProperty(value="data") String data, @JsonProperty(value="_meta") Map<String, Object> meta) implements Notification
    {
        public LoggingMessageNotification(LoggingLevel level, String logger, String data) {
            this(level, logger, data, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private LoggingLevel level = LoggingLevel.INFO;
            private String logger = "server";
            private String data;
            private Map<String, Object> meta;

            public Builder level(LoggingLevel level) {
                this.level = level;
                return this;
            }

            public Builder logger(String logger) {
                this.logger = logger;
                return this;
            }

            public Builder data(String data) {
                this.data = data;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public LoggingMessageNotification build() {
                return new LoggingMessageNotification(this.level, this.logger, this.data, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ResourcesUpdatedNotification(@JsonProperty(value="uri") String uri, @JsonProperty(value="_meta") Map<String, Object> meta) implements Notification
    {
        public ResourcesUpdatedNotification(String uri) {
            this(uri, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ProgressNotification(@JsonProperty(value="progressToken") String progressToken, @JsonProperty(value="progress") Double progress, @JsonProperty(value="total") Double total, @JsonProperty(value="message") String message, @JsonProperty(value="_meta") Map<String, Object> meta) implements Notification
    {
        public ProgressNotification(String progressToken, double progress, Double total, String message) {
            this(progressToken, progress, total, message, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PaginatedResult(@JsonProperty(value="nextCursor") String nextCursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PaginatedRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public PaginatedRequest(String cursor) {
            this(cursor, null);
        }

        public PaginatedRequest() {
            this(null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ElicitResult(@JsonProperty(value="action") Action action, @JsonProperty(value="content") Map<String, Object> content, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ElicitResult(Action action, Map<String, Object> content) {
            this(action, content, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum Action {
            ACCEPT,
            DECLINE,
            CANCEL;

        }

        public static class Builder {
            private Action action;
            private Map<String, Object> content;
            private Map<String, Object> meta;

            public Builder message(Action action) {
                this.action = action;
                return this;
            }

            public Builder content(Map<String, Object> content) {
                this.content = content;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public ElicitResult build() {
                return new ElicitResult(this.action, this.content, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ElicitRequest(@JsonProperty(value="message") String message, @JsonProperty(value="requestedSchema") Map<String, Object> requestedSchema, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public ElicitRequest(String message, Map<String, Object> requestedSchema) {
            this(message, requestedSchema, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String message;
            private Map<String, Object> requestedSchema;
            private Map<String, Object> meta;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder requestedSchema(Map<String, Object> requestedSchema) {
                this.requestedSchema = requestedSchema;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public ElicitRequest build() {
                return new ElicitRequest(this.message, this.requestedSchema, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CreateMessageResult(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content, @JsonProperty(value="model") String model, @JsonProperty(value="stopReason") StopReason stopReason, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public CreateMessageResult(Role role, Content content, String model, StopReason stopReason) {
            this(role, content, model, stopReason, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum StopReason {
            END_TURN("endTurn"),
            STOP_SEQUENCE("stopSequence"),
            MAX_TOKENS("maxTokens"),
            UNKNOWN("unknown");

            private final String value;

            private StopReason(String value) {
                this.value = value;
            }

            @JsonCreator
            private static StopReason of(String value) {
                return Arrays.stream(StopReason.values()).filter(stopReason -> stopReason.value.equals(value)).findFirst().orElse(UNKNOWN);
            }
        }

        public static class Builder {
            private Role role = Role.ASSISTANT;
            private Content content;
            private String model;
            private StopReason stopReason = StopReason.END_TURN;
            private Map<String, Object> meta;

            public Builder role(Role role) {
                this.role = role;
                return this;
            }

            public Builder content(Content content) {
                this.content = content;
                return this;
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder stopReason(StopReason stopReason) {
                this.stopReason = stopReason;
                return this;
            }

            public Builder message(String message) {
                this.content = new TextContent(message);
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public CreateMessageResult build() {
                return new CreateMessageResult(this.role, this.content, this.model, this.stopReason, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CreateMessageRequest(@JsonProperty(value="messages") List<SamplingMessage> messages, @JsonProperty(value="modelPreferences") ModelPreferences modelPreferences, @JsonProperty(value="systemPrompt") String systemPrompt, @JsonProperty(value="includeContext") ContextInclusionStrategy includeContext, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="maxTokens") int maxTokens, @JsonProperty(value="stopSequences") List<String> stopSequences, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public CreateMessageRequest(List<SamplingMessage> messages, ModelPreferences modelPreferences, String systemPrompt, ContextInclusionStrategy includeContext, Double temperature, int maxTokens, List<String> stopSequences, Map<String, Object> metadata) {
            this(messages, modelPreferences, systemPrompt, includeContext, temperature, maxTokens, stopSequences, metadata, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum ContextInclusionStrategy {
            NONE,
            THIS_SERVER,
            ALL_SERVERS;

        }

        public static class Builder {
            private List<SamplingMessage> messages;
            private ModelPreferences modelPreferences;
            private String systemPrompt;
            private ContextInclusionStrategy includeContext;
            private Double temperature;
            private int maxTokens;
            private List<String> stopSequences;
            private Map<String, Object> metadata;
            private Map<String, Object> meta;

            public Builder messages(List<SamplingMessage> messages) {
                this.messages = messages;
                return this;
            }

            public Builder modelPreferences(ModelPreferences modelPreferences) {
                this.modelPreferences = modelPreferences;
                return this;
            }

            public Builder systemPrompt(String systemPrompt) {
                this.systemPrompt = systemPrompt;
                return this;
            }

            public Builder includeContext(ContextInclusionStrategy includeContext) {
                this.includeContext = includeContext;
                return this;
            }

            public Builder temperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder maxTokens(int maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder stopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder metadata(Map<String, Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public CreateMessageRequest build() {
                return new CreateMessageRequest(this.messages, this.modelPreferences, this.systemPrompt, this.includeContext, this.temperature, this.maxTokens, this.stopSequences, this.metadata, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record SamplingMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ModelHint(@JsonProperty(value="name") String name) {
        public static ModelHint of(String name) {
            return new ModelHint(name);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ModelPreferences(@JsonProperty(value="hints") List<ModelHint> hints, @JsonProperty(value="costPriority") Double costPriority, @JsonProperty(value="speedPriority") Double speedPriority, @JsonProperty(value="intelligencePriority") Double intelligencePriority) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<ModelHint> hints;
            private Double costPriority;
            private Double speedPriority;
            private Double intelligencePriority;

            public Builder hints(List<ModelHint> hints) {
                this.hints = hints;
                return this;
            }

            public Builder addHint(String name) {
                if (this.hints == null) {
                    this.hints = new ArrayList<ModelHint>();
                }
                this.hints.add(new ModelHint(name));
                return this;
            }

            public Builder costPriority(Double costPriority) {
                this.costPriority = costPriority;
                return this;
            }

            public Builder speedPriority(Double speedPriority) {
                this.speedPriority = speedPriority;
                return this;
            }

            public Builder intelligencePriority(Double intelligencePriority) {
                this.intelligencePriority = intelligencePriority;
                return this;
            }

            public ModelPreferences build() {
                return new ModelPreferences(this.hints, this.costPriority, this.speedPriority, this.intelligencePriority);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CallToolResult(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="isError") Boolean isError, @JsonProperty(value="structuredContent") Object structuredContent, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        @Deprecated
        public CallToolResult(List<Content> content, Boolean isError) {
            this(content, isError, null, null);
        }

        @Deprecated
        public CallToolResult(List<Content> content, Boolean isError, Map<String, Object> structuredContent) {
            this(content, isError, structuredContent, null);
        }

        public CallToolResult(String content, Boolean isError) {
            this(List.of(new TextContent(content)), isError, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<Content> content = new ArrayList<Content>();
            private Boolean isError = false;
            private Object structuredContent;
            private Map<String, Object> meta;

            public Builder content(List<Content> content) {
                Assert.notNull(content, "content must not be null");
                this.content = content;
                return this;
            }

            public Builder structuredContent(Object structuredContent) {
                Assert.notNull(structuredContent, "structuredContent must not be null");
                this.structuredContent = structuredContent;
                return this;
            }

            public Builder structuredContent(McpJsonMapper jsonMapper, String structuredContent) {
                Assert.hasText(structuredContent, "structuredContent must not be empty");
                try {
                    this.structuredContent = jsonMapper.readValue(structuredContent, MAP_TYPE_REF);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid structured content: " + structuredContent, e);
                }
                return this;
            }

            public Builder textContent(List<String> textContent) {
                Assert.notNull(textContent, "textContent must not be null");
                textContent.stream().map(TextContent::new).forEach(this.content::add);
                return this;
            }

            public Builder addContent(Content contentItem) {
                Assert.notNull(contentItem, "contentItem must not be null");
                if (this.content == null) {
                    this.content = new ArrayList<Content>();
                }
                this.content.add(contentItem);
                return this;
            }

            public Builder addTextContent(String text) {
                Assert.notNull(text, "text must not be null");
                return this.addContent(new TextContent(text));
            }

            public Builder isError(Boolean isError) {
                Assert.notNull(isError, "isError must not be null");
                this.isError = isError;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public CallToolResult build() {
                return new CallToolResult(this.content, this.isError, this.structuredContent, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CallToolRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public CallToolRequest(McpJsonMapper jsonMapper, String name, String jsonArguments) {
            this(name, CallToolRequest.parseJsonArguments(jsonMapper, jsonArguments), null);
        }

        public CallToolRequest(String name, Map<String, Object> arguments) {
            this(name, arguments, null);
        }

        private static Map<String, Object> parseJsonArguments(McpJsonMapper jsonMapper, String jsonArguments) {
            try {
                return jsonMapper.readValue(jsonArguments, MAP_TYPE_REF);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid arguments: " + jsonArguments, e);
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String name;
            private Map<String, Object> arguments;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder arguments(Map<String, Object> arguments) {
                this.arguments = arguments;
                return this;
            }

            public Builder arguments(McpJsonMapper jsonMapper, String jsonArguments) {
                this.arguments = CallToolRequest.parseJsonArguments(jsonMapper, jsonArguments);
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public CallToolRequest build() {
                Assert.hasText(this.name, "name must not be empty");
                return new CallToolRequest(this.name, this.arguments, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Tool(@JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="inputSchema") JsonSchema inputSchema, @JsonProperty(value="outputSchema") Map<String, Object> outputSchema, @JsonProperty(value="annotations") ToolAnnotations annotations, @JsonProperty(value="_meta") Map<String, Object> meta) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String name;
            private String title;
            private String description;
            private JsonSchema inputSchema;
            private Map<String, Object> outputSchema;
            private ToolAnnotations annotations;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder inputSchema(JsonSchema inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            public Builder inputSchema(McpJsonMapper jsonMapper, String inputSchema) {
                this.inputSchema = McpSchema.parseSchema(jsonMapper, inputSchema);
                return this;
            }

            public Builder outputSchema(Map<String, Object> outputSchema) {
                this.outputSchema = outputSchema;
                return this;
            }

            public Builder outputSchema(McpJsonMapper jsonMapper, String outputSchema) {
                this.outputSchema = McpSchema.schemaToMap(jsonMapper, outputSchema);
                return this;
            }

            public Builder annotations(ToolAnnotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Tool build() {
                Assert.hasText(this.name, "name must not be empty");
                return new Tool(this.name, this.title, this.description, this.inputSchema, this.outputSchema, this.annotations, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ToolAnnotations(@JsonProperty(value="title") String title, @JsonProperty(value="readOnlyHint") Boolean readOnlyHint, @JsonProperty(value="destructiveHint") Boolean destructiveHint, @JsonProperty(value="idempotentHint") Boolean idempotentHint, @JsonProperty(value="openWorldHint") Boolean openWorldHint, @JsonProperty(value="returnDirect") Boolean returnDirect) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListToolsResult(@JsonProperty(value="tools") List<Tool> tools, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ListToolsResult(List<Tool> tools, String nextCursor) {
            this(tools, nextCursor, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record GetPromptResult(@JsonProperty(value="description") String description, @JsonProperty(value="messages") List<PromptMessage> messages, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public GetPromptResult(String description, List<PromptMessage> messages) {
            this(description, messages, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record GetPromptRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public GetPromptRequest(String name, Map<String, Object> arguments) {
            this(name, arguments, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListPromptsResult(@JsonProperty(value="prompts") List<Prompt> prompts, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ListPromptsResult(List<Prompt> prompts, String nextCursor) {
            this(prompts, nextCursor, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PromptMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PromptArgument(@JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="required") Boolean required) implements Identifier
    {
        public PromptArgument(String name, String description, Boolean required) {
            this(name, null, description, required);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Prompt(@JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="arguments") List<PromptArgument> arguments, @JsonProperty(value="_meta") Map<String, Object> meta) implements Identifier
    {
        public Prompt(String name, String description, List<PromptArgument> arguments) {
            this(name, null, description, arguments != null ? arguments : new ArrayList());
        }

        public Prompt(String name, String title, String description, List<PromptArgument> arguments) {
            this(name, title, description, arguments != null ? arguments : new ArrayList<PromptArgument>(), null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record BlobResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="blob") String blob, @JsonProperty(value="_meta") Map<String, Object> meta) implements ResourceContents
    {
        public BlobResourceContents(String uri, String mimeType, String blob) {
            this(uri, mimeType, blob, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record TextResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="text") String text, @JsonProperty(value="_meta") Map<String, Object> meta) implements ResourceContents
    {
        public TextResourceContents(String uri, String mimeType, String text) {
            this(uri, mimeType, text, null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextResourceContents.class, name="text"), @JsonSubTypes.Type(value=BlobResourceContents.class, name="blob")})
    public static interface ResourceContents
    extends Meta {
        public String uri();

        public String mimeType();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record UnsubscribeRequest(@JsonProperty(value="uri") String uri, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public UnsubscribeRequest(String uri) {
            this(uri, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record SubscribeRequest(@JsonProperty(value="uri") String uri, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public SubscribeRequest(String uri) {
            this(uri, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ReadResourceResult(@JsonProperty(value="contents") List<ResourceContents> contents, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ReadResourceResult(List<ResourceContents> contents) {
            this(contents, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ReadResourceRequest(@JsonProperty(value="uri") String uri, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public ReadResourceRequest(String uri) {
            this(uri, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListResourceTemplatesResult(@JsonProperty(value="resourceTemplates") List<ResourceTemplate> resourceTemplates, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ListResourceTemplatesResult(List<ResourceTemplate> resourceTemplates, String nextCursor) {
            this(resourceTemplates, nextCursor, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListResourcesResult(@JsonProperty(value="resources") List<Resource> resources, @JsonProperty(value="nextCursor") String nextCursor, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public ListResourcesResult(List<Resource> resources, String nextCursor) {
            this(resources, nextCursor, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ResourceTemplate(@JsonProperty(value="uriTemplate") String uriTemplate, @JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="_meta") Map<String, Object> meta) implements Annotated,
    Identifier,
    Meta
    {
        public ResourceTemplate(String uriTemplate, String name, String title, String description, String mimeType, Annotations annotations) {
            this(uriTemplate, name, title, description, mimeType, annotations, null);
        }

        public ResourceTemplate(String uriTemplate, String name, String description, String mimeType, Annotations annotations) {
            this(uriTemplate, name, null, description, mimeType, annotations);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String uriTemplate;
            private String name;
            private String title;
            private String description;
            private String mimeType;
            private Annotations annotations;
            private Map<String, Object> meta;

            public Builder uriTemplate(String uri) {
                this.uriTemplate = uri;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder annotations(Annotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public ResourceTemplate build() {
                Assert.hasText(this.uriTemplate, "uri must not be empty");
                Assert.hasText(this.name, "name must not be empty");
                return new ResourceTemplate(this.uriTemplate, this.name, this.title, this.description, this.mimeType, this.annotations, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Resource(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="annotations") Annotations annotations, @JsonProperty(value="_meta") Map<String, Object> meta) implements ResourceContent
    {
        @Deprecated
        public Resource(String uri, String name, String title, String description, String mimeType, Long size, Annotations annotations) {
            this(uri, name, title, description, mimeType, size, annotations, null);
        }

        @Deprecated
        public Resource(String uri, String name, String description, String mimeType, Long size, Annotations annotations) {
            this(uri, name, null, description, mimeType, size, annotations, null);
        }

        @Deprecated
        public Resource(String uri, String name, String description, String mimeType, Annotations annotations) {
            this(uri, name, null, description, mimeType, null, annotations, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String uri;
            private String name;
            private String title;
            private String description;
            private String mimeType;
            private Long size;
            private Annotations annotations;
            private Map<String, Object> meta;

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder size(Long size) {
                this.size = size;
                return this;
            }

            public Builder annotations(Annotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Resource build() {
                Assert.hasText(this.uri, "uri must not be empty");
                Assert.hasText(this.name, "name must not be empty");
                return new Resource(this.uri, this.name, this.title, this.description, this.mimeType, this.size, this.annotations, this.meta);
            }
        }
    }

    public static interface Identifier {
        public String name();

        public String title();
    }

    public static interface ResourceContent
    extends Identifier,
    Annotated,
    Meta {
        public String uri();

        public String description();

        public String mimeType();

        public Long size();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Annotations(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="lastModified") String lastModified) {
        public Annotations(List<Role> audience, Double priority) {
            this(audience, priority, null);
        }
    }

    public static interface Annotated {
        public Annotations annotations();
    }

    public static enum Role {
        USER,
        ASSISTANT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Implementation(@JsonProperty(value="name") String name, @JsonProperty(value="title") String title, @JsonProperty(value="version") String version) implements Identifier
    {
        public Implementation(String name, String version) {
            this(name, null, version);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ServerCapabilities(@JsonProperty(value="completions") CompletionCapabilities completions, @JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="logging") LoggingCapabilities logging, @JsonProperty(value="prompts") PromptCapabilities prompts, @JsonProperty(value="resources") ResourceCapabilities resources, @JsonProperty(value="tools") ToolCapabilities tools) {
        public Builder mutate() {
            Builder builder = new Builder();
            builder.completions = this.completions;
            builder.experimental = this.experimental;
            builder.logging = this.logging;
            builder.prompts = this.prompts;
            builder.resources = this.resources;
            builder.tools = this.tools;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record CompletionCapabilities() {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record LoggingCapabilities() {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record PromptCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record ResourceCapabilities(@JsonProperty(value="subscribe") Boolean subscribe, @JsonProperty(value="listChanged") Boolean listChanged) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record ToolCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
        }

        public static class Builder {
            private CompletionCapabilities completions;
            private Map<String, Object> experimental;
            private LoggingCapabilities logging;
            private PromptCapabilities prompts;
            private ResourceCapabilities resources;
            private ToolCapabilities tools;

            public Builder completions() {
                this.completions = new CompletionCapabilities();
                return this;
            }

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder logging() {
                this.logging = new LoggingCapabilities();
                return this;
            }

            public Builder prompts(Boolean listChanged) {
                this.prompts = new PromptCapabilities(listChanged);
                return this;
            }

            public Builder resources(Boolean subscribe, Boolean listChanged) {
                this.resources = new ResourceCapabilities(subscribe, listChanged);
                return this;
            }

            public Builder tools(Boolean listChanged) {
                this.tools = new ToolCapabilities(listChanged);
                return this;
            }

            public ServerCapabilities build() {
                return new ServerCapabilities(this.completions, this.experimental, this.logging, this.prompts, this.resources, this.tools);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ClientCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="roots") RootCapabilities roots, @JsonProperty(value="sampling") Sampling sampling, @JsonProperty(value="elicitation") Elicitation elicitation) {
        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record RootCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record Sampling() {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record Elicitation() {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private RootCapabilities roots;
            private Sampling sampling;
            private Elicitation elicitation;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder roots(Boolean listChanged) {
                this.roots = new RootCapabilities(listChanged);
                return this;
            }

            public Builder sampling() {
                this.sampling = new Sampling();
                return this;
            }

            public Builder elicitation() {
                this.elicitation = new Elicitation();
                return this;
            }

            public ClientCapabilities build() {
                return new ClientCapabilities(this.experimental, this.roots, this.sampling, this.elicitation);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record InitializeResult(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ServerCapabilities capabilities, @JsonProperty(value="serverInfo") Implementation serverInfo, @JsonProperty(value="instructions") String instructions, @JsonProperty(value="_meta") Map<String, Object> meta) implements Result
    {
        public InitializeResult(String protocolVersion, ServerCapabilities capabilities, Implementation serverInfo, String instructions) {
            this(protocolVersion, capabilities, serverInfo, instructions, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record InitializeRequest(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ClientCapabilities capabilities, @JsonProperty(value="clientInfo") Implementation clientInfo, @JsonProperty(value="_meta") Map<String, Object> meta) implements Request
    {
        public InitializeRequest(String protocolVersion, ClientCapabilities capabilities, Implementation clientInfo) {
            this(protocolVersion, capabilities, clientInfo, null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Notification
    extends Meta {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Result
    extends Meta {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Request
    extends Meta {
        default public String progressToken() {
            if (this.meta() != null && this.meta().containsKey("progressToken")) {
                return this.meta().get("progressToken").toString();
            }
            return null;
        }
    }

    public static interface Meta {
        public Map<String, Object> meta();
    }

    public static final class ErrorCodes {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
        public static final int RESOURCE_NOT_FOUND = -32002;
    }
}

