/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.clients;

import com.google.protobuf.Struct;
import io.pinecone.clients.Pinecone;
import io.pinecone.commons.IndexInterface;
import io.pinecone.configs.PineconeConnection;
import io.pinecone.exceptions.PineconeValidationException;
import io.pinecone.proto.DeleteRequest;
import io.pinecone.proto.DeleteResponse;
import io.pinecone.proto.DescribeIndexStatsRequest;
import io.pinecone.proto.DescribeIndexStatsResponse;
import io.pinecone.proto.FetchRequest;
import io.pinecone.proto.FetchResponse;
import io.pinecone.proto.ListRequest;
import io.pinecone.proto.ListResponse;
import io.pinecone.proto.QueryRequest;
import io.pinecone.proto.UpdateRequest;
import io.pinecone.proto.UpdateResponse;
import io.pinecone.proto.UpsertRequest;
import io.pinecone.proto.UpsertResponse;
import io.pinecone.proto.VectorServiceGrpc;
import io.pinecone.unsigned_indices_model.QueryResponseWithUnsignedIndices;
import io.pinecone.unsigned_indices_model.VectorWithUnsignedIndices;
import java.util.List;

public class Index
implements IndexInterface<UpsertResponse, QueryResponseWithUnsignedIndices, FetchResponse, UpdateResponse, DeleteResponse, DescribeIndexStatsResponse, ListResponse> {
    private final PineconeConnection connection;
    private final String indexName;
    private final VectorServiceGrpc.VectorServiceBlockingStub blockingStub;

    public Index(PineconeConnection connection, String indexName) {
        if (connection == null) {
            throw new PineconeValidationException("Pinecone connection object cannot be null.");
        }
        this.connection = connection;
        this.indexName = indexName;
        this.blockingStub = connection.getBlockingStub();
    }

    @Override
    public UpsertResponse upsert(List<VectorWithUnsignedIndices> vectorList, String namespace) {
        UpsertRequest upsertRequest = this.validateUpsertRequest(vectorList, namespace);
        return this.blockingStub.upsert(upsertRequest);
    }

    @Override
    public UpsertResponse upsert(String id, List<Float> values) {
        return this.upsert(id, (List)values, (List)null, (List)null, (Struct)null, (String)null);
    }

    @Override
    public UpsertResponse upsert(String id, List<Float> values, String namespace) {
        return this.upsert(id, (List)values, (List)null, (List)null, (Struct)null, namespace);
    }

    @Override
    public UpsertResponse upsert(String id, List<Float> values, List<Long> sparseIndices, List<Float> sparseValues, Struct metadata, String namespace) {
        UpsertRequest upsertRequest = this.validateUpsertRequest(id, values, sparseIndices, sparseValues, metadata, namespace);
        return this.blockingStub.upsert(upsertRequest);
    }

    @Override
    public QueryResponseWithUnsignedIndices query(int topK, List<Float> vector, List<Long> sparseIndices, List<Float> sparseValues, String id, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        QueryRequest queryRequest = this.validateQueryRequest(topK, vector, sparseIndices, sparseValues, id, namespace, filter, includeValues, includeMetadata);
        return new QueryResponseWithUnsignedIndices(this.blockingStub.query(queryRequest));
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVectorId(int topK, String id, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, (List)null, (List)null, (List)null, id, namespace, filter, includeValues, includeMetadata);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVectorId(int topK, String id, String namespace, Struct filter) {
        return this.query(topK, (List)null, (List)null, (List)null, id, namespace, filter, false, false);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVectorId(int topK, String id, String namespace, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, (List)null, (List)null, (List)null, id, namespace, (Struct)null, includeValues, includeMetadata);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVectorId(int topK, String id, String namespace) {
        return this.query(topK, (List)null, (List)null, (List)null, id, namespace, (Struct)null, false, false);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVectorId(int topK, String id, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, (List)null, (List)null, (List)null, id, (String)null, (Struct)null, includeValues, includeMetadata);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVectorId(int topK, String id) {
        return this.query(topK, (List)null, (List)null, (List)null, id, (String)null, (Struct)null, false, false);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVector(int topK, List<Float> vector, String namespace, Struct filter, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, (List)vector, (List)null, (List)null, (String)null, namespace, filter, includeValues, includeMetadata);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVector(int topK, List<Float> vector, String namespace, Struct filter) {
        return this.query(topK, (List)vector, (List)null, (List)null, (String)null, namespace, filter, false, false);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVector(int topK, List<Float> vector, String namespace, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, (List)vector, (List)null, (List)null, (String)null, namespace, (Struct)null, includeValues, includeMetadata);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVector(int topK, List<Float> vector, String namespace) {
        return this.query(topK, (List)vector, (List)null, (List)null, (String)null, namespace, (Struct)null, false, false);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVector(int topK, List<Float> vector, boolean includeValues, boolean includeMetadata) {
        return this.query(topK, (List)vector, (List)null, (List)null, (String)null, (String)null, (Struct)null, includeValues, includeMetadata);
    }

    @Override
    public QueryResponseWithUnsignedIndices queryByVector(int topK, List<Float> vector) {
        return this.query(topK, (List)vector, (List)null, (List)null, (String)null, (String)null, (Struct)null, false, false);
    }

    @Override
    public FetchResponse fetch(List<String> ids) {
        return this.fetch((List)ids, (String)null);
    }

    @Override
    public FetchResponse fetch(List<String> ids, String namespace) {
        FetchRequest fetchRequest = this.validateFetchRequest(ids, namespace);
        return this.blockingStub.fetch(fetchRequest);
    }

    @Override
    public UpdateResponse update(String id, List<Float> values) {
        return this.update(id, (List)values, (Struct)null, (String)null, (List)null, (List)null);
    }

    @Override
    public UpdateResponse update(String id, List<Float> values, String namespace) {
        return this.update(id, (List)values, (Struct)null, namespace, (List)null, (List)null);
    }

    @Override
    public UpdateResponse update(String id, List<Float> values, Struct metadata, String namespace, List<Long> sparseIndices, List<Float> sparseValues) {
        UpdateRequest updateRequest = this.validateUpdateRequest(id, values, metadata, namespace, sparseIndices, sparseValues);
        return this.blockingStub.update(updateRequest);
    }

    @Override
    public DeleteResponse deleteByIds(List<String> ids, String namespace) {
        return this.delete((List)ids, false, namespace, (Struct)null);
    }

    @Override
    public DeleteResponse deleteByIds(List<String> ids) {
        return this.delete((List)ids, false, (String)null, (Struct)null);
    }

    @Override
    public DeleteResponse deleteByFilter(Struct filter, String namespace) {
        return this.delete((List)null, false, namespace, filter);
    }

    @Override
    public DeleteResponse deleteByFilter(Struct filter) {
        return this.delete((List)null, false, (String)null, filter);
    }

    @Override
    public DeleteResponse deleteAll(String namespace) {
        return this.delete((List)null, true, namespace, (Struct)null);
    }

    @Override
    public DeleteResponse delete(List<String> ids, boolean deleteAll, String namespace, Struct filter) {
        DeleteRequest deleteRequest = this.validateDeleteRequest(ids, deleteAll, namespace, filter);
        return this.blockingStub.delete(deleteRequest);
    }

    @Override
    public DescribeIndexStatsResponse describeIndexStats() {
        DescribeIndexStatsRequest describeIndexStatsRequest = this.validateDescribeIndexStatsRequest(null);
        return this.blockingStub.describeIndexStats(describeIndexStatsRequest);
    }

    @Override
    public DescribeIndexStatsResponse describeIndexStats(Struct filter) {
        DescribeIndexStatsRequest describeIndexStatsRequest = this.validateDescribeIndexStatsRequest(filter);
        return this.blockingStub.describeIndexStats(describeIndexStatsRequest);
    }

    @Override
    public ListResponse list() {
        this.validateListEndpointParameters(null, null, null, null, false, false, false, false);
        ListRequest listRequest = ListRequest.newBuilder().build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace) {
        this.validateListEndpointParameters(namespace, null, null, null, true, false, false, false);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace, int limit, String paginationToken) {
        this.validateListEndpointParameters(namespace, null, paginationToken, limit, true, false, true, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setLimit(limit).setPaginationToken(paginationToken).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace, int limit) {
        this.validateListEndpointParameters(namespace, null, null, limit, true, false, false, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setLimit(limit).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace, String prefix) {
        this.validateListEndpointParameters(namespace, prefix, null, null, true, true, false, false);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace, String prefix, int limit) {
        this.validateListEndpointParameters(namespace, prefix, null, limit, true, true, false, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).setLimit(limit).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace, String prefix, String paginationToken) {
        this.validateListEndpointParameters(namespace, prefix, paginationToken, null, true, true, true, false);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).setPaginationToken(paginationToken).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public ListResponse list(String namespace, String prefix, String paginationToken, int limit) {
        this.validateListEndpointParameters(namespace, prefix, paginationToken, limit, true, true, true, true);
        ListRequest listRequest = ListRequest.newBuilder().setNamespace(namespace).setPrefix(prefix).setPaginationToken(paginationToken).setLimit(limit).build();
        return this.blockingStub.list(listRequest);
    }

    @Override
    public void close() {
        Pinecone.closeConnection(this.indexName);
        this.connection.close();
    }
}

