/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.akka;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.util.context.Context;

public class ActorScheduler
implements Scheduler {
    final ActorRef actor;

    public static Scheduler from(ActorSystem system) {
        Objects.requireNonNull(system, "system");
        return new ActorScheduler(system.actorOf(Props.create(ActorExecutor.class, (Object[])new Object[0])));
    }

    public static Scheduler from(ActorRef actorRef) {
        Objects.requireNonNull(actorRef, "actorRef");
        return new ActorScheduler(actorRef);
    }

    ActorScheduler(ActorRef actor) {
        this.actor = actor;
    }

    public Disposable schedule(Runnable task) {
        DirectRunnable dr = new DirectRunnable(task);
        this.actor.tell((Object)dr, ActorRef.noSender());
        return dr;
    }

    public Scheduler.Worker createWorker() {
        return new ActorWorker(this.actor);
    }

    static final class ActorExecutor
    extends UntypedActor {
        ActorExecutor() {
        }

        public void onReceive(Object message) throws Exception {
            Runnable r = (Runnable)message;
            try {
                r.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                Operators.onErrorDropped((Throwable)ex, (Context)Context.empty());
            }
        }
    }

    static final class WorkerRunnable
    extends AtomicBoolean
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = -1760219254778525714L;
        final Runnable run;
        final ActorWorker parent;

        public WorkerRunnable(Runnable run, ActorWorker parent) {
            this.run = run;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (!this.get()) {
                try {
                    this.run.run();
                }
                finally {
                    if (this.compareAndSet(false, true)) {
                        this.parent.delete(this);
                    }
                }
            }
        }

        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.delete(this);
            }
        }

        public void delete() {
            this.set(true);
        }
    }

    static final class DirectRunnable
    extends AtomicBoolean
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = -8208677295345126172L;
        final Runnable run;

        public DirectRunnable(Runnable run) {
            this.run = run;
        }

        @Override
        public void run() {
            if (!this.get()) {
                this.run.run();
            }
        }

        public void dispose() {
            this.set(true);
        }
    }

    static final class ActorWorker
    implements Scheduler.Worker {
        final ActorRef actor;
        HashSet<WorkerRunnable> tasks;

        public ActorWorker(ActorRef actor) {
            this.actor = actor;
            this.tasks = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Disposable schedule(Runnable task) {
            WorkerRunnable wr = new WorkerRunnable(task, this);
            ActorWorker actorWorker = this;
            synchronized (actorWorker) {
                HashSet<WorkerRunnable> set = this.tasks;
                if (set == null) {
                    throw Exceptions.failWithRejected();
                }
                set.add(wr);
            }
            this.actor.tell((Object)wr, ActorRef.noSender());
            return wr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            HashSet<WorkerRunnable> set;
            ActorWorker actorWorker = this;
            synchronized (actorWorker) {
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null) {
                for (WorkerRunnable wr : set) {
                    wr.delete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete(WorkerRunnable run) {
            ActorWorker actorWorker = this;
            synchronized (actorWorker) {
                HashSet<WorkerRunnable> set = this.tasks;
                if (set == null) {
                    return;
                }
                set.remove(run);
            }
        }
    }
}

