/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import io.reactivex.rxjava3.core.Scheduler;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.adapter.rxjava.RxJava3Adapter;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;

public final class RxJava3Scheduler
implements reactor.core.scheduler.Scheduler {
    boolean isDisposed = false;
    final Scheduler scheduler;

    public static reactor.core.scheduler.Scheduler from(Scheduler scheduler) {
        return new RxJava3Scheduler(scheduler);
    }

    RxJava3Scheduler(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public Scheduler.Worker createWorker() {
        return new RxSchedulerWorker(this.scheduler.createWorker());
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.scheduler.shutdown();
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void start() {
        this.scheduler.start();
    }

    public Disposable schedule(Runnable task) {
        return new RxJava3Adapter.DisposableFromRxJava3Disposable(this.scheduler.scheduleDirect(task));
    }

    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        return new RxJava3Adapter.DisposableFromRxJava3Disposable(this.scheduler.scheduleDirect(task, delay, unit));
    }

    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return new RxJava3Adapter.DisposableFromRxJava3Disposable(this.scheduler.schedulePeriodicallyDirect(task, initialDelay, period, unit));
    }

    static final class RxSchedulerWorker
    implements Scheduler.Worker {
        final Scheduler.Worker w;

        RxSchedulerWorker(Scheduler.Worker w) {
            this.w = w;
        }

        public void dispose() {
            this.w.dispose();
        }

        public boolean isDisposed() {
            return this.w.isDisposed();
        }

        public Disposable schedule(Runnable task) {
            return new RxJava3Adapter.DisposableFromRxJava3Disposable(this.w.schedule(task));
        }

        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            return new RxJava3Adapter.DisposableFromRxJava3Disposable(this.w.schedule(task, delay, unit));
        }

        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return new RxJava3Adapter.DisposableFromRxJava3Disposable(this.w.schedulePeriodically(task, initialDelay, period, unit));
        }
    }
}

