/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import reactor.kafka.receiver.observation.KafkaReceiverObservationConvention;
import reactor.kafka.receiver.observation.KafkaRecordReceiverContext;

public enum KafkaReceiverObservation implements ObservationDocumentation
{
    RECEIVER_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultKafkaReceiverObservationConvention.class;
        }

        public String getPrefix() {
            return "reactor.kafka.receiver";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return ReceiverLowCardinalityTags.values();
        }
    };


    public static class DefaultKafkaReceiverObservationConvention
    implements KafkaReceiverObservationConvention {
        public static final DefaultKafkaReceiverObservationConvention INSTANCE = new DefaultKafkaReceiverObservationConvention();

        public KeyValues getLowCardinalityKeyValues(KafkaRecordReceiverContext context) {
            return KeyValues.of((KeyValue[])new KeyValue[]{ReceiverLowCardinalityTags.RECEIVER_ID.withValue(context.getReceiverId()), ReceiverLowCardinalityTags.COMPONENT_TYPE.withValue("receiver")});
        }
    }

    public static enum ReceiverLowCardinalityTags implements KeyName
    {
        RECEIVER_ID{

            public String asString() {
                return "reactor.kafka.client.id";
            }
        }
        ,
        COMPONENT_TYPE{

            public String asString() {
                return "reactor.kafka.type";
            }
        };

    }
}

