/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformationContext;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;

public final class AnnotationStore {
    private final ConcurrentMap<AnnotationTargetKey, Collection<AnnotationInstance>> transformed;
    private final EnumMap<AnnotationTarget.Kind, List<AnnotationsTransformer>> transformersMap;
    private final BuildExtension.BuildContext buildContext;

    AnnotationStore(Collection<AnnotationsTransformer> transformers, BuildExtension.BuildContext buildContext) {
        if (transformers == null || transformers.isEmpty()) {
            this.transformed = null;
            this.transformersMap = null;
        } else {
            this.transformed = new ConcurrentHashMap<AnnotationTargetKey, Collection<AnnotationInstance>>();
            this.transformersMap = new EnumMap(AnnotationTarget.Kind.class);
            this.transformersMap.put(AnnotationTarget.Kind.CLASS, this.initTransformers(AnnotationTarget.Kind.CLASS, transformers));
            this.transformersMap.put(AnnotationTarget.Kind.METHOD, this.initTransformers(AnnotationTarget.Kind.METHOD, transformers));
            this.transformersMap.put(AnnotationTarget.Kind.FIELD, this.initTransformers(AnnotationTarget.Kind.FIELD, transformers));
        }
        this.buildContext = buildContext;
    }

    public Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        if (this.transformed != null) {
            return this.transformed.computeIfAbsent(new AnnotationTargetKey(target), this::transform);
        }
        return this.getOriginalAnnotations(target);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target, DotName name) {
        return Annotations.find(this.getAnnotations(target), name);
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName name) {
        return Annotations.contains(this.getAnnotations(target), name);
    }

    public boolean hasAnyAnnotation(AnnotationTarget target, Iterable<DotName> names) {
        return Annotations.containsAny(this.getAnnotations(target), names);
    }

    private Collection<AnnotationInstance> transform(AnnotationTargetKey key) {
        AnnotationTarget target = key.target;
        Collection<AnnotationInstance> annotations = this.getOriginalAnnotations(target);
        List<AnnotationsTransformer> transformers = this.transformersMap.get(target.kind());
        if (transformers.isEmpty()) {
            return annotations;
        }
        TransformationContextImpl transformationContext = new TransformationContextImpl(this.buildContext, target, annotations);
        for (AnnotationsTransformer transformer : transformers) {
            transformer.transform(transformationContext);
        }
        return transformationContext.getAnnotations();
    }

    private Collection<AnnotationInstance> getOriginalAnnotations(AnnotationTarget target) {
        return Annotations.onlyRuntimeVisible(switch (target.kind()) {
            case AnnotationTarget.Kind.CLASS -> target.asClass().declaredAnnotations();
            case AnnotationTarget.Kind.METHOD -> target.asMethod().annotations();
            case AnnotationTarget.Kind.FIELD -> target.asField().annotations();
            default -> throw new IllegalArgumentException("Unsupported annotation target");
        });
    }

    private List<AnnotationsTransformer> initTransformers(AnnotationTarget.Kind kind, Collection<AnnotationsTransformer> transformers) {
        ArrayList<AnnotationsTransformer> found = new ArrayList<AnnotationsTransformer>();
        for (AnnotationsTransformer transformer : transformers) {
            if (!transformer.appliesTo(kind)) continue;
            found.add(transformer);
        }
        if (found.isEmpty()) {
            return Collections.emptyList();
        }
        found.sort(BuildExtension::compare);
        return found;
    }

    private static IllegalArgumentException unsupportedAnnotationTarget(AnnotationTarget target) {
        return new IllegalArgumentException("Unsupported annotation target: " + target.kind());
    }

    static final class AnnotationTargetKey {
        final AnnotationTarget target;

        public AnnotationTargetKey(AnnotationTarget target) {
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationTargetKey other = (AnnotationTargetKey)obj;
            if (this.target.kind() != other.target.kind()) {
                return false;
            }
            switch (this.target.kind()) {
                case METHOD: {
                    return this.target.asMethod().equals((Object)other.target);
                }
                case FIELD: {
                    FieldInfo field = this.target.asField();
                    FieldInfo otherField = other.target.asField();
                    return Objects.equals(field.name(), otherField.name()) && Objects.equals(field.declaringClass().name(), otherField.declaringClass().name());
                }
                case CLASS: {
                    return this.target.asClass().name().equals((Object)other.target.asClass().name());
                }
            }
            throw AnnotationStore.unsupportedAnnotationTarget(this.target);
        }

        public int hashCode() {
            switch (this.target.kind()) {
                case METHOD: {
                    return this.target.asMethod().hashCode();
                }
                case FIELD: {
                    return Objects.hash(this.target.asField().name(), this.target.asField().declaringClass().name());
                }
                case CLASS: {
                    return this.target.asClass().name().hashCode();
                }
            }
            throw AnnotationStore.unsupportedAnnotationTarget(this.target);
        }
    }

    static class TransformationContextImpl
    extends AnnotationsTransformationContext<Collection<AnnotationInstance>>
    implements AnnotationsTransformer.TransformationContext {
        private static final Logger LOG = Logger.getLogger(TransformationContextImpl.class);

        public TransformationContextImpl(BuildExtension.BuildContext buildContext, AnnotationTarget target, Collection<AnnotationInstance> annotations) {
            super(buildContext, target, annotations);
        }

        @Override
        public Transformation transform() {
            if (LOG.isTraceEnabled()) {
                String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
                LOG.tracef("Transforming annotations of %s %s\n\t...", (Object)this.target, (Object)stack);
            }
            return new Transformation((Collection<AnnotationInstance>)new ArrayList<AnnotationInstance>((Collection<AnnotationInstance>)this.getAnnotations()), this.getTarget(), this::setAnnotations);
        }
    }
}

