/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableReduceMaybe<T>
extends Maybe<T> {
    final ObservableSource<T> source;
    final BiFunction<T, T, T> reducer;

    public ObservableReduceMaybe(ObservableSource<T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new ReduceObserver<T>(observer, this.reducer));
    }

    static final class ReduceObserver<T>
    implements Observer<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        final BiFunction<T, T, T> reducer;
        boolean done;
        T value;
        Disposable d;

        ReduceObserver(MaybeObserver<? super T> observer, BiFunction<T, T, T> reducer) {
            this.actual = observer;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (!this.done) {
                T v = this.value;
                if (v == null) {
                    this.value = value;
                } else {
                    try {
                        this.value = ObjectHelper.requireNonNull(this.reducer.apply(v, value), "The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.d.dispose();
                        this.onError(ex);
                    }
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            this.value = null;
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v = this.value;
            this.value = null;
            if (v != null) {
                this.actual.onSuccess(v);
            } else {
                this.actual.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.d.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }
    }
}

