/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.UnicastProcessor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public class SchedulerWhen
extends Scheduler
implements Disposable {
    private final Scheduler actualScheduler;
    private final FlowableProcessor<Flowable<Completable>> workerProcessor;
    private Disposable disposable;
    static final Disposable SUBSCRIBED = new Disposable(){

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }
    };
    static final Disposable DISPOSED = Disposables.disposed();

    public SchedulerWhen(Function<Flowable<Flowable<Completable>>, Completable> combine, Scheduler actualScheduler) {
        this.actualScheduler = actualScheduler;
        this.workerProcessor = UnicastProcessor.create().toSerialized();
        try {
            this.disposable = combine.apply(this.workerProcessor).subscribe();
        }
        catch (Throwable e) {
            Exceptions.propagate(e);
        }
    }

    @Override
    public void dispose() {
        this.disposable.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    @Override
    public Scheduler.Worker createWorker() {
        final Scheduler.Worker actualWorker = this.actualScheduler.createWorker();
        final FlowableProcessor<ScheduledAction> actionProcessor = UnicastProcessor.create().toSerialized();
        Flowable<Completable> actions = actionProcessor.map(new Function<ScheduledAction, Completable>(){

            @Override
            public Completable apply(final ScheduledAction action) {
                return new Completable(){

                    @Override
                    protected void subscribeActual(CompletableObserver actionCompletable) {
                        actionCompletable.onSubscribe(action);
                        action.call(actualWorker, actionCompletable);
                    }
                };
            }
        });
        Scheduler.Worker worker = new Scheduler.Worker(){
            private final AtomicBoolean unsubscribed = new AtomicBoolean();

            @Override
            public void dispose() {
                if (this.unsubscribed.compareAndSet(false, true)) {
                    actualWorker.dispose();
                    actionProcessor.onComplete();
                }
            }

            @Override
            public boolean isDisposed() {
                return this.unsubscribed.get();
            }

            @Override
            public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
                DelayedAction delayedAction = new DelayedAction(action, delayTime, unit);
                actionProcessor.onNext(delayedAction);
                return delayedAction;
            }

            @Override
            public Disposable schedule(Runnable action) {
                ImmediateAction immediateAction = new ImmediateAction(action);
                actionProcessor.onNext(immediateAction);
                return immediateAction;
            }
        };
        this.workerProcessor.onNext(actions);
        return worker;
    }

    static class OnCompletedAction
    implements Runnable {
        private CompletableObserver actionCompletable;
        private Runnable action;

        OnCompletedAction(Runnable action, CompletableObserver actionCompletable) {
            this.action = action;
            this.actionCompletable = actionCompletable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.action.run();
            }
            finally {
                this.actionCompletable.onComplete();
            }
        }
    }

    static class DelayedAction
    extends ScheduledAction {
        private final Runnable action;
        private final long delayTime;
        private final TimeUnit unit;

        DelayedAction(Runnable action, long delayTime, TimeUnit unit) {
            this.action = action;
            this.delayTime = delayTime;
            this.unit = unit;
        }

        @Override
        protected Disposable callActual(Scheduler.Worker actualWorker, CompletableObserver actionCompletable) {
            return actualWorker.schedule(new OnCompletedAction(this.action, actionCompletable), this.delayTime, this.unit);
        }
    }

    static class ImmediateAction
    extends ScheduledAction {
        private final Runnable action;

        ImmediateAction(Runnable action) {
            this.action = action;
        }

        @Override
        protected Disposable callActual(Scheduler.Worker actualWorker, CompletableObserver actionCompletable) {
            return actualWorker.schedule(new OnCompletedAction(this.action, actionCompletable));
        }
    }

    static abstract class ScheduledAction
    extends AtomicReference<Disposable>
    implements Disposable {
        ScheduledAction() {
            super(SUBSCRIBED);
        }

        void call(Scheduler.Worker actualWorker, CompletableObserver actionCompletable) {
            Disposable oldState = (Disposable)this.get();
            if (oldState == DISPOSED) {
                return;
            }
            if (oldState != SUBSCRIBED) {
                return;
            }
            Disposable newState = this.callActual(actualWorker, actionCompletable);
            if (!this.compareAndSet(SUBSCRIBED, newState)) {
                newState.dispose();
            }
        }

        protected abstract Disposable callActual(Scheduler.Worker var1, CompletableObserver var2);

        @Override
        public boolean isDisposed() {
            return ((Disposable)this.get()).isDisposed();
        }

        @Override
        public void dispose() {
            Disposable oldState;
            Disposable newState = DISPOSED;
            do {
                if ((oldState = (Disposable)this.get()) != DISPOSED) continue;
                return;
            } while (!this.compareAndSet(oldState, newState));
            if (oldState != SUBSCRIBED) {
                oldState.dispose();
            }
        }
    }
}

