/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import javax.annotation.Nullable;

public class LeaseFrameFlyweight {
    public static ByteBuf encode(ByteBufAllocator allocator, int ttl, int numRequests, @Nullable ByteBuf metadata) {
        boolean addMetadata;
        boolean hasMetadata = metadata != null;
        int flags = 0;
        if (hasMetadata) {
            flags |= 0x100;
        }
        ByteBuf header = FrameHeaderFlyweight.encodeStreamZero(allocator, FrameType.LEASE, flags).writeInt(ttl).writeInt(numRequests);
        if (hasMetadata) {
            if (metadata.isReadable()) {
                addMetadata = true;
            } else {
                metadata.release();
                addMetadata = false;
            }
        } else {
            addMetadata = false;
        }
        if (addMetadata) {
            return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, metadata});
        }
        return header;
    }

    public static int ttl(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.LEASE, byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size());
        int ttl = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return ttl;
    }

    public static int numRequests(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.LEASE, byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size() + 4);
        int numRequests = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return numRequests;
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        FrameHeaderFlyweight.ensureFrameType(FrameType.LEASE, byteBuf);
        if (FrameHeaderFlyweight.hasMetadata(byteBuf)) {
            byteBuf.markReaderIndex();
            byteBuf.skipBytes(FrameHeaderFlyweight.size() + 8);
            ByteBuf metadata = byteBuf.slice();
            byteBuf.resetReaderIndex();
            return metadata;
        }
        return Unpooled.EMPTY_BUFFER;
    }
}

