/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

public class BeanValidators {
    public static final int BEAN_VALIDATOR_PLUGIN_ORDER = -2147483148;

    private BeanValidators() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Annotation> Optional<T> validatorFromBean(ModelPropertyContext context, Class<T> annotationType) {
        Optional propertyDefinition = context.getBeanPropertyDefinition();
        Optional notNull = Optional.absent();
        if (propertyDefinition.isPresent()) {
            notNull = BeanValidators.annotationFrom((AnnotatedMember)((BeanPropertyDefinition)propertyDefinition.get()).getGetter(), annotationType).or(BeanValidators.annotationFrom((AnnotatedMember)((BeanPropertyDefinition)propertyDefinition.get()).getField(), annotationType));
        }
        return notNull;
    }

    public static <T extends Annotation> Optional<T> validatorFromField(ModelPropertyContext context, Class<T> annotationType) {
        Optional annotatedElement = context.getAnnotatedElement();
        Optional notNull = Optional.absent();
        if (annotatedElement.isPresent()) {
            notNull = Optional.fromNullable(((AnnotatedElement)annotatedElement.get()).getAnnotation(annotationType));
        }
        return notNull;
    }

    @VisibleForTesting
    static <T extends Annotation> Optional<T> annotationFrom(AnnotatedMember nullableMember, Class<T> annotationType) {
        Optional member = Optional.fromNullable((Object)nullableMember);
        Optional notNull = Optional.absent();
        if (member.isPresent()) {
            notNull = FluentIterable.from((Iterable)((AnnotatedMember)member.get()).annotations()).filter(annotationType).first();
        }
        return notNull;
    }
}

