/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.BeanValidators;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class SizeAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SizeAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<Size> size = this.extractAnnotation(context);
        if (size.isPresent()) {
            context.getBuilder().allowableValues(this.createAllowableValuesFromSizeForStrings((Size)size.get()));
        }
    }

    @VisibleForTesting
    Optional<Size> extractAnnotation(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, Size.class).or(BeanValidators.validatorFromField(context, Size.class));
    }

    private AllowableValues createAllowableValuesFromSizeForStrings(Size size) {
        LOG.debug("@Size detected: adding MinLength/MaxLength to field");
        return new AllowableRangeValues(this.minValue(size), this.maxValue(size));
    }

    private String minValue(Size size) {
        return String.valueOf(Math.max(size.min(), 0));
    }

    private String maxValue(Size size) {
        return String.valueOf(Math.max(0, Math.min(size.max(), Integer.MAX_VALUE)));
    }
}

