/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.staticdocs;

import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;

public class SwaggerResultHandler
implements ResultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerResultHandler.class);
    private final String outputDir;
    private final String fileName;

    SwaggerResultHandler(String outputDir, String fileName) {
        this.outputDir = outputDir;
        this.fileName = fileName;
    }

    public static Builder outputDirectory(String outputDir) {
        Validate.notEmpty((CharSequence)outputDir, (String)"outputDir must not be empty!", (Object[])new Object[0]);
        return new Builder(outputDir);
    }

    public void handle(MvcResult result) throws Exception {
        MockHttpServletResponse response = result.getResponse();
        String swaggerJson = response.getContentAsString();
        Files.createDirectories(Paths.get(this.outputDir, new String[0]), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(this.outputDir, this.fileName), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(swaggerJson);
        }
    }

    public static class Builder {
        private final String outputDir;
        private String fileName;

        Builder(String outputDir) {
            this.outputDir = outputDir;
        }

        public SwaggerResultHandler build() {
            if (StringUtils.isBlank((CharSequence)this.fileName)) {
                this.fileName = "swagger.json";
            }
            return new SwaggerResultHandler(this.outputDir, this.fileName);
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }
    }
}

