/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.datatype.DataFormat;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.datatype.DataTypeCodec;
import io.vertx.mysqlclient.impl.protocol.Packets;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;

abstract class ExtendedQueryCommandBaseCodec<R, C extends ExtendedQueryCommand<R>>
extends QueryCommandBaseCodec<R, C> {
    protected final MySQLPreparedStatement statement;

    ExtendedQueryCommandBaseCodec(C cmd) {
        super(cmd, DataFormat.BINARY);
        this.statement = (MySQLPreparedStatement)cmd.preparedStatement();
    }

    @Override
    protected void handleInitPacket(ByteBuf payload) {
        short firstByte = payload.getUnsignedByte(payload.readerIndex());
        if (firstByte == 0) {
            Packets.OkPacket okPacket = this.decodeOkPacketPayload(payload);
            this.handleSingleResultsetDecodingCompleted(okPacket.serverStatusFlags(), okPacket.affectedRows(), okPacket.lastInsertId());
        } else if (firstByte == 255) {
            this.closePreparedStatement();
            this.handleErrorPacketPayload(payload);
        } else {
            this.handleResultsetColumnCountPacketBody(payload);
        }
    }

    @Override
    protected void handleAllResultsetDecodingCompleted() {
        this.closePreparedStatement();
        super.handleAllResultsetDecodingCompleted();
    }

    private void closePreparedStatement() {
        MySQLPreparedStatement ps = (MySQLPreparedStatement)((ExtendedQueryCommand)this.cmd).ps;
        if (ps.closeAfterUsage) {
            this.sendCloseStatementCommand(ps);
        }
    }

    protected void sendCloseStatementCommand(MySQLPreparedStatement statement) {
        ByteBuf packet = this.allocateBuffer(9);
        packet.writeMediumLE(5);
        packet.writeByte(0);
        packet.writeByte(25);
        packet.writeIntLE((int)statement.statementId);
        this.sendNonSplitPacket(packet);
    }

    protected final void sendStatementExecuteCommand(MySQLPreparedStatement statement, boolean sendTypesToServer, Tuple params, byte cursorType) {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(23);
        packet.writeIntLE((int)statement.statementId);
        packet.writeByte((int)cursorType);
        packet.writeIntLE(1);
        int numOfParams = statement.bindingTypes().length;
        int bitmapLength = numOfParams + 7 >> 3;
        byte[] nullBitmap = new byte[bitmapLength];
        int pos = packet.writerIndex();
        if (numOfParams > 0) {
            packet.writeBytes(nullBitmap);
            packet.writeBoolean(sendTypesToServer);
            if (sendTypesToServer) {
                for (DataType bindingType : statement.bindingTypes()) {
                    packet.writeByte(bindingType.id);
                    packet.writeByte(0);
                }
            }
            for (int i = 0; i < numOfParams; ++i) {
                Object value = params.getValue(i);
                if (value != null) {
                    DataTypeCodec.encodeBinary(statement.bindingTypes()[i], value, this.encoder.encodingCharset, packet);
                    continue;
                }
                int n = i >> 3;
                nullBitmap[n] = (byte)(nullBitmap[n] | 1 << (i & 7));
            }
            packet.setBytes(pos, nullBitmap);
        }
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }
}

