/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.activemq;

import java.io.IOException;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSender;
import org.apache.activemq.ActiveMQConnectionFactory;
import zipkin2.reporter.Call;
import zipkin2.reporter.Callback;
import zipkin2.reporter.CheckResult;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.Sender;
import zipkin2.reporter.activemq.ActiveMQConn;
import zipkin2.reporter.activemq.LazyInit;

public final class ActiveMQSender
extends Sender {
    final Encoding encoding;
    final int messageMaxBytes;
    final LazyInit lazyInit;
    volatile boolean closeCalled;

    public static ActiveMQSender create(String brokerUrl) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(brokerUrl);
        return ActiveMQSender.newBuilder().connectionFactory(connectionFactory).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    ActiveMQSender(Builder builder) {
        this.encoding = builder.encoding;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.lazyInit = new LazyInit(builder);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding.listSizeInBytes(encodedSizeInBytes);
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding.listSizeInBytes(encodedSpans);
    }

    @Deprecated
    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        byte[] message = this.encoding.encode(encodedSpans);
        return new ActiveMQCall(message);
    }

    public void send(List<byte[]> encodedSpans) throws IOException {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        this.send(this.encoding.encode(encodedSpans));
    }

    void send(byte[] message) throws IOException {
        try {
            ActiveMQConn conn = this.lazyInit.get();
            QueueSender sender = conn.sender;
            BytesMessage bytesMessage = conn.session.createBytesMessage();
            bytesMessage.writeBytes(message);
            sender.send((Message)bytesMessage);
        }
        catch (JMSException e) {
            throw ActiveMQSender.ioException("Unable to send message: ", e);
        }
    }

    @Deprecated
    public CheckResult check() {
        try {
            this.lazyInit.get();
        }
        catch (Throwable t) {
            Call.propagateIfFatal((Throwable)t);
            return CheckResult.failed((Throwable)t);
        }
        return this.lazyInit.result.checkResult;
    }

    public void close() {
        this.closeCalled = true;
        this.lazyInit.close();
    }

    public String toString() {
        return "ActiveMQSender{brokerURL=" + this.lazyInit.connectionFactory.getBrokerURL() + ", queue=" + this.lazyInit.queue + "}";
    }

    static IOException ioException(String prefix, JMSException e) {
        Exception cause = e.getLinkedException();
        if (cause instanceof IOException) {
            return new IOException(prefix + ActiveMQSender.message(cause), cause);
        }
        return new IOException(prefix + ActiveMQSender.message((Exception)((Object)e)), e);
    }

    static String message(Exception cause) {
        return cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName();
    }

    final class ActiveMQCall
    extends Call.Base<Void> {
        final byte[] message;

        ActiveMQCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            ActiveMQSender.this.send(this.message);
            return null;
        }

        public Call<Void> clone() {
            return new ActiveMQCall(this.message);
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                ActiveMQSender.this.send(this.message);
                callback.onSuccess(null);
            }
            catch (Throwable t) {
                Call.propagateIfFatal((Throwable)t);
                callback.onError(t);
            }
        }
    }

    public static final class Builder {
        ActiveMQConnectionFactory connectionFactory;
        String queue = "zipkin";
        Encoding encoding = Encoding.JSON;
        int messageMaxBytes = 500000;

        public Builder connectionFactory(ActiveMQConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder queue(String queue) {
            if (queue == null) {
                throw new NullPointerException("queue == null");
            }
            this.queue = queue;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public ActiveMQSender build() {
            if (this.connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            return new ActiveMQSender(this);
        }

        Builder() {
        }
    }
}

