/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.cdr.common;

import java.util.IllegalFormatFlagsException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvayaHelper {
    private static final Logger log = LoggerFactory.getLogger(AvayaHelper.class);
    private static final String EMPTY = "";

    private AvayaHelper() {
    }

    public static ImmutablePair<String, String> decode(String data) {
        log.debug("decode data : {}", (Object)data);
        return new ImmutablePair((Object)AvayaHelper.decodeShared(data), (Object)AvayaHelper.decodeUcid(data));
    }

    public static String decodeShared(String data) {
        log.debug("decode shared data : {}", (Object)data);
        return AvayaHelper.decodeHex(AvayaHelper.getHexData(data, "C8"));
    }

    public static String decodeUcid(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return EMPTY;
        }
        log.debug("decode ucid data : {}", (Object)data);
        String ucidHex = AvayaHelper.getHexData(data, "FA");
        String group1Hex = ucidHex.substring(0, 4);
        String group2Hex = ucidHex.substring(4, 8);
        String group3Hex = ucidHex.substring(8);
        int group1 = AvayaHelper.hexToDecimal(group1Hex);
        int group2 = AvayaHelper.hexToDecimal(group2Hex);
        int group3 = AvayaHelper.hexToDecimal(group3Hex);
        return AvayaHelper.append(group1, 5) + AvayaHelper.append(group2, 5) + AvayaHelper.append(group3, 10);
    }

    private static String getHexData(String data, String token) {
        int index = data.indexOf(token);
        if (index == -1) {
            return EMPTY;
        }
        String strLen = data.substring(index + 2, index + 4);
        int len = AvayaHelper.hexToDecimal(strLen) * 2;
        if (data.length() < index + 4 + len) {
            throw new IllegalFormatFlagsException(EMPTY);
        }
        return data.substring(index + 4, index + 4 + len);
    }

    private static int hexToDecimal(String hex) {
        return Integer.valueOf(hex, 16);
    }

    private static String append(int value, int maxLen) {
        StringBuilder strValue = new StringBuilder(Integer.toString(value));
        while (strValue.length() < maxLen) {
            strValue.insert(0, "0");
        }
        return strValue.toString();
    }

    private static String decodeHex(String hexStr) {
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < hexStr.length(); pos += 2) {
            sb.append((char)AvayaHelper.hexToDecimal(hexStr.substring(pos, pos + 2)));
        }
        return sb.toString();
    }
}

