/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.cdr.common;

import link.thingscloud.freeswitch.cdr.common.AvayaHelper;
import link.thingscloud.freeswitch.cdr.domain.Cdr;
import link.thingscloud.freeswitch.cdr.util.CdrDecodeUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdrHelper {
    private static final Logger log = LoggerFactory.getLogger(CdrHelper.class);
    private static final String SIP_H_USER_TO_USER = "sip_h_User-to-User";

    private CdrHelper() {
    }

    public static ImmutablePair<String, String> getUserData(Cdr cdr) {
        String userToUser = cdr.getVariables().getVariableTable().get(SIP_H_USER_TO_USER);
        if (StringUtils.isBlank((CharSequence)userToUser)) {
            return new ImmutablePair((Object)"", (Object)"");
        }
        try {
            return AvayaHelper.decode(userToUser);
        }
        catch (Exception e) {
            log.warn("getUserData decodeHex userToUser : [{}]", (Object)userToUser, (Object)e);
            return new ImmutablePair((Object)"", (Object)"");
        }
    }

    public static String decode(String str) {
        return CdrDecodeUtil.decode(str);
    }
}

