/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.cdr.parser;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import link.thingscloud.freeswitch.cdr.domain.AppLog;
import link.thingscloud.freeswitch.cdr.domain.Application;
import link.thingscloud.freeswitch.cdr.domain.Audio;
import link.thingscloud.freeswitch.cdr.domain.CallStats;
import link.thingscloud.freeswitch.cdr.domain.CallerProfile;
import link.thingscloud.freeswitch.cdr.domain.Callflow;
import link.thingscloud.freeswitch.cdr.domain.Cdr;
import link.thingscloud.freeswitch.cdr.domain.ChannelData;
import link.thingscloud.freeswitch.cdr.domain.ErrorLog;
import link.thingscloud.freeswitch.cdr.domain.ErrorPeriod;
import link.thingscloud.freeswitch.cdr.domain.Extension;
import link.thingscloud.freeswitch.cdr.domain.Hold;
import link.thingscloud.freeswitch.cdr.domain.HoldRecord;
import link.thingscloud.freeswitch.cdr.domain.Inbound;
import link.thingscloud.freeswitch.cdr.domain.Originatee;
import link.thingscloud.freeswitch.cdr.domain.OriginateeCallerProfile;
import link.thingscloud.freeswitch.cdr.domain.Origination;
import link.thingscloud.freeswitch.cdr.domain.OriginationCallerProfile;
import link.thingscloud.freeswitch.cdr.domain.Originator;
import link.thingscloud.freeswitch.cdr.domain.OriginatorCallerProfile;
import link.thingscloud.freeswitch.cdr.domain.Outbound;
import link.thingscloud.freeswitch.cdr.domain.Times;
import link.thingscloud.freeswitch.cdr.domain.Variables;
import link.thingscloud.freeswitch.cdr.exception.ParserException;
import link.thingscloud.freeswitch.cdr.util.CdrDecodeUtil;
import link.thingscloud.freeswitch.cdr.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdrParser {
    private static final Logger log = LoggerFactory.getLogger(CdrParser.class);
    private static final String CORE_UUID = "core-uuid";
    private static final String SWITCHNAME = "switchname";
    private static final String CHANNEL_DATA = "channel_data";
    private static final String CALL_STATS = "call-stats";
    private static final String STATE = "state";
    private static final String DIRECTION = "direction";
    private static final String STATE_NUMBER = "state_number";
    private static final String FLAGS = "flags";
    private static final String CAPS = "caps";
    private static final String VARIABLES = "variables";
    private static final String APP_LOG = "app_log";
    private static final String HOLD_RECORD = "hold-record";
    private static final String CALLFLOW = "callflow";
    private static ThreadLocal<String> local = new ThreadLocal();
    private static boolean isTraceEnabled = log.isTraceEnabled();
    private static final String AUDIO = "audio";
    private static final String INBOUND = "inbound";
    private static final String OUTBOUND = "outbound";
    private static final String ERROR_LOG = "error-log";
    private static final String RAW_BYTES = "raw_bytes";
    private static final String MEDIA_BYTES = "media_bytes";
    private static final String PACKET_COUNT = "packet_count";
    private static final String MEDIA_PACKET_COUNT = "media_packet_count";
    private static final String SKIP_PACKET_COUNT = "skip_packet_count";
    private static final String JITTER_PACKET_COUNT = "jitter_packet_count";
    private static final String DTMF_PACKET_COUNT = "dtmf_packet_count";
    private static final String CNG_PACKET_COUNT = "cng_packet_count";
    private static final String FLUSH_PACKET_COUNT = "flush_packet_count";
    private static final String LARGEST_JB_SIZE = "largest_jb_size";
    private static final String JITTER_MIN_VARIANCE = "jitter_min_variance";
    private static final String JITTER_MAX_VARIANCE = "jitter_max_variance";
    private static final String JITTER_LOSS_RATE = "jitter_loss_rate";
    private static final String JITTER_BURST_RATE = "jitter_burst_rate";
    private static final String MEAN_INTERVAL = "mean_interval";
    private static final String FLAW_TOTAL = "flaw_total";
    private static final String QUALITY_PERCENTAGE = "quality_percentage";
    private static final String MOS = "mos";
    private static final String RTCP_PACKET_COUNT = "rtcp_packet_count";
    private static final String RTCP_OCTET_COUNT = "rtcp_octet_count";
    private static final String ERROR_PERIOD = "error-period";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String FLAWS = "flaws";
    private static final String CONSECUTIVE_FLAWS = "consecutive-flaws";
    private static final String DURATION_MSEC = "duration-msec";
    private static final String HOLD = "hold";
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String BRIDGED_TO = "bridged-to";
    private static final String APPLICATION = "application";
    private static final String APP_NAME = "app_name";
    private static final String APP_DATA = "app_data";
    private static final String APP_STAMP = "app_stamp";
    private static final String DIALPLAN = "dialplan";
    private static final String UNIQUE_ID = "unique-id";
    private static final String CLONE_OF = "clone-of";
    private static final String PROFILE_INDEX = "profile_index";
    private static final String EXTENSION = "extension";
    private static final String CALLER_PROFILE = "caller_profile";
    private static final String TIMES = "times";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String USERNAME = "username";
    private static final String CALLER_ID_NAME = "caller_id_name";
    private static final String CALLER_ID_NUMBER = "caller_id_number";
    private static final String CALLEE_ID_NAME = "callee_id_name";
    private static final String CALLEE_ID_NUMBER = "callee_id_number";
    private static final String ANI = "ani";
    private static final String ANIII = "aniii";
    private static final String NETWORK_ADDR = "network_addr";
    private static final String RDNIS = "rdnis";
    private static final String DESTINATION_NUMBER = "destination_number";
    private static final String UUID = "uuid";
    private static final String SOURCE = "source";
    private static final String TRANSFER_SOURCE = "transfer_source";
    private static final String CONTEXT = "context";
    private static final String CHAN_NAME = "chan_name";
    private static final String ORIGINATOR = "originator";
    private static final String ORIGINATION = "origination";
    private static final String ORIGINATEE = "originatee";
    private static final String ORIGINATOR_CALLER_PROFILE = "originator_caller_profile";
    private static final String ORIGINATION_CALLER_PROFILE = "origination_caller_profile";
    private static final String ORIGINATEE_CALLER_PROFILE = "originatee_caller_profile";
    private static final String CREATED_TIME = "created_time";
    private static final String PROFILE_CREATED_TIME = "profile_created_time";
    private static final String PROGRESS_TIME = "progress_time";
    private static final String PROGRESS_MEDIA_TIME = "progress_media_time";
    private static final String ANSWERED_TIME = "answered_time";
    private static final String BRIDGED_TIME = "bridged_time";
    private static final String LAST_HOLD_TIME = "last_hold_time";
    private static final String HOLD_ACCUM_TIME = "hold_accum_time";
    private static final String HANGUP_TIME = "hangup_time";
    private static final String RESURRECT_TIME = "resurrect_time";
    private static final String TRANSFER_TIME = "transfer_time";

    private CdrParser() {
    }

    public static Cdr decodeThenParse(String reqText) throws ParserException {
        String decodeText = CdrDecodeUtil.decode(reqText);
        String decodeXml = StringUtils.substringAfter((String)decodeText, (String)"cdr=");
        return CdrParser.parse(decodeXml);
    }

    public static Cdr parse(String decodeXml) throws ParserException {
        if (StringUtils.isBlank((CharSequence)decodeXml)) {
            throw new ParserException("cdr parse xml failed, strXml is blank.");
        }
        local.set(decodeXml);
        try {
            Document document = DocumentHelper.parseText((String)decodeXml);
            Element rootElement = document.getRootElement();
            Cdr cdr = new Cdr();
            CdrParser.assignCdrElement(cdr, rootElement);
            if (isTraceEnabled) {
                log.trace("cdr parse : [{}]", (Object)JSON.toJSONString((Object)cdr, (boolean)true));
            }
            Cdr cdr2 = cdr;
            return cdr2;
        }
        catch (Exception e) {
            throw new ParserException("cdr parse xml failed.", e);
        }
        finally {
            local.remove();
        }
    }

    private static void assignCdrElement(Cdr cdr, Element rootElement) {
        CdrParser.attributes(rootElement, (name, value) -> {
            if (CORE_UUID.equals(name)) {
                cdr.setCoreUuid((String)value);
            } else if (SWITCHNAME.equals(name)) {
                cdr.setSwitchname((String)value);
            } else {
                log.warn("assignCdrElement found other attribute name : [{}], value : [{}], xml : [{}]", new Object[]{name, value, local.get()});
            }
        });
        CdrParser.elements(rootElement, (name, element) -> {
            switch (name) {
                case "channel_data": {
                    ChannelData channelData = new ChannelData();
                    cdr.setChannelData(channelData);
                    CdrParser.assignChannelDataElement(channelData, element);
                    break;
                }
                case "call-stats": {
                    CallStats callStats = new CallStats();
                    cdr.setCallStats(callStats);
                    CdrParser.assignCallStatsElement(callStats, element);
                    break;
                }
                case "variables": {
                    Variables variables = new Variables();
                    cdr.setVariables(variables);
                    CdrParser.assignVariablesElement(variables, element);
                    break;
                }
                case "app_log": {
                    AppLog appLog = new AppLog();
                    cdr.setAppLog(appLog);
                    CdrParser.assignAppLogElement(appLog, element);
                    break;
                }
                case "hold-record": {
                    HoldRecord holdRecord = new HoldRecord();
                    cdr.setHoldRecord(holdRecord);
                    CdrParser.assignHoldRecordElement(holdRecord, element);
                    break;
                }
                case "callflow": {
                    Callflow callflow = new Callflow();
                    cdr.addCallflow(callflow);
                    CdrParser.assignCallflowElement(callflow, element);
                    break;
                }
                default: {
                    log.warn("assignCdrElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignChannelDataElement(ChannelData channelData, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "state": {
                    channelData.setState(value);
                    break;
                }
                case "direction": {
                    channelData.setDirection(value);
                    break;
                }
                case "state_number": {
                    channelData.setStateNumber(value);
                    break;
                }
                case "flags": {
                    channelData.setFlags(value);
                    break;
                }
                case "caps": {
                    channelData.setCaps(value);
                    break;
                }
                default: {
                    log.warn("assignChannelDataElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignCallStatsElement(CallStats callStats, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "audio": {
                    Audio audio = new Audio();
                    callStats.setAudio(audio);
                    CdrParser.assignAudioElement(audio, element);
                    break;
                }
                default: {
                    log.warn("assignCallStatsElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignAudioElement(Audio audio, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "inbound": {
                    Inbound inbound = new Inbound();
                    audio.setInbound(inbound);
                    CdrParser.assignInboundElement(inbound, element);
                    break;
                }
                case "outbound": {
                    Outbound outbound = new Outbound();
                    audio.setOutbound(outbound);
                    CdrParser.assignOutboundElement(outbound, element);
                    break;
                }
                case "error-log": {
                    ErrorLog errorLog = new ErrorLog();
                    audio.setErrorLog(errorLog);
                    CdrParser.assignErrorLogElement(errorLog, element);
                    break;
                }
                default: {
                    log.warn("assignAudioElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignInboundElement(Inbound inbound, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "raw_bytes": {
                    inbound.setRawBytes(value);
                    break;
                }
                case "media_bytes": {
                    inbound.setMediaBytes(value);
                    break;
                }
                case "packet_count": {
                    inbound.setPacketCount(value);
                    break;
                }
                case "media_packet_count": {
                    inbound.setMediaPacketCount(value);
                    break;
                }
                case "skip_packet_count": {
                    inbound.setSkipPacketCount(value);
                    break;
                }
                case "jitter_packet_count": {
                    inbound.setJitterPacketCount(value);
                    break;
                }
                case "dtmf_packet_count": {
                    inbound.setDtmfPacketCount(value);
                    break;
                }
                case "cng_packet_count": {
                    inbound.setCngPacketCount(value);
                    break;
                }
                case "flush_packet_count": {
                    inbound.setFlushPacketCount(value);
                    break;
                }
                case "largest_jb_size": {
                    inbound.setLargestJbSize(value);
                    break;
                }
                case "jitter_min_variance": {
                    inbound.setJitterMinVariance(value);
                    break;
                }
                case "jitter_max_variance": {
                    inbound.setJitterMaxVariance(value);
                    break;
                }
                case "jitter_loss_rate": {
                    inbound.setJitterLossRate(value);
                    break;
                }
                case "jitter_burst_rate": {
                    inbound.setJitterBurstRate(value);
                    break;
                }
                case "mean_interval": {
                    inbound.setMeanInterval(value);
                    break;
                }
                case "flaw_total": {
                    inbound.setFlawTotal(value);
                    break;
                }
                case "quality_percentage": {
                    inbound.setQualityPercentage(value);
                    break;
                }
                case "mos": {
                    inbound.setMos(value);
                    break;
                }
                default: {
                    log.warn("assignInboundElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignOutboundElement(Outbound outbound, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "raw_bytes": {
                    outbound.setRawBytes(value);
                    break;
                }
                case "media_bytes": {
                    outbound.setMediaBytes(value);
                    break;
                }
                case "packet_count": {
                    outbound.setPacketCount(value);
                    break;
                }
                case "media_packet_count": {
                    outbound.setMediaPacketCount(value);
                    break;
                }
                case "skip_packet_count": {
                    outbound.setSkipPacketCount(value);
                    break;
                }
                case "dtmf_packet_count": {
                    outbound.setDtmfPacketCount(value);
                    break;
                }
                case "cng_packet_count": {
                    outbound.setCngPacketCount(value);
                    break;
                }
                case "rtcp_packet_count": {
                    outbound.setRtcpPacketCount(value);
                    break;
                }
                case "rtcp_octet_count": {
                    outbound.setRtcpOctetCount(value);
                    break;
                }
                default: {
                    log.warn("assignOutboundElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignErrorLogElement(ErrorLog errorLog, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "error-period": {
                    ErrorPeriod errorPeriod = new ErrorPeriod();
                    errorLog.addErrorPeriod(errorPeriod);
                    CdrParser.assignErrorPeriodElement(errorPeriod, element);
                    break;
                }
                default: {
                    log.warn("assignErrorLogElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignErrorPeriodElement(ErrorPeriod errorPeriod, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "start": {
                    errorPeriod.setStart(value);
                    break;
                }
                case "stop": {
                    errorPeriod.setStop(value);
                    break;
                }
                case "flaws": {
                    errorPeriod.setFlaws(value);
                    break;
                }
                case "consecutive-flaws": {
                    errorPeriod.setConsecutiveFlaws(value);
                    break;
                }
                case "duration-msec": {
                    errorPeriod.setDurationMsec(value);
                    break;
                }
                default: {
                    log.warn("assignErrorPeriodElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignVariablesElement(Variables variables, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> variables.putVariable((String)name, element.getTextTrim()));
    }

    private static void assignHoldRecordElement(HoldRecord holdRecord, Element rootElement) {
        ArrayList<Hold> holds = new ArrayList<Hold>(4);
        holdRecord.setHolds(holds);
        CdrParser.elements(rootElement, (name, element) -> {
            if (HOLD.equals(name)) {
                CdrParser.assignHoldElement(holds, element);
            } else {
                log.warn("assignHoldRecordElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
            }
        });
    }

    private static void assignHoldElement(List<Hold> holds, Element rootElement) {
        Hold hold = new Hold();
        CdrParser.attributes(rootElement, (name, value) -> {
            switch (name) {
                case "on": {
                    hold.setOn(NumberUtil.toLong(value));
                    break;
                }
                case "off": {
                    hold.setOff(NumberUtil.toLong(value));
                    break;
                }
                case "bridged-to": {
                    hold.setBridgedTo((String)value);
                    break;
                }
                default: {
                    log.warn("assignHoldElement found other attribute name : [{}], value : [{}], xml : [{}]", new Object[]{name, value, local.get()});
                }
            }
        });
        holds.add(hold);
    }

    private static void assignAppLogElement(AppLog appLog, Element rootElement) {
        ArrayList<Application> applications = new ArrayList<Application>();
        appLog.setApplications(applications);
        CdrParser.elements(rootElement, (name, element) -> {
            if (APPLICATION.equals(name)) {
                CdrParser.assignApplicationElement(applications, element);
            } else {
                log.warn("assignAppLogElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
            }
        });
    }

    private static void assignApplicationElement(List<Application> applications, Element rootElement) {
        Application application = new Application();
        CdrParser.attributes(rootElement, (name, value) -> {
            switch (name) {
                case "app_name": {
                    application.setAppName((String)value);
                    break;
                }
                case "app_data": {
                    application.setAppData((String)value);
                    break;
                }
                case "app_stamp": {
                    application.setAppStamp(NumberUtil.toLong(value));
                    break;
                }
                default: {
                    log.warn("assignApplicationElement found other attribute name : [{}], value : [{}], xml : [{}]", new Object[]{name, value, local.get()});
                }
            }
        });
        applications.add(application);
    }

    private static void assignCallflowElement(Callflow callflow, Element rootElement) {
        CdrParser.attributes(rootElement, (name, value) -> {
            switch (name) {
                case "dialplan": {
                    callflow.setDialplan((String)value);
                    break;
                }
                case "unique-id": {
                    callflow.setUniqueId((String)value);
                    break;
                }
                case "clone-of": {
                    callflow.setCloneOf((String)value);
                    break;
                }
                case "profile_index": {
                    callflow.setProfileIndex((String)value);
                    break;
                }
                default: {
                    log.warn("assignCallflowElement found other attribute name : [{}], value : [{}], xml : [{}]", new Object[]{name, value, local.get()});
                }
            }
        });
        CdrParser.elements(rootElement, (name, element) -> {
            switch (name) {
                case "extension": {
                    Extension extension = new Extension();
                    callflow.setExtension(extension);
                    CdrParser.assignExtensionElement(extension, element);
                    break;
                }
                case "caller_profile": {
                    CallerProfile callerProfile = new CallerProfile();
                    callflow.setCallerProfile(callerProfile);
                    CdrParser.assignCallerProfileElement(callerProfile, element);
                    break;
                }
                case "times": {
                    Times times = new Times();
                    callflow.setTimes(times);
                    CdrParser.assignTimesElement(times, element);
                    break;
                }
                default: {
                    log.warn("assignCallflowChildElement found other element name : [{}]], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignExtensionElement(Extension extension, Element rootElement) {
        CdrParser.attributes(rootElement, (name, value) -> {
            switch (name) {
                case "name": {
                    extension.setName((String)value);
                    break;
                }
                case "number": {
                    extension.setNumber((String)value);
                    break;
                }
                default: {
                    log.warn("assignExtensionElement found other attribute name : [{}], value : [{}], xml : [{}]", new Object[]{name, value, local.get()});
                }
            }
        });
        ArrayList<Application> applications = new ArrayList<Application>();
        extension.setApplications(applications);
        CdrParser.elements(rootElement, (name, element) -> {
            if (APPLICATION.equals(name)) {
                CdrParser.assignApplicationElement(applications, element);
            } else {
                log.warn("assignExtensionElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
            }
        });
    }

    private static void assignCallerProfileElement(CallerProfile callerProfile, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "username": {
                    callerProfile.setUsername(value);
                    break;
                }
                case "dialplan": {
                    callerProfile.setDialplan(value);
                    break;
                }
                case "caller_id_name": {
                    callerProfile.setCallerIdName(value);
                    break;
                }
                case "caller_id_number": {
                    callerProfile.setCallerIdNumber(value);
                    break;
                }
                case "callee_id_name": {
                    callerProfile.setCalleeIdName(value);
                    break;
                }
                case "callee_id_number": {
                    callerProfile.setCalleeIdNumber(value);
                    break;
                }
                case "ani": {
                    callerProfile.setAni(value);
                    break;
                }
                case "aniii": {
                    callerProfile.setAniii(value);
                    break;
                }
                case "network_addr": {
                    callerProfile.setNetworkAddr(value);
                    break;
                }
                case "rdnis": {
                    callerProfile.setRdnis(value);
                    break;
                }
                case "destination_number": {
                    callerProfile.setDestinationNumber(value);
                    break;
                }
                case "uuid": {
                    callerProfile.setUuid(value);
                    break;
                }
                case "source": {
                    callerProfile.setSource(value);
                    break;
                }
                case "transfer_source": {
                    callerProfile.setTransferSource(value);
                    break;
                }
                case "context": {
                    callerProfile.setContext(value);
                    break;
                }
                case "chan_name": {
                    callerProfile.setChanName(value);
                    break;
                }
                case "originator": {
                    Originator originator = new Originator();
                    callerProfile.setOriginator(originator);
                    CdrParser.assignOriginatorElement(originator, element);
                    break;
                }
                case "origination": {
                    Origination origination = new Origination();
                    callerProfile.setOrigination(origination);
                    CdrParser.assignOriginationElement(origination, element);
                    break;
                }
                case "originatee": {
                    Originatee originatee = new Originatee();
                    callerProfile.setOriginatee(originatee);
                    CdrParser.assignOriginateeElement(originatee, element);
                    break;
                }
                default: {
                    log.warn("assignCallerProfileElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignOriginatorElement(Originator originator, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            if (ORIGINATOR_CALLER_PROFILE.equals(name)) {
                OriginatorCallerProfile originatorCallerProfile = new OriginatorCallerProfile();
                originator.setOriginatorCallerProfile(originatorCallerProfile);
                CdrParser.assignOriginatorCallerProfileElement(originatorCallerProfile, element);
            } else {
                log.warn("assignOriginatorElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
            }
        });
    }

    private static void assignOriginatorCallerProfileElement(OriginatorCallerProfile originatorCallerProfile, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "username": {
                    originatorCallerProfile.setUsername(value);
                    break;
                }
                case "dialplan": {
                    originatorCallerProfile.setDialplan(value);
                    break;
                }
                case "caller_id_name": {
                    originatorCallerProfile.setCallerIdName(value);
                    break;
                }
                case "caller_id_number": {
                    originatorCallerProfile.setCallerIdNumber(value);
                    break;
                }
                case "callee_id_name": {
                    originatorCallerProfile.setCalleeIdName(value);
                    break;
                }
                case "callee_id_number": {
                    originatorCallerProfile.setCalleeIdNumber(value);
                    break;
                }
                case "ani": {
                    originatorCallerProfile.setAni(value);
                    break;
                }
                case "aniii": {
                    originatorCallerProfile.setAniii(value);
                    break;
                }
                case "network_addr": {
                    originatorCallerProfile.setNetworkAddr(value);
                    break;
                }
                case "rdnis": {
                    originatorCallerProfile.setRdnis(value);
                    break;
                }
                case "destination_number": {
                    originatorCallerProfile.setDestinationNumber(value);
                    break;
                }
                case "uuid": {
                    originatorCallerProfile.setUuid(value);
                    break;
                }
                case "source": {
                    originatorCallerProfile.setSource(value);
                    break;
                }
                case "context": {
                    originatorCallerProfile.setContext(value);
                    break;
                }
                case "chan_name": {
                    originatorCallerProfile.setChanName(value);
                    break;
                }
                default: {
                    log.warn("assignOriginationCallerProfileElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignOriginationElement(Origination origination, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            if (ORIGINATION_CALLER_PROFILE.equals(name)) {
                OriginationCallerProfile originationCallerProfile = new OriginationCallerProfile();
                origination.setOriginationCallerProfile(originationCallerProfile);
                CdrParser.assignOriginationCallerProfileElement(originationCallerProfile, element);
            } else {
                log.warn("assignOriginationElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
            }
        });
    }

    private static void assignOriginationCallerProfileElement(OriginationCallerProfile originationCallerProfile, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "username": {
                    originationCallerProfile.setUsername(value);
                    break;
                }
                case "dialplan": {
                    originationCallerProfile.setDialplan(value);
                    break;
                }
                case "caller_id_name": {
                    originationCallerProfile.setCallerIdName(value);
                    break;
                }
                case "caller_id_number": {
                    originationCallerProfile.setCallerIdNumber(value);
                    break;
                }
                case "callee_id_name": {
                    originationCallerProfile.setCalleeIdName(value);
                    break;
                }
                case "callee_id_number": {
                    originationCallerProfile.setCalleeIdNumber(value);
                    break;
                }
                case "ani": {
                    originationCallerProfile.setAni(value);
                    break;
                }
                case "aniii": {
                    originationCallerProfile.setAniii(value);
                    break;
                }
                case "network_addr": {
                    originationCallerProfile.setNetworkAddr(value);
                    break;
                }
                case "rdnis": {
                    originationCallerProfile.setRdnis(value);
                    break;
                }
                case "destination_number": {
                    originationCallerProfile.setDestinationNumber(value);
                    break;
                }
                case "uuid": {
                    originationCallerProfile.setUuid(value);
                    break;
                }
                case "source": {
                    originationCallerProfile.setSource(value);
                    break;
                }
                case "context": {
                    originationCallerProfile.setContext(value);
                    break;
                }
                case "chan_name": {
                    originationCallerProfile.setChanName(value);
                    break;
                }
                default: {
                    log.warn("assignOriginationCallerProfileElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignOriginateeElement(Originatee originatee, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            if (ORIGINATEE_CALLER_PROFILE.equals(name)) {
                OriginateeCallerProfile originateeCallerProfile = new OriginateeCallerProfile();
                originatee.setOriginateeCallerProfile(originateeCallerProfile);
                CdrParser.assignOriginateeCallerProfileElement(originateeCallerProfile, element);
            } else {
                log.warn("assignOriginationElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
            }
        });
    }

    private static void assignOriginateeCallerProfileElement(OriginateeCallerProfile originateeCallerProfile, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value = element.getTextTrim();
            switch (name) {
                case "username": {
                    originateeCallerProfile.setUsername(value);
                    break;
                }
                case "dialplan": {
                    originateeCallerProfile.setDialplan(value);
                    break;
                }
                case "caller_id_name": {
                    originateeCallerProfile.setCallerIdName(value);
                    break;
                }
                case "caller_id_number": {
                    originateeCallerProfile.setCallerIdNumber(value);
                    break;
                }
                case "callee_id_name": {
                    originateeCallerProfile.setCalleeIdName(value);
                    break;
                }
                case "callee_id_number": {
                    originateeCallerProfile.setCalleeIdNumber(value);
                    break;
                }
                case "ani": {
                    originateeCallerProfile.setAni(value);
                    break;
                }
                case "aniii": {
                    originateeCallerProfile.setAniii(value);
                    break;
                }
                case "network_addr": {
                    originateeCallerProfile.setNetworkAddr(value);
                    break;
                }
                case "rdnis": {
                    originateeCallerProfile.setRdnis(value);
                    break;
                }
                case "destination_number": {
                    originateeCallerProfile.setDestinationNumber(value);
                    break;
                }
                case "uuid": {
                    originateeCallerProfile.setUuid(value);
                    break;
                }
                case "source": {
                    originateeCallerProfile.setSource(value);
                    break;
                }
                case "context": {
                    originateeCallerProfile.setContext(value);
                    break;
                }
                case "chan_name": {
                    originateeCallerProfile.setChanName(value);
                    break;
                }
                default: {
                    log.warn("assignOriginateeCallerProfileElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void assignTimesElement(Times times, Element rootElement) {
        CdrParser.elements(rootElement, (name, element) -> {
            String value0 = element.getTextTrim();
            Long value = NumberUtil.toLong(value0);
            switch (name) {
                case "created_time": {
                    times.setCreatedTime(value);
                    break;
                }
                case "profile_created_time": {
                    times.setProfileCreatedTime(value);
                    break;
                }
                case "progress_time": {
                    times.setProgressTime(value);
                    break;
                }
                case "progress_media_time": {
                    times.setProgressMediaTime(value);
                    break;
                }
                case "answered_time": {
                    times.setAnsweredTime(value);
                    break;
                }
                case "bridged_time": {
                    times.setBridgedTime(value);
                    break;
                }
                case "last_hold_time": {
                    times.setLastHoldTime(value);
                    break;
                }
                case "hold_accum_time": {
                    times.setHoldAccumTime(value);
                    break;
                }
                case "hangup_time": {
                    times.setHangupTime(value);
                    break;
                }
                case "resurrect_time": {
                    times.setResurrectTime(value);
                    break;
                }
                case "transfer_time": {
                    times.setTransferTime(value);
                    break;
                }
                default: {
                    log.warn("assignTimesElement found other element name : [{}], xml : [{}]", name, (Object)local.get());
                }
            }
        });
    }

    private static void attributes(Element element, BiConsumer<String, String> consumer) {
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            attribute.getName();
            consumer.accept(attribute.getName(), attribute.getValue());
        }
    }

    private static void elements(Element rootElement, BiConsumer<String, Element> consumer) {
        List elements = rootElement.elements();
        for (Element element : elements) {
            consumer.accept(element.getName(), element);
        }
    }
}

