/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.cdr.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import link.thingscloud.freeswitch.cdr.domain.Cdr;
import link.thingscloud.freeswitch.cdr.exception.ParserException;
import link.thingscloud.freeswitch.cdr.handler.CdrHandler;
import link.thingscloud.freeswitch.cdr.parser.CdrParser;
import link.thingscloud.freeswitch.cdr.service.CdrService;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CdrServiceImpl
implements CdrService,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CdrServiceImpl.class);
    @Value(value="${cdr.pool.size:8}")
    private int poolSize;
    private ApplicationContext applicationContext;
    private List<CdrHandler> cdrHandlers = new ArrayList<CdrHandler>(4);
    private final ExecutorService poolExecutor = new ScheduledThreadPoolExecutor(this.poolSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("pool-executor-%d").daemon(true).build());

    @Override
    public void handle(String reqText) {
        this.poolExecutor.execute(() -> {
            try {
                this.handleCdr(reqText);
            }
            catch (ParserException e) {
                log.error("handleCdr failure, cause : ", (Throwable)e);
                log.error("handleCdr xml : [{}]", (Object)reqText);
            }
        });
    }

    private void handleCdr(String xml) throws ParserException {
        Cdr cdr = CdrParser.decodeThenParse(xml);
        log.debug("handleCdr cdr : [{}]", (Object)cdr);
        this.cdrHandlers.forEach(cdrHandler -> {
            try {
                cdrHandler.handleCdr(cdr);
            }
            catch (Throwable e) {
                log.error("freeswitch cdr handler[{}] handle exception : ", cdrHandler.getClass(), (Object)e);
            }
        });
    }

    public void afterPropertiesSet() {
        log.info("freeswitch cdr[{}] start ...", (Object)this.poolSize);
        Map beansOfType = this.applicationContext.getBeansOfType(CdrHandler.class);
        for (CdrHandler handler : beansOfType.values()) {
            log.info("freeswitch cdr add cdrHandler : [{}].", handler.getClass());
            this.cdrHandlers.add(handler);
        }
        if (CollectionUtils.isEmpty(this.cdrHandlers)) {
            log.warn("freeswitch cdr cdrHandlers is empty, you can implements CdrHandler to handle cdr.");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

