/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.freeswitch.cdr.util;

import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdrDecodeUtil {
    private static final Logger log = LoggerFactory.getLogger(CdrDecodeUtil.class);

    private CdrDecodeUtil() {
    }

    public static String decode(String strXml) {
        try {
            return URLDecoder.decode(strXml, "UTF-8");
        }
        catch (Exception e) {
            log.error("url decode failed, strXml : [{}]", (Object)strXml, (Object)e);
            return strXml;
        }
    }

    public static String decodeLine(String strXml) {
        String[] strs = StringUtils.split((String)strXml, (String)"\n");
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(CdrDecodeUtil.decode(str)).append("\n");
        }
        return sb.toString();
    }
}

