/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import live.lingting.virtual.currency.bitcoin.BitcoinTransactionGenerate;
import live.lingting.virtual.currency.bitcoin.contract.OmniContract;
import live.lingting.virtual.currency.bitcoin.endpoints.BitcoinCypherEndpoints;
import live.lingting.virtual.currency.bitcoin.endpoints.BitcoinEndpoints;
import live.lingting.virtual.currency.bitcoin.endpoints.BlockchainEndpoints;
import live.lingting.virtual.currency.bitcoin.endpoints.OmniEndpoints;
import live.lingting.virtual.currency.bitcoin.model.FeeAndSpent;
import live.lingting.virtual.currency.bitcoin.model.Unspent;
import live.lingting.virtual.currency.bitcoin.model.blockchain.LatestBlock;
import live.lingting.virtual.currency.bitcoin.model.blockchain.RawTransaction;
import live.lingting.virtual.currency.bitcoin.model.cypher.Balance;
import live.lingting.virtual.currency.bitcoin.model.omni.Balances;
import live.lingting.virtual.currency.bitcoin.model.omni.Domain;
import live.lingting.virtual.currency.bitcoin.model.omni.PushTx;
import live.lingting.virtual.currency.bitcoin.model.omni.TokenHistory;
import live.lingting.virtual.currency.bitcoin.model.omni.TransactionByHash;
import live.lingting.virtual.currency.bitcoin.properties.BitcoinProperties;
import live.lingting.virtual.currency.bitcoin.util.BitcoinUtils;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.Endpoints;
import live.lingting.virtual.currency.core.PlatformService;
import live.lingting.virtual.currency.core.enums.TransactionStatus;
import live.lingting.virtual.currency.core.enums.VirtualCurrencyPlatform;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.model.TransactionGenerate;
import live.lingting.virtual.currency.core.model.TransactionInfo;
import live.lingting.virtual.currency.core.model.TransferParams;
import live.lingting.virtual.currency.core.model.TransferResult;
import live.lingting.virtual.currency.core.util.AbiUtils;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.SignatureDecodeException;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.script.ScriptPattern;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinServiceImpl
implements PlatformService<BitcoinTransactionGenerate> {
    private static final Logger log = LoggerFactory.getLogger(BitcoinServiceImpl.class);
    public static final String FLAG = ".";
    private static final Map<String, Integer> CONTRACT_DECIMAL_CACHE = new ConcurrentHashMap<String, Integer>();
    private static final TransactionByHash STATIC_TRANSACTION_HASH = new TransactionByHash();
    private static final Balances STATIC_BALANCES = new Balances();
    private static final TokenHistory STATIC_TOKEN_HISTORY = new TokenHistory();
    private final BitcoinProperties properties;
    private final NetworkParameters np;
    private final BlockchainEndpoints blockchainEndpoints;
    private static final OmniEndpoints OMNI_ENDPOINTS = OmniEndpoints.MAINNET;
    private final BitcoinCypherEndpoints cypherEndpoints;

    public BitcoinServiceImpl(BitcoinProperties properties) {
        this.properties = properties;
        this.np = properties.getNp();
        if (properties.getEndpoints() == BitcoinEndpoints.MAINNET) {
            this.blockchainEndpoints = BlockchainEndpoints.MAINNET;
            this.cypherEndpoints = BitcoinCypherEndpoints.MAINNET;
        } else {
            this.blockchainEndpoints = BlockchainEndpoints.TEST;
            this.cypherEndpoints = BitcoinCypherEndpoints.TEST;
        }
    }

    public Optional<TransactionInfo> getTransactionByHash(String hash) throws Exception {
        RawTransaction rawTransaction = RawTransaction.of(this.blockchainEndpoints, hash);
        if (rawTransaction == null || StrUtil.isBlank((CharSequence)rawTransaction.getHash()) || CollectionUtil.isEmpty(rawTransaction.getOuts())) {
            return Optional.empty();
        }
        if (!rawTransaction.getResponse().contains("6a146f6d6e69")) {
            return this.btcTransactionHandler(rawTransaction);
        }
        boolean isBtc = true;
        BigInteger sumOut = BigInteger.ZERO;
        HashMap<String, BigDecimal> outInfos = new HashMap<String, BigDecimal>(rawTransaction.getOuts().size());
        for (RawTransaction.Out out : rawTransaction.getOuts()) {
            String script = out.getScript();
            if (script.startsWith("6a146f6d6e69") && script.length() == 44) {
                isBtc = false;
                break;
            }
            sumOut = this.statisticsDetails(sumOut, outInfos, out);
        }
        if (isBtc) {
            return this.btcTransactionHandler(sumOut, outInfos, rawTransaction);
        }
        TransactionByHash response = this.request(STATIC_TRANSACTION_HASH, OMNI_ENDPOINTS, hash);
        if (response.getAmount() == null || !response.getValid().booleanValue()) {
            return Optional.empty();
        }
        OmniContract contract = OmniContract.getById(response.getPropertyId());
        TransactionInfo transactionInfo = new TransactionInfo().setContract((Contract)(contract != null ? contract : AbiUtils.createContract((String)response.getPropertyId().toString()))).setBlock(response.getBlock()).setHash(hash).setValue(response.getAmount()).setVirtualCurrencyPlatform(VirtualCurrencyPlatform.BITCOIN).setTime(response.getBlockTime().longValue()).setFrom(response.getSendingAddress()).setTo(response.getReferenceAddress()).setStatus(response.getConfirmations().compareTo(BigInteger.valueOf(this.properties.getConfirmationsMin().intValue())) >= 0 ? TransactionStatus.SUCCESS : TransactionStatus.WAIT);
        return Optional.of(transactionInfo);
    }

    public Integer getDecimalsByContract(Contract contract) throws JsonProcessingException {
        if (contract == null) {
            return 0;
        }
        if (contract.getDecimals() != null) {
            return contract.getDecimals();
        }
        if (CONTRACT_DECIMAL_CACHE.containsKey(contract.getHash())) {
            return CONTRACT_DECIMAL_CACHE.get(contract.getHash());
        }
        TokenHistory history = this.request(STATIC_TOKEN_HISTORY, OMNI_ENDPOINTS, contract.getHash());
        int decimals = this.getDecimalsByString(history.getTransactions().get(0).getAmount());
        CONTRACT_DECIMAL_CACHE.put(contract.getHash(), decimals);
        return decimals;
    }

    public BigInteger getBalanceByAddressAndContract(String address, Contract contract) throws JsonProcessingException {
        if (contract == OmniContract.BTC) {
            Balance balance = Balance.of(this.cypherEndpoints, address);
            if (balance == null || StrUtil.isNotBlank((CharSequence)balance.getError()) || balance.getFinalBalance() == null) {
                return BigInteger.ZERO;
            }
            return balance.getFinalBalance();
        }
        Balances balances = this.request(STATIC_BALANCES, OMNI_ENDPOINTS, address);
        if (CollectionUtil.isEmpty(balances.getBalance())) {
            return BigInteger.ZERO;
        }
        for (Balances.Balance balance : balances.getBalance()) {
            if (!CONTRACT_DECIMAL_CACHE.containsKey(balance.getId())) {
                CONTRACT_DECIMAL_CACHE.put(contract.getHash(), this.getDecimalsByString(balance.getPropertyInfo().getTotalTokens()));
            }
            if (!balance.getId().equals(contract.getHash())) continue;
            return balance.getValue();
        }
        return BigInteger.ZERO;
    }

    public BigDecimal getNumberByBalanceAndContract(BigInteger balance, Contract contract, MathContext mathContext) throws JsonProcessingException {
        if (contract == null) {
            return new BigDecimal(balance);
        }
        if (balance == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(balance).divide(BigDecimal.TEN.pow(this.getDecimalsByContract(contract)), mathContext);
    }

    public BitcoinTransactionGenerate transactionGenerate(Account from, String to, Contract contract, BigDecimal value, TransferParams params) throws Exception {
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            return BitcoinTransactionGenerate.failed("\u8f6c\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!");
        }
        BigInteger contractAmount = BigInteger.ZERO;
        Coin btcAmount = contract == OmniContract.BTC ? BitcoinUtils.btcToCoin(value) : Coin.valueOf((long)546L);
        if (params.getSumFee() == null) {
            params.setFee(params.getFee() == null ? this.properties.feeByByte.get() : params.getFee());
        }
        FeeAndSpent fs = FeeAndSpent.of(this, contract, params, this.properties.getUnspent().apply(from.getAddress(), this.properties.getEndpoints()), btcAmount, new BigInteger(this.properties.getConfirmationsMin().toString()));
        Transaction tx = new Transaction(this.np);
        Address fromAddress = Address.fromString((NetworkParameters)this.np, (String)from.getAddress());
        Address toAddress = Address.fromString((NetworkParameters)this.np, (String)to);
        tx.addOutput(btcAmount, toAddress);
        boolean zero = fs.getZero();
        if (zero) {
            tx.addOutput(fs.getOutNumber().subtract(fs.getFee()).subtract(btcAmount), fromAddress);
        }
        if (contract != OmniContract.BTC) {
            contractAmount = this.valueToBalanceByContract(value, contract);
            String contractHex = StrUtil.format((CharSequence)"{}{}{}", (Object[])new Object[]{"6a146f6d6e69", StrUtil.padPre((CharSequence)new BigInteger(contract.getHash()).toString(16), (int)16, (CharSequence)"0"), StrUtil.padPre((CharSequence)contractAmount.toString(16), (int)16, (CharSequence)"0")});
            tx.addOutput(Coin.ZERO, new Script(Utils.HEX.decode((CharSequence)contractHex)));
        }
        for (int i = 0; i < fs.getList().size(); ++i) {
            Unspent spent = fs.getList().get(i);
            TransactionOutPoint outPoint = new TransactionOutPoint(this.np, spent.getOut().longValue(), Sha256Hash.wrap((String)spent.getHash()));
            TransactionInput input = new TransactionInput(this.np, tx, Hex.decode((String)spent.getScript()), outPoint, Coin.valueOf((long)spent.getValue().longValue()));
            tx.addInput(input);
        }
        return BitcoinTransactionGenerate.success(from, to, contract != OmniContract.BTC ? contractAmount : BitcoinUtils.coinToBtcBalance(btcAmount), contract, new BitcoinTransactionGenerate.Bitcoin(tx, fs.getFee()));
    }

    public BitcoinTransactionGenerate transactionSign(BitcoinTransactionGenerate generate) throws SignatureDecodeException {
        boolean error;
        boolean bl = error = generate.getSuccess() == false;
        if (error) {
            return generate;
        }
        Transaction tx = generate.getBitcoin().getTransaction();
        Account from = generate.getFrom();
        List<ECKey> keys = this.getEcKeysByFrom(from);
        for (int inputIndex = 0; inputIndex < tx.getInputs().size(); ++inputIndex) {
            TransactionSignature signature;
            boolean isNativeP2sh;
            TransactionInput txIn = tx.getInput((long)inputIndex);
            Script script = txIn.getScriptSig();
            boolean bl2 = isNativeP2sh = from.getMulti() != false && (generate.getBitcoin().getFirstSign() == false || ScriptPattern.isP2SH((Script)script));
            if (isNativeP2sh) {
                ArrayList<TransactionSignature> signatures = new ArrayList<TransactionSignature>(from.getMultiNum());
                if (!generate.getBitcoin().getFirstSign().booleanValue()) {
                    Iterator<Object> sci = txIn.getScriptSig().getChunks().iterator();
                    while (sci.hasNext()) {
                        ScriptChunk sc = (ScriptChunk)sci.next();
                        if (sc.opcode == 0 || !sci.hasNext()) continue;
                        signature = TransactionSignature.decodeFromBitcoin((byte[])sc.data, (boolean)true, (boolean)true);
                        signatures.add(signature);
                    }
                }
                script = ScriptBuilder.createMultiSigOutputScript((int)from.getMultiNum(), keys);
                for (ECKey ecKey : keys) {
                    if (signatures.size() == from.getMultiNum().intValue() || !ecKey.hasPrivKey()) continue;
                    signatures.add(new TransactionSignature(ecKey.sign(tx.hashForSignature(inputIndex, script, Transaction.SigHash.ALL, false)), Transaction.SigHash.ALL, false));
                }
                Script scriptSig = ScriptBuilder.createP2SHMultiSigInputScript(signatures, (Script)script);
                txIn.setScriptSig(scriptSig);
                continue;
            }
            ECKey key = keys.get(0);
            if (ScriptPattern.isP2SH((Script)script)) {
                Script redeemScript = ScriptBuilder.createP2WPKHOutputScript((ECKey)key);
                Script witnessScript = ScriptBuilder.createP2PKHOutputScript((ECKey)key);
                signature = tx.calculateWitnessSignature(inputIndex, key, witnessScript, txIn.getValue(), Transaction.SigHash.ALL, false);
                txIn.setWitness(TransactionWitness.redeemP2WPKH((TransactionSignature)signature, (ECKey)key));
                txIn.setScriptSig(new ScriptBuilder().data(redeemScript.getProgram()).build());
                continue;
            }
            if (ScriptPattern.isP2WPKH((Script)script)) {
                script = ScriptBuilder.createP2PKHOutputScript((ECKey)key);
                TransactionSignature signature2 = tx.calculateWitnessSignature(inputIndex, key, script, txIn.getValue(), Transaction.SigHash.ALL, false);
                txIn.setScriptSig(ScriptBuilder.createEmpty());
                txIn.setWitness(TransactionWitness.redeemP2WPKH((TransactionSignature)signature2, (ECKey)key));
                continue;
            }
            TransactionSignature txSignature = tx.calculateSignature(inputIndex, key, script, Transaction.SigHash.ALL, false);
            if (ScriptPattern.isP2PK((Script)script)) {
                txIn.setScriptSig(ScriptBuilder.createInputScript((TransactionSignature)txSignature));
                continue;
            }
            if (ScriptPattern.isP2PKH((Script)script)) {
                txIn.setScriptSig(ScriptBuilder.createInputScript((TransactionSignature)txSignature, (ECKey)key));
                continue;
            }
            return BitcoinTransactionGenerate.failed("\u65e0\u6cd5\u89e3\u6790\u6b64\u811a\u672c!");
        }
        tx.verify();
        Context.getOrCreate((NetworkParameters)this.np);
        tx.getConfidence().setSource(TransactionConfidence.Source.SELF);
        tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
        String raw = Hex.toHexString((byte[])tx.bitcoinSerialize());
        generate.setSignHex(raw);
        return generate;
    }

    public TransferResult transactionBroadcast(BitcoinTransactionGenerate generate) throws Exception {
        boolean error;
        boolean bl = error = generate.getSuccess() == false;
        if (error) {
            return TransferResult.failed((TransactionGenerate)generate);
        }
        PushTx pushTx = this.properties.getBroadcastTransaction().apply(generate.getSignHex(), OMNI_ENDPOINTS);
        if (!pushTx.isSuccess()) {
            if (pushTx.getE() != null) {
                return TransferResult.failed((Throwable)pushTx.getE());
            }
            return TransferResult.failed((String)"\u8f6c\u8d26\u5931\u8d25");
        }
        return TransferResult.success((String)pushTx.getTxId());
    }

    public boolean validate(String address) {
        Balance balance = Balance.of(this.cypherEndpoints, address);
        return StrUtil.isBlank((CharSequence)balance.getError());
    }

    private int getDecimalsByString(String str) {
        if (!str.contains(FLAG)) {
            return 0;
        }
        return str.substring(str.indexOf(FLAG)).length() - 1;
    }

    public long sleepTime() {
        return TimeUnit.SECONDS.toMillis(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T request(Domain<T> domain, Endpoints endpoints, Object params) throws JsonProcessingException {
        boolean lock = this.properties.getLock().get();
        if (lock) {
            try {
                T t = domain.of(endpoints, params);
                return t;
            }
            finally {
                this.properties.getUnlock().get();
            }
        }
        ThreadUtil.sleep((long)this.sleepTime());
        return this.request(domain, endpoints, params);
    }

    private Optional<TransactionInfo> btcTransactionHandler(RawTransaction rawTransaction) throws Exception {
        BigInteger sumOut = BigInteger.ZERO;
        HashMap<String, BigDecimal> outInfos = new HashMap<String, BigDecimal>(rawTransaction.getOuts().size());
        for (RawTransaction.Out out : rawTransaction.getOuts()) {
            sumOut = this.statisticsDetails(sumOut, outInfos, out);
        }
        return this.btcTransactionHandler(sumOut, outInfos, rawTransaction);
    }

    private Optional<TransactionInfo> btcTransactionHandler(BigInteger sumOut, Map<String, BigDecimal> outInfos, RawTransaction rawTransaction) throws Exception {
        BigInteger sumIn = BigInteger.ZERO;
        HashMap<String, BigDecimal> inInfos = new HashMap<String, BigDecimal>(rawTransaction.getIns().size());
        for (RawTransaction.In in : rawTransaction.getIns()) {
            sumIn = this.statisticsDetails(sumIn, inInfos, in.getPrevOut());
        }
        BigDecimal fee = this.getNumberByBalanceAndContract(sumIn.subtract(sumOut), OmniContract.BTC);
        TransactionInfo transactionInfo = new TransactionInfo().setContract((Contract)OmniContract.BTC).setBlock(rawTransaction.getBlockHeight()).setHash(rawTransaction.getHash()).setVirtualCurrencyPlatform(VirtualCurrencyPlatform.BITCOIN).setTime(rawTransaction.getTime().longValue()).setBtcInfo(new TransactionInfo.BtcInfo(inInfos, outInfos, fee));
        if (rawTransaction.getBlockHeight() == null) {
            transactionInfo.setStatus(TransactionStatus.WAIT);
        } else {
            LatestBlock block = LatestBlock.of(this.blockchainEndpoints);
            BigInteger confirmationNumber = block.getHeight().subtract(transactionInfo.getBlock());
            transactionInfo.setStatus(confirmationNumber.compareTo(BigInteger.valueOf(this.properties.getConfirmationsMin().intValue())) >= 0 ? TransactionStatus.SUCCESS : TransactionStatus.WAIT);
        }
        return Optional.of(transactionInfo);
    }

    private BigInteger statisticsDetails(BigInteger sumIn, Map<String, BigDecimal> inInfos, RawTransaction.Out out) throws Exception {
        sumIn = sumIn.add(out.getValue());
        if (inInfos.containsKey(out.getAddr())) {
            inInfos.put(out.getAddr(), inInfos.get(out.getAddr()).add(this.getNumberByBalanceAndContract(out.getValue(), OmniContract.BTC)));
        } else {
            inInfos.put(out.getAddr(), this.getNumberByBalanceAndContract(out.getValue(), OmniContract.BTC));
        }
        return sumIn;
    }

    private List<ECKey> getEcKeysByFrom(Account from) {
        ArrayList keys;
        if (from.getMulti().booleanValue()) {
            keys = new ArrayList(from.getPublicKeyArray().size());
            List publicKeyArray = from.getPublicKeyArray();
            for (int keyIndex = 0; keyIndex < publicKeyArray.size(); ++keyIndex) {
                if (StrUtil.isBlank((CharSequence)((CharSequence)from.getPrivateKeyArray().get(keyIndex)))) {
                    keys.add(ECKey.fromPublicOnly((byte[])Hex.decode((String)((String)publicKeyArray.get(keyIndex)))));
                    continue;
                }
                ECKey ecKey = ECKey.fromPrivate((byte[])Hex.decode((String)((String)from.getPrivateKeyArray().get(keyIndex))));
                keys.add(ecKey);
            }
        } else {
            keys = ListUtil.toList((Object[])new ECKey[]{ECKey.fromPrivate((byte[])Hex.decode((String)from.getPrivateKey()))});
        }
        return keys;
    }

    public static Map<String, Integer> getCONTRACT_DECIMAL_CACHE() {
        return CONTRACT_DECIMAL_CACHE;
    }
}

