/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin;

import java.math.BigInteger;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.model.TransactionGenerate;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bouncycastle.util.encoders.Hex;

public class BitcoinTransactionGenerate
extends TransactionGenerate {
    private Bitcoin bitcoin;

    public static BitcoinTransactionGenerate failed(String message) {
        BitcoinTransactionGenerate generate = new BitcoinTransactionGenerate();
        generate.setSuccess(false).setMessage(message);
        return generate;
    }

    public static BitcoinTransactionGenerate failed(Throwable e) {
        BitcoinTransactionGenerate generate = new BitcoinTransactionGenerate();
        generate.setSuccess(false).setMessage(e.getMessage()).setException(e);
        return generate;
    }

    private static BitcoinTransactionGenerate success(Account from, String to, BigInteger amount, Contract contract) {
        BitcoinTransactionGenerate generate = new BitcoinTransactionGenerate();
        generate.setSuccess(true).setContract(contract).setFrom(from).setTo(to).setAmount(amount);
        return generate;
    }

    public static BitcoinTransactionGenerate success(Account from, String to, BigInteger amount, Contract contract, Bitcoin data) {
        return BitcoinTransactionGenerate.success(from, to, amount, contract).setBitcoin(data);
    }

    public static BitcoinTransactionGenerate ofBitcoinRaw(Account from, NetworkParameters np, String raw) {
        return BitcoinTransactionGenerate.ofBitcoinRaw(from, new Transaction(np, Hex.decode((String)raw)));
    }

    public static BitcoinTransactionGenerate ofBitcoinRaw(Account from, Transaction transaction) {
        BitcoinTransactionGenerate generate = new BitcoinTransactionGenerate();
        generate.setFrom(from).setSuccess(Boolean.valueOf(true));
        return generate.setBitcoin(new Bitcoin().setTransaction(transaction).setFirstSign(false));
    }

    public Bitcoin getBitcoin() {
        return this.bitcoin;
    }

    public BitcoinTransactionGenerate setBitcoin(Bitcoin bitcoin) {
        this.bitcoin = bitcoin;
        return this;
    }

    public static class Bitcoin {
        Transaction transaction;
        Coin sumFee;
        Boolean firstSign = true;

        public Bitcoin(Transaction transaction, Coin sumFee) {
            this.transaction = transaction;
            this.sumFee = sumFee;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public Coin getSumFee() {
            return this.sumFee;
        }

        public Boolean getFirstSign() {
            return this.firstSign;
        }

        public Bitcoin setTransaction(Transaction transaction) {
            this.transaction = transaction;
            return this;
        }

        public Bitcoin setSumFee(Coin sumFee) {
            this.sumFee = sumFee;
            return this;
        }

        public Bitcoin setFirstSign(Boolean firstSign) {
            this.firstSign = firstSign;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bitcoin)) {
                return false;
            }
            Bitcoin other = (Bitcoin)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Transaction this$transaction = this.getTransaction();
            Transaction other$transaction = other.getTransaction();
            if (this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction)) {
                return false;
            }
            Coin this$sumFee = this.getSumFee();
            Coin other$sumFee = other.getSumFee();
            if (this$sumFee == null ? other$sumFee != null : !this$sumFee.equals(other$sumFee)) {
                return false;
            }
            Boolean this$firstSign = this.getFirstSign();
            Boolean other$firstSign = other.getFirstSign();
            return !(this$firstSign == null ? other$firstSign != null : !((Object)this$firstSign).equals(other$firstSign));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bitcoin;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Transaction $transaction = this.getTransaction();
            result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
            Coin $sumFee = this.getSumFee();
            result = result * 59 + ($sumFee == null ? 43 : $sumFee.hashCode());
            Boolean $firstSign = this.getFirstSign();
            result = result * 59 + ($firstSign == null ? 43 : ((Object)$firstSign).hashCode());
            return result;
        }

        public String toString() {
            return "BitcoinTransactionGenerate.Bitcoin(transaction=" + this.getTransaction() + ", sumFee=" + this.getSumFee() + ", firstSign=" + this.getFirstSign() + ")";
        }

        public Bitcoin() {
        }
    }
}

