/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import live.lingting.virtual.currency.bitcoin.BitcoinServiceImpl;
import live.lingting.virtual.currency.bitcoin.contract.OmniContract;
import live.lingting.virtual.currency.bitcoin.model.Unspent;
import live.lingting.virtual.currency.bitcoin.util.BitcoinUtils;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.exception.InsufficientBalanceException;
import live.lingting.virtual.currency.core.model.TransferParams;
import org.bitcoinj.core.Coin;

public class FeeAndSpent {
    private Coin fee;
    private Coin outNumber;
    private List<Unspent> list;
    private Boolean zero = false;

    public static FeeAndSpent of(BitcoinServiceImpl service, Contract contract, TransferParams params, List<Unspent> unspentList, Coin amount, BigInteger min) throws Exception {
        ArrayList<Unspent> useList = new ArrayList<Unspent>();
        Coin outNumber = Coin.ZERO;
        Coin sumFee = Coin.ZERO;
        boolean isZero = false;
        int baseOutNumber = 1;
        if (contract != OmniContract.BTC) {
            baseOutNumber = 2;
        }
        for (Unspent unspent : unspentList) {
            if (unspent.getConfirmations().compareTo(min) < 0) continue;
            Coin coin = BitcoinUtils.getSumFee((long)useList.size(), (long)baseOutNumber, params);
            Coin number = amount.add(coin);
            if (outNumber.compareTo(number) >= 0) {
                Coin zeroCoin = FeeAndSpent.zeroNumber(params, coin);
                if (outNumber.compareTo(amount.add(zeroCoin)) > 0) {
                    isZero = true;
                    sumFee = zeroCoin;
                    break;
                }
                isZero = false;
                sumFee = outNumber.subtract(amount);
                break;
            }
            useList.add(unspent);
            outNumber = outNumber.add(BitcoinUtils.btcToCoin(service.getNumberByBalanceAndContract(unspent.getValue(), contract)));
        }
        if (sumFee.compareTo(Coin.ZERO) == 0) {
            Coin coin = BitcoinUtils.getSumFee((long)useList.size(), (long)baseOutNumber, params);
            if (outNumber.compareTo(coin.add(amount)) >= 0) {
                Coin zeroCoin = FeeAndSpent.zeroNumber(params, coin);
                if (outNumber.compareTo(zeroCoin.add(amount)) > 0) {
                    isZero = true;
                    sumFee = zeroCoin;
                } else {
                    isZero = false;
                    sumFee = outNumber.subtract(amount);
                }
            } else {
                throw new InsufficientBalanceException(coin);
            }
        }
        return new FeeAndSpent(sumFee, outNumber, useList, isZero);
    }

    public static Coin zeroNumber(TransferParams params, Coin coin) {
        if (params.getSumFee() != null) {
            return params.getSumFee();
        }
        return coin.add(params.getFee().multiply(34L));
    }

    public Coin getFee() {
        return this.fee;
    }

    public Coin getOutNumber() {
        return this.outNumber;
    }

    public List<Unspent> getList() {
        return this.list;
    }

    public Boolean getZero() {
        return this.zero;
    }

    public void setFee(Coin fee) {
        this.fee = fee;
    }

    public void setOutNumber(Coin outNumber) {
        this.outNumber = outNumber;
    }

    public void setList(List<Unspent> list) {
        this.list = list;
    }

    public void setZero(Boolean zero) {
        this.zero = zero;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeeAndSpent)) {
            return false;
        }
        FeeAndSpent other = (FeeAndSpent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Coin this$fee = this.getFee();
        Coin other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) {
            return false;
        }
        Coin this$outNumber = this.getOutNumber();
        Coin other$outNumber = other.getOutNumber();
        if (this$outNumber == null ? other$outNumber != null : !this$outNumber.equals(other$outNumber)) {
            return false;
        }
        List<Unspent> this$list = this.getList();
        List<Unspent> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Boolean this$zero = this.getZero();
        Boolean other$zero = other.getZero();
        return !(this$zero == null ? other$zero != null : !((Object)this$zero).equals(other$zero));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeeAndSpent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Coin $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : $fee.hashCode());
        Coin $outNumber = this.getOutNumber();
        result = result * 59 + ($outNumber == null ? 43 : $outNumber.hashCode());
        List<Unspent> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Boolean $zero = this.getZero();
        result = result * 59 + ($zero == null ? 43 : ((Object)$zero).hashCode());
        return result;
    }

    public String toString() {
        return "FeeAndSpent(fee=" + this.getFee() + ", outNumber=" + this.getOutNumber() + ", list=" + this.getList() + ", zero=" + this.getZero() + ")";
    }

    public FeeAndSpent() {
    }

    public FeeAndSpent(Coin fee, Coin outNumber, List<Unspent> list, Boolean zero) {
        this.fee = fee;
        this.outNumber = outNumber;
        this.list = list;
        this.zero = zero;
    }
}

