/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.model;

import cn.hutool.http.HttpRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import live.lingting.virtual.currency.bitcoin.endpoints.BitcoinEndpoints;
import live.lingting.virtual.currency.bitcoin.endpoints.BitcoinSochainEndpoints;
import live.lingting.virtual.currency.bitcoin.endpoints.BlockchainEndpoints;
import live.lingting.virtual.currency.bitcoin.model.Unspent;
import live.lingting.virtual.currency.bitcoin.model.blockchain.BlockchainUnspentRes;
import live.lingting.virtual.currency.bitcoin.model.sochain.SochainUnspentRes;
import live.lingting.virtual.currency.core.util.JacksonUtils;

public abstract class UnspentRes {
    public static UnspentRes of(BitcoinEndpoints bitcoinEndpoints, int min, String address) throws JsonProcessingException {
        boolean isSochain = bitcoinEndpoints == BitcoinEndpoints.TEST;
        Enum endpoints = !isSochain ? BlockchainEndpoints.MAINNET : BitcoinSochainEndpoints.TEST;
        HttpRequest request = isSochain ? HttpRequest.get((String)endpoints.getHttpUrl("v2/get_tx_unspent/BTCTEST/" + address)) : HttpRequest.get((String)endpoints.getHttpUrl("unspent?confirmations=" + min + "&active=" + address));
        String response = request.execute().body();
        if (isSochain) {
            if (response.contains("fail")) {
                return new SochainUnspentRes();
            }
            return (UnspentRes)JacksonUtils.toObj((String)response, SochainUnspentRes.class);
        }
        if (response.equals("No free outputs to spend")) {
            return new BlockchainUnspentRes().setUnspentList(new ArrayList<BlockchainUnspentRes.BlockchainUnspent>());
        }
        return (UnspentRes)JacksonUtils.toObj((String)response, BlockchainUnspentRes.class);
    }

    public abstract List<Unspent> toUnspentList();
}

