/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.model.blockchain;

import cn.hutool.core.collection.CollectionUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import live.lingting.virtual.currency.bitcoin.model.Unspent;
import live.lingting.virtual.currency.bitcoin.model.UnspentRes;

public class BlockchainUnspentRes
extends UnspentRes {
    public static final String ERROR = "No free outputs to spend";
    @JsonProperty(value="notice")
    private String notice;
    @JsonProperty(value="unspent_outputs")
    private List<BlockchainUnspent> unspentList;

    @Override
    public List<Unspent> toUnspentList() {
        if (CollectionUtil.isEmpty(this.unspentList)) {
            return Collections.emptyList();
        }
        ArrayList<Unspent> list = new ArrayList<Unspent>(this.unspentList.size());
        for (BlockchainUnspent un : this.unspentList) {
            list.add(new Unspent().setHash(un.txHashBigEndian).setConfirmations(un.confirmations).setOut(un.txOutputN).setScript(un.script).setValue(un.value));
        }
        return list;
    }

    public String getNotice() {
        return this.notice;
    }

    public List<BlockchainUnspent> getUnspentList() {
        return this.unspentList;
    }

    @JsonProperty(value="notice")
    public BlockchainUnspentRes setNotice(String notice) {
        this.notice = notice;
        return this;
    }

    @JsonProperty(value="unspent_outputs")
    public BlockchainUnspentRes setUnspentList(List<BlockchainUnspent> unspentList) {
        this.unspentList = unspentList;
        return this;
    }

    public static class BlockchainUnspent {
        @JsonProperty(value="tx_hash")
        private String txHash;
        @JsonProperty(value="tx_hash_big_endian")
        private String txHashBigEndian;
        @JsonProperty(value="tx_output_n")
        private Long txOutputN;
        @JsonProperty(value="script")
        private String script;
        @JsonProperty(value="value")
        private BigInteger value;
        @JsonProperty(value="value_hex")
        private String valueHex;
        @JsonProperty(value="confirmations")
        private BigInteger confirmations;
        @JsonProperty(value="tx_index")
        private BigInteger txIndex;

        public String getTxId() {
            return this.txHashBigEndian;
        }

        public String getTxHash() {
            return this.txHash;
        }

        public String getTxHashBigEndian() {
            return this.txHashBigEndian;
        }

        public Long getTxOutputN() {
            return this.txOutputN;
        }

        public String getScript() {
            return this.script;
        }

        public BigInteger getValue() {
            return this.value;
        }

        public String getValueHex() {
            return this.valueHex;
        }

        public BigInteger getConfirmations() {
            return this.confirmations;
        }

        public BigInteger getTxIndex() {
            return this.txIndex;
        }

        @JsonProperty(value="tx_hash")
        public BlockchainUnspent setTxHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        @JsonProperty(value="tx_hash_big_endian")
        public BlockchainUnspent setTxHashBigEndian(String txHashBigEndian) {
            this.txHashBigEndian = txHashBigEndian;
            return this;
        }

        @JsonProperty(value="tx_output_n")
        public BlockchainUnspent setTxOutputN(Long txOutputN) {
            this.txOutputN = txOutputN;
            return this;
        }

        @JsonProperty(value="script")
        public BlockchainUnspent setScript(String script) {
            this.script = script;
            return this;
        }

        @JsonProperty(value="value")
        public BlockchainUnspent setValue(BigInteger value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="value_hex")
        public BlockchainUnspent setValueHex(String valueHex) {
            this.valueHex = valueHex;
            return this;
        }

        @JsonProperty(value="confirmations")
        public BlockchainUnspent setConfirmations(BigInteger confirmations) {
            this.confirmations = confirmations;
            return this;
        }

        @JsonProperty(value="tx_index")
        public BlockchainUnspent setTxIndex(BigInteger txIndex) {
            this.txIndex = txIndex;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockchainUnspent)) {
                return false;
            }
            BlockchainUnspent other = (BlockchainUnspent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$txHash = this.getTxHash();
            String other$txHash = other.getTxHash();
            if (this$txHash == null ? other$txHash != null : !this$txHash.equals(other$txHash)) {
                return false;
            }
            String this$txHashBigEndian = this.getTxHashBigEndian();
            String other$txHashBigEndian = other.getTxHashBigEndian();
            if (this$txHashBigEndian == null ? other$txHashBigEndian != null : !this$txHashBigEndian.equals(other$txHashBigEndian)) {
                return false;
            }
            Long this$txOutputN = this.getTxOutputN();
            Long other$txOutputN = other.getTxOutputN();
            if (this$txOutputN == null ? other$txOutputN != null : !((Object)this$txOutputN).equals(other$txOutputN)) {
                return false;
            }
            String this$script = this.getScript();
            String other$script = other.getScript();
            if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
                return false;
            }
            BigInteger this$value = this.getValue();
            BigInteger other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$valueHex = this.getValueHex();
            String other$valueHex = other.getValueHex();
            if (this$valueHex == null ? other$valueHex != null : !this$valueHex.equals(other$valueHex)) {
                return false;
            }
            BigInteger this$confirmations = this.getConfirmations();
            BigInteger other$confirmations = other.getConfirmations();
            if (this$confirmations == null ? other$confirmations != null : !((Object)this$confirmations).equals(other$confirmations)) {
                return false;
            }
            BigInteger this$txIndex = this.getTxIndex();
            BigInteger other$txIndex = other.getTxIndex();
            return !(this$txIndex == null ? other$txIndex != null : !((Object)this$txIndex).equals(other$txIndex));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlockchainUnspent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $txHash = this.getTxHash();
            result = result * 59 + ($txHash == null ? 43 : $txHash.hashCode());
            String $txHashBigEndian = this.getTxHashBigEndian();
            result = result * 59 + ($txHashBigEndian == null ? 43 : $txHashBigEndian.hashCode());
            Long $txOutputN = this.getTxOutputN();
            result = result * 59 + ($txOutputN == null ? 43 : ((Object)$txOutputN).hashCode());
            String $script = this.getScript();
            result = result * 59 + ($script == null ? 43 : $script.hashCode());
            BigInteger $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $valueHex = this.getValueHex();
            result = result * 59 + ($valueHex == null ? 43 : $valueHex.hashCode());
            BigInteger $confirmations = this.getConfirmations();
            result = result * 59 + ($confirmations == null ? 43 : ((Object)$confirmations).hashCode());
            BigInteger $txIndex = this.getTxIndex();
            result = result * 59 + ($txIndex == null ? 43 : ((Object)$txIndex).hashCode());
            return result;
        }

        public String toString() {
            return "BlockchainUnspentRes.BlockchainUnspent(txHash=" + this.getTxHash() + ", txHashBigEndian=" + this.getTxHashBigEndian() + ", txOutputN=" + this.getTxOutputN() + ", script=" + this.getScript() + ", value=" + this.getValue() + ", valueHex=" + this.getValueHex() + ", confirmations=" + this.getConfirmations() + ", txIndex=" + this.getTxIndex() + ")";
        }
    }
}

